/*
 * Decompiled with CFR 0.152.
 */
package extracells.network.packet;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import cpw.mods.fml.relauncher.Side;
import extracells.network.AbstractPacket;
import extracells.tileentity.TileEntityTerminalFluid;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class PacketTerminalFluid
extends AbstractPacket {
    World world;
    int x;
    int y;
    int z;
    int fluidID;
    int amount;
    byte type;

    public PacketTerminalFluid(World world, int x, int y, int z, FluidStack stack) {
        this.type = 0;
        this.world = world;
        this.x = x;
        this.y = y;
        this.z = z;
        this.fluidID = stack.fluidID;
        this.amount = stack.amount;
    }

    public PacketTerminalFluid(World world, int x, int y, int z, Fluid fluid) {
        this.type = 1;
        this.world = world;
        this.x = x;
        this.y = y;
        this.z = z;
        this.fluidID = fluid.getID();
    }

    public PacketTerminalFluid() {
    }

    @Override
    public void write(ByteArrayDataOutput out) {
        out.writeByte((int)this.type);
        out.writeInt(this.world.field_73011_w.field_76574_g);
        out.writeInt(this.x);
        out.writeInt(this.y);
        out.writeInt(this.z);
        out.writeInt(this.fluidID);
        out.writeInt(this.amount);
    }

    @Override
    public void read(ByteArrayDataInput in) throws AbstractPacket.ProtocolException {
        this.type = in.readByte();
        this.world = DimensionManager.getWorld((int)in.readInt());
        this.x = in.readInt();
        this.y = in.readInt();
        this.z = in.readInt();
        this.fluidID = in.readInt();
        this.amount = in.readInt();
    }

    @Override
    public void execute(EntityPlayer player, Side side) throws AbstractPacket.ProtocolException {
        if (side.isServer()) {
            TileEntityTerminalFluid tile = (TileEntityTerminalFluid)this.world.func_72796_p(this.x, this.y, this.z);
            switch (this.type) {
                case 0: {
                    tile.requestFluid(new FluidStack(this.fluidID, this.amount));
                    break;
                }
                case 1: {
                    tile.setCurrentFluid(this.fluidID);
                    break;
                }
            }
        }
    }
}

