/*
 * Decompiled with CFR 0.152.
 */
package extracells.handler;

import appeng.api.IAEItemStack;
import appeng.api.IItemList;
import appeng.api.Util;
import appeng.api.config.FuzzyMode;
import appeng.api.config.ItemFlow;
import appeng.api.config.ListMode;
import appeng.api.me.util.IGridInterface;
import appeng.api.me.util.IMEInventoryHandler;
import extracells.ItemEnum;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;

public class FluidStorageInventoryHandler
implements IMEInventoryHandler {
    private ItemStack storage;
    private long totalBytes;
    private int totalTypes;
    private int priority;
    private TileEntity updateTarget;
    private IGridInterface grid;
    private IMEInventoryHandler parent;
    private List<FluidStack> cachedInventory;
    private List<Fluid> cachedPreformats = new ArrayList<Fluid>(63);
    private Item fluidItem = ItemEnum.FLUIDDISPLAY.getItemInstance();
    private ListMode preformattedMode = ListMode.WHITELIST;
    private String cachedName;

    public FluidStorageInventoryHandler(ItemStack itemstack, long totalBytes, int totalTypes) {
        int i;
        this.storage = itemstack;
        this.totalBytes = totalBytes;
        this.totalTypes = totalTypes;
        this.cachedInventory = new ArrayList<FluidStack>(totalTypes);
        for (i = 0; i < totalTypes; ++i) {
            this.cachedInventory.add(this.readFluidStackFromSlot(i));
        }
        this.cachedName = this.readNameFromNBT();
        for (i = 0; i < 63; ++i) {
            this.cachedPreformats.add(this.getPreformattedFluid(i));
        }
        this.preformattedMode = this.readPreformattedMode();
    }

    public long storedItemTypes() {
        int storedFluidTypes = 0;
        for (int i = 0; i < this.totalTypes; ++i) {
            if (this.cachedInventory.get(i) == null) continue;
            ++storedFluidTypes;
        }
        return storedFluidTypes;
    }

    public long storedItemCount() {
        int storedFluidAmount = 0;
        for (int i = 0; i < this.totalTypes; ++i) {
            FluidStack currentStack = this.cachedInventory.get(i);
            storedFluidAmount += currentStack != null ? currentStack.amount : 0;
        }
        return storedFluidAmount;
    }

    public long remainingItemCount() {
        long remainingFluidSpace = this.totalBytes;
        for (int i = 0; i < this.totalTypes; ++i) {
            FluidStack currentStack = this.cachedInventory.get(i);
            remainingFluidSpace -= currentStack != null ? (long)currentStack.amount : 0L;
        }
        return remainingFluidSpace < 0L ? 0L : remainingFluidSpace;
    }

    public long remainingItemTypes() {
        long remainingFluidTypes = this.totalBytes;
        for (int i = 0; i < this.totalTypes; ++i) {
            if (this.cachedInventory.get(i) != null) continue;
            ++remainingFluidTypes;
        }
        return remainingFluidTypes;
    }

    public boolean containsItemType(IAEItemStack aeitemstack) {
        if (aeitemstack != null && aeitemstack.getItem() == this.fluidItem) {
            for (int i = 0; i < this.totalTypes; ++i) {
                FluidStack currentStack = this.cachedInventory.get(i);
                if (currentStack == null || currentStack.fluidID != aeitemstack.getItemDamage()) continue;
                return true;
            }
        }
        return false;
    }

    public long getTotalItemTypes() {
        return this.totalTypes;
    }

    public long countOfItemType(IAEItemStack aeitemstack) {
        long countOfFluidType = 0L;
        if (aeitemstack != null && aeitemstack.getItem() == this.fluidItem) {
            for (int i = 0; i < this.totalTypes; ++i) {
                FluidStack currentStack = this.cachedInventory.get(i);
                if (currentStack == null || currentStack.fluidID != aeitemstack.getItemDamage()) continue;
                countOfFluidType += (long)currentStack.amount;
            }
        }
        return countOfFluidType;
    }

    public IAEItemStack addItems(IAEItemStack input) {
        IAEItemStack addedStack = input.copy();
        if (input.getItem() == this.fluidItem && (!this.isPreformatted() || this.isPreformatted() && this.isItemInPreformattedItems(input.getItemStack()))) {
            FluidStack currentStack;
            int i;
            for (i = 0; i < this.totalTypes; ++i) {
                currentStack = this.cachedInventory.get(i);
                if (currentStack == null || currentStack.fluidID != input.getItemDamage()) continue;
                if (input.getStackSize() <= this.freeBytes()) {
                    this.writeFluidStackToSlot(i, new FluidStack(input.getItemDamage(), currentStack.amount + (int)input.getStackSize()));
                    addedStack = null;
                } else {
                    this.writeFluidStackToSlot(i, new FluidStack(input.getItemDamage(), currentStack.amount + (int)this.freeBytes()));
                    addedStack.setStackSize(input.getStackSize() - this.freeBytes());
                }
                return addedStack;
            }
            for (i = 0; i < this.totalTypes; ++i) {
                currentStack = this.cachedInventory.get(i);
                if (currentStack != null) continue;
                if (input.getStackSize() <= this.freeBytes()) {
                    this.writeFluidStackToSlot(i, new FluidStack(input.getItemDamage(), (int)input.getStackSize()));
                    addedStack = null;
                } else {
                    this.writeFluidStackToSlot(i, new FluidStack(input.getItemDamage(), (int)this.freeBytes()));
                    addedStack.setStackSize(input.getStackSize() - this.freeBytes());
                }
                return addedStack;
            }
        }
        return addedStack;
    }

    public IAEItemStack calculateItemAddition(IAEItemStack input) {
        if (input.getItem() == this.fluidItem && (!this.isPreformatted() || this.isPreformatted() && this.isItemInPreformattedItems(input.getItemStack()))) {
            IAEItemStack addedStack = input.copy();
            for (int i = 0; i < this.totalTypes; ++i) {
                FluidStack currentStack = this.cachedInventory.get(i);
                if (currentStack != null && currentStack.fluidID != input.getItemDamage()) continue;
                if (input.getStackSize() <= this.freeBytes()) {
                    addedStack = null;
                } else {
                    addedStack.setStackSize(input.getStackSize() - this.freeBytes());
                }
                return addedStack;
            }
        }
        return input;
    }

    public IAEItemStack extractItems(IAEItemStack request) {
        IAEItemStack removedStack = request.copy();
        if (request.getItem() == this.fluidItem) {
            for (int i = 0; i < this.totalTypes; ++i) {
                FluidStack currentStack = this.cachedInventory.get(i);
                if (currentStack == null || currentStack.fluidID != request.getItemDamage()) continue;
                if ((long)currentStack.amount - request.getStackSize() >= 0L) {
                    removedStack.setStackSize(request.getStackSize());
                    if ((long)currentStack.amount - request.getStackSize() == 0L) {
                        this.writeFluidStackToSlot(i, null);
                    } else {
                        this.writeFluidStackToSlot(i, new FluidStack(currentStack.fluidID, currentStack.amount - (int)request.getStackSize()));
                    }
                } else {
                    removedStack.setStackSize((long)currentStack.amount);
                    this.writeFluidStackToSlot(i, null);
                }
                if (this.updateTarget != null) {
                    this.updateTarget.func_70296_d();
                }
                return removedStack;
            }
        }
        return null;
    }

    public IItemList getAvailableItems(IItemList out) {
        for (int i = 0; i < this.totalTypes; ++i) {
            FluidStack currentStack = this.cachedInventory.get(i);
            if (currentStack == null) continue;
            IAEItemStack currentItemStack = Util.createItemStack((ItemStack)new ItemStack(this.fluidItem, 1, currentStack.fluidID));
            currentItemStack.setStackSize((long)currentStack.amount);
            out.add(currentItemStack);
        }
        return out;
    }

    public IItemList getAvailableItems() {
        return this.getAvailableItems(Util.createItemList());
    }

    public boolean isItemInPreformattedItems(ItemStack request) {
        if (!this.isPreformatted()) {
            return true;
        }
        for (ItemStack itemstack : this.getPreformattedItems()) {
            if (itemstack.func_77973_b() != request.func_77973_b() || itemstack.func_77960_j() != request.func_77960_j()) continue;
            return this.preformattedMode == ListMode.WHITELIST;
        }
        return this.preformattedMode != ListMode.WHITELIST;
    }

    public long getAvailableSpaceByItem(IAEItemStack itemstack, long maxNeeded) {
        if (itemstack != null) {
            if (this.remainingItemCount() > 0L) {
                return itemstack.getItem() == this.fluidItem ? this.remainingItemCount() : 0L;
            }
            for (IAEItemStack stack : this.getAvailableItems()) {
                if (stack != null && (stack == null || stack.getItem() != itemstack.getItem() || stack.getItemDamage() != itemstack.getItemDamage())) continue;
                return this.remainingItemCount();
            }
        }
        return 0L;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public long totalBytes() {
        return this.totalBytes;
    }

    public long freeBytes() {
        return this.remainingItemCount();
    }

    public long usedBytes() {
        return this.totalBytes() - this.freeBytes();
    }

    public long unusedItemCount() {
        return this.freeBytes();
    }

    public boolean canHoldNewItem() {
        for (int i = 0; i < this.totalTypes; ++i) {
            if (this.cachedInventory.get(i) != null) continue;
            return true;
        }
        return false;
    }

    public void setUpdateTarget(TileEntity e) {
        this.updateTarget = e;
    }

    public List<ItemStack> getPreformattedItems() {
        ArrayList<ItemStack> fluidItemList = new ArrayList<ItemStack>();
        for (int i = 0; i < 63; ++i) {
            Fluid current = this.cachedPreformats.get(i);
            if (current == null) continue;
            fluidItemList.add(new ItemStack(ItemEnum.FLUIDDISPLAY.getItemInstance(), 1, current.getID()));
        }
        return fluidItemList;
    }

    public boolean isPreformatted() {
        for (int i = 0; i < 63; ++i) {
            if (this.cachedPreformats.get(0) == null) continue;
            return true;
        }
        return false;
    }

    public boolean isFuzzyPreformatted() {
        return false;
    }

    public void setFuzzyPreformatted(boolean nf) {
    }

    public void setName(String name) {
        this.writeNameToNBT(name);
        this.cachedName = name;
    }

    public String getName() {
        return !this.cachedName.isEmpty() ? this.cachedName : this.readNameFromNBT();
    }

    public void setGrid(IGridInterface grid) {
        this.grid = grid;
    }

    public IGridInterface getGrid() {
        return this.grid;
    }

    public void setParent(IMEInventoryHandler parent) {
        this.parent = parent;
    }

    public IMEInventoryHandler getParent() {
        return this.parent;
    }

    public void removeGrid(IGridInterface grid, IMEInventoryHandler ignore, List<IMEInventoryHandler> duplicates) {
    }

    public void validate(List<IMEInventoryHandler> duplicates) {
    }

    public boolean canAccept(IAEItemStack input) {
        if (input != null && input.getItem() == this.fluidItem) {
            if (this.getAvailableItems() != null) {
                for (IAEItemStack current : this.getAvailableItems()) {
                    if (current != null && current.getItemDamage() != input.getItemDamage()) continue;
                    return true;
                }
                if ((long)this.getAvailableItems().size() < this.getTotalItemTypes()) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    public ItemFlow getFlow() {
        return ItemFlow.READ_WRITE;
    }

    public void setFlow(ItemFlow p) {
    }

    public FuzzyMode getFuzzyModePreformatted() {
        return FuzzyMode.Percent_99;
    }

    public void setPreformattedItems(IItemList in, FuzzyMode mode, ListMode m) {
        int i;
        if (this.storage.field_77990_d == null) {
            this.storage.field_77990_d = new NBTTagCompound();
        }
        NBTTagCompound nbt = this.storage.field_77990_d;
        this.cachedPreformats = new ArrayList<Fluid>(63);
        this.preformattedMode = m;
        this.writePreformattedMode(m);
        for (i = 0; i < 63; ++i) {
            nbt.func_82580_o("PreformattedFluidName#" + i);
        }
        if (!in.getItems().isEmpty()) {
            for (i = 0; i < in.getItems().size(); ++i) {
                FluidStack toWrite;
                ItemStack currentItemStack = (ItemStack)in.getItems().get(i);
                if (currentItemStack == null) continue;
                if (FluidContainerRegistry.isFilledContainer((ItemStack)currentItemStack)) {
                    toWrite = FluidContainerRegistry.getFluidForFilledItem((ItemStack)currentItemStack);
                    this.cachedPreformats.add(toWrite.getFluid());
                    nbt.func_74778_a("PreformattedFluidName#" + i, FluidContainerRegistry.getFluidForFilledItem((ItemStack)currentItemStack).getFluid().getName());
                    continue;
                }
                if (currentItemStack.func_77973_b() == ItemEnum.FLUIDDISPLAY.getItemInstance()) {
                    int toWrite2 = currentItemStack.func_77960_j();
                    this.cachedPreformats.add(FluidRegistry.getFluid((int)toWrite2));
                    nbt.func_74778_a("PreformattedFluidName#" + i, FluidRegistry.getFluidName((int)toWrite2));
                    continue;
                }
                if (!(currentItemStack.func_77973_b() instanceof IFluidContainerItem) || ((IFluidContainerItem)currentItemStack.func_77973_b()).getFluid(currentItemStack) == null) continue;
                toWrite = ((IFluidContainerItem)currentItemStack.func_77973_b()).getFluid(currentItemStack);
                nbt.func_74778_a("PreformattedFluidName#" + i, toWrite.getFluid().getName());
            }
        } else {
            for (i = 0; i < 63; ++i) {
                nbt.func_82580_o("PreformattedFluidName#" + i);
            }
        }
        System.out.println("");
    }

    public ListMode getListMode() {
        return this.preformattedMode;
    }

    private void writeFluidStackToSlot(int slotID, FluidStack input) {
        this.cachedInventory.set(slotID, input);
        if (this.storage.field_77990_d == null) {
            this.storage.field_77990_d = new NBTTagCompound();
        }
        NBTTagCompound nbt = this.storage.field_77990_d;
        if (input != null) {
            NBTTagCompound fluidTag = new NBTTagCompound();
            input.writeToNBT(fluidTag);
            nbt.func_74766_a("Fluid#" + slotID, fluidTag);
        } else {
            nbt.func_82580_o("Fluid#" + slotID);
        }
    }

    private FluidStack readFluidStackFromSlot(int slotID) {
        if (this.storage.field_77990_d == null) {
            this.storage.field_77990_d = new NBTTagCompound();
        }
        NBTTagCompound nbt = this.storage.field_77990_d;
        int oldFluidID = nbt.func_74762_e("FluidID#" + slotID);
        long oldFluidAmount = nbt.func_74763_f("FluidAmount#" + slotID);
        if (oldFluidID > 0 && oldFluidAmount > 0L) {
            return new FluidStack(oldFluidID, (int)oldFluidAmount);
        }
        nbt.func_82580_o("FluidID#" + slotID);
        nbt.func_82580_o("FluidAmount#" + slotID);
        return FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt.func_74775_l("Fluid#" + slotID));
    }

    private void writeNameToNBT(String name) {
        if (this.storage.field_77990_d == null) {
            this.storage.field_77990_d = new NBTTagCompound();
        }
        NBTTagCompound nbt = this.storage.field_77990_d;
        nbt.func_74778_a("PreformattedName", name);
    }

    private String readNameFromNBT() {
        if (this.storage.field_77990_d == null) {
            this.storage.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound nbt = this.storage.field_77990_d;
        return nbt.func_74779_i("PreformattedName");
    }

    private Fluid getPreformattedFluid(int slotID) {
        if (this.storage.field_77990_d == null) {
            this.storage.field_77990_d = new NBTTagCompound();
        }
        NBTTagCompound nbt = this.storage.field_77990_d;
        return FluidRegistry.getFluid((String)nbt.func_74779_i("PreformattedFluidName#" + slotID));
    }

    public ListMode readPreformattedMode() {
        NBTTagCompound nbt;
        int mode;
        if (this.storage.field_77990_d == null) {
            this.storage.field_77990_d = new NBTTagCompound();
        }
        return (mode = (nbt = this.storage.field_77990_d).func_74762_e("PreformattedMode")) == 0 ? ListMode.WHITELIST : (mode == 1 ? ListMode.BLACKLIST : ListMode.WHITELIST);
    }

    public void writePreformattedMode(ListMode mode) {
        if (this.storage.field_77990_d == null) {
            this.storage.field_77990_d = new NBTTagCompound();
        }
        NBTTagCompound nbt = this.storage.field_77990_d;
        nbt.func_74768_a("PreformattedMode", mode != null ? (mode == ListMode.BLACKLIST ? 1 : 0) : 0);
    }
}

