/*
 * Decompiled with CFR 0.152.
 */
package extracells.network.packet;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import cpw.mods.fml.relauncher.Side;
import extracells.network.AbstractPacket;
import extracells.tileentity.TileEntityBusFluidStorage;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;

public class PacketBusFluidStorage
extends AbstractPacket {
    World world;
    int x;
    int y;
    int z;
    int priority;

    public PacketBusFluidStorage(World world, int x, int y, int z, int priority) {
        this.world = world;
        this.x = x;
        this.y = y;
        this.z = z;
        this.priority = priority;
    }

    public PacketBusFluidStorage() {
    }

    @Override
    public void write(ByteArrayDataOutput out) {
        out.writeInt(this.world.field_73011_w.field_76574_g);
        out.writeInt(this.x);
        out.writeInt(this.y);
        out.writeInt(this.z);
        out.writeInt(this.priority);
    }

    @Override
    public void read(ByteArrayDataInput in) throws AbstractPacket.ProtocolException {
        this.world = DimensionManager.getWorld((int)in.readInt());
        this.x = in.readInt();
        this.y = in.readInt();
        this.z = in.readInt();
        this.priority = in.readInt();
    }

    @Override
    public void execute(EntityPlayer player, Side side) throws AbstractPacket.ProtocolException {
        if (side.isServer()) {
            TileEntityBusFluidStorage tile = (TileEntityBusFluidStorage)this.world.func_72796_p(this.x, this.y, this.z);
            tile.setPriority(this.priority);
        }
    }
}

