/*
 * Decompiled with CFR 0.152.
 */
package exnihilo.blocks.renderers;

import exnihilo.blocks.BlockBarrel;
import exnihilo.blocks.BlockBeeTrapTreated;
import exnihilo.blocks.models.ModelBarrel;
import exnihilo.blocks.models.ModelBarrelInternal;
import exnihilo.blocks.tileentities.TileEntityBarrel;
import exnihilo.registries.ColorRegistry;
import exnihilo.registries.helpers.Color;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import org.lwjgl.opengl.GL11;

public class RenderBarrel
extends TileEntitySpecialRenderer {
    private ModelBarrel barrel;
    private ModelBarrelInternal internal;

    public RenderBarrel(ModelBarrel model) {
        this.barrel = model;
        this.internal = new ModelBarrelInternal();
    }

    public void func_147500_a(TileEntity tileentity, double x, double y, double z, float f) {
        this.drawBarrel(tileentity, x, y, z, f);
        this.drawBarrelContents(tileentity, x, y, z, f);
    }

    private void drawBarrel(TileEntity tileentity, double x, double y, double z, float f) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 1.5f), (float)((float)z + 0.5f));
        GL11.glScalef((float)-0.8f, (float)-1.0f, (float)0.8f);
        this.bindBarrelTexture(tileentity.func_145838_q(), tileentity.func_145832_p());
        this.barrel.simpleRender(0.0625f);
        GL11.glPopMatrix();
    }

    private void drawBarrelContents(TileEntity tileentity, double x, double y, double z, float f) {
        TileEntityBarrel barrel = (TileEntityBarrel)tileentity;
        if (barrel.getMode() != TileEntityBarrel.BarrelMode.EMPTY) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + barrel.getAdjustedVolume()), (float)((float)z + 0.5f));
            GL11.glScalef((float)0.8f, (float)1.0f, (float)0.8f);
            this.bindInternalTexture();
            Fluid content = barrel.fluid.getFluid();
            IIcon icon = content.getIcon();
            Color color = barrel.color;
            boolean transparency = false;
            boolean clouds = false;
            boolean trap = false;
            switch (barrel.getMode()) {
                case COMPOST: {
                    icon = BlockBarrel.iconCompost;
                    break;
                }
                case FLUID: {
                    color = new Color(content.getColor());
                    transparency = true;
                    break;
                }
                case DIRT: {
                    icon = Blocks.field_150346_d.func_149691_a(0, 0);
                    break;
                }
                case CLAY: {
                    icon = Blocks.field_150435_aG.func_149691_a(0, 0);
                    break;
                }
                case SPORED: {
                    clouds = true;
                    transparency = true;
                    break;
                }
                case SLIME: {
                    clouds = true;
                    transparency = true;
                    break;
                }
                case NETHERRACK: {
                    icon = Blocks.field_150424_aL.func_149691_a(0, 0);
                    break;
                }
                case ENDSTONE: {
                    icon = Blocks.field_150377_bs.func_149691_a(0, 0);
                    break;
                }
                case MILKED: {
                    transparency = true;
                    clouds = true;
                    break;
                }
                case BEETRAP: {
                    transparency = true;
                    trap = true;
                    break;
                }
                case SOULSAND: {
                    icon = Blocks.field_150425_aM.func_149691_a(0, 0);
                    break;
                }
                case OBSIDIAN: {
                    icon = Blocks.field_150343_Z.func_149691_a(0, 0);
                    break;
                }
                case COBBLESTONE: {
                    icon = Blocks.field_150347_e.func_149691_a(0, 0);
                    break;
                }
                case BLAZE_COOKING: {
                    color = new Color(content.getColor());
                    transparency = true;
                    break;
                }
                case BLAZE: {
                    color = new Color(content.getColor());
                    transparency = true;
                    break;
                }
                case ENDER_COOKING: {
                    color = new Color(content.getColor());
                    transparency = true;
                    break;
                }
                case ENDER: {
                    color = new Color(content.getColor());
                    transparency = true;
                    break;
                }
                case DARKOAK: {
                    color = new Color(content.getColor());
                    transparency = false;
                    break;
                }
            }
            if (clouds) {
                GL11.glTranslatef((float)0.0f, (float)-1.0E-4f, (float)0.0f);
                this.internal.render(ColorRegistry.color("black"), BlockBarrel.iconClouds, transparency);
                GL11.glTranslatef((float)0.0f, (float)1.0E-4f, (float)0.0f);
            }
            if (trap) {
                GL11.glTranslatef((float)0.0f, (float)-0.05f, (float)0.0f);
                this.internal.render(ColorRegistry.color("white"), BlockBeeTrapTreated.topIcon, false);
                GL11.glTranslatef((float)0.0f, (float)0.05f, (float)0.0f);
            }
            this.internal.render(color, icon, transparency);
            GL11.glPopMatrix();
        }
    }

    public void bindBarrelTexture(Block block, int meta) {
        if (meta >= 0) {
            this.func_147499_a(this.barrel.getBarrelTexture(block, meta));
        }
    }

    public void bindInternalTexture() {
        ResourceLocation fluidTexture = TextureMap.field_110575_b;
        this.func_147499_a(fluidTexture);
    }
}

