/*
 * Decompiled with CFR 0.152.
 */
package exnihilo.compatibility.foresty;

import exnihilo.ExNihilo;
import exnihilo.compatibility.foresty.Hive;
import exnihilo.compatibility.foresty.HiveList;
import exnihilo.compatibility.foresty.Surrounding;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.world.biome.BiomeGenBase;

public class HiveRegistry {
    public static Map<String, Hive> hives = new HashMap<String, Hive>();
    public static Random rand = new Random();

    public static void registerHive(Hive hive) {
        hives.put(hive.block + ":" + hive.meta, hive);
    }

    public static Hive getHive(BiomeGenBase biome, Surrounding local, boolean canSeeSky, int height) {
        ArrayList<Hive> found = new ArrayList<Hive>();
        for (Map.Entry<String, Hive> pairs : hives.entrySet()) {
            Hive hive = pairs.getValue();
            if (hive == null || !hive.areAllRequirementsMet(biome, local, canSeeSky, height)) continue;
            found.add(hive);
        }
        if (!found.isEmpty()) {
            int index = rand.nextInt(found.size());
            return (Hive)found.get(index);
        }
        return null;
    }

    public static void registerHives() {
        ExNihilo.log.info("Beginning Hive Registry...");
        if (HiveList.generateForestryHives()) {
            HiveRegistry.registerHive(HiveList.forest);
            HiveRegistry.registerHive(HiveList.meadow);
            HiveRegistry.registerHive(HiveList.desert);
            HiveRegistry.registerHive(HiveList.jungle);
            HiveRegistry.registerHive(HiveList.end);
            HiveRegistry.registerHive(HiveList.snow);
            HiveRegistry.registerHive(HiveList.swamp);
            ExNihilo.log.info("Sucessfully added Forestry Hives");
        }
        ExNihilo.log.info("Hive Registry Completed!");
    }
}

