/*
 * Decompiled with CFR 0.152.
 */
package exnihilo.compatibility.foresty;

import exnihilo.compatibility.foresty.Surrounding;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;

public class Hive {
    public BiomeGenBase requiredBiome = null;
    public Float minTemperature = null;
    public Float maxTemperature = null;
    public Float minRainfall = null;
    public Float maxRainfall = null;
    public Float minYLevel = null;
    public Float maxYLevel = null;
    public int defaultSpawnBonus = 0;
    public String requiredSubstrate = null;
    private static int REQUIRED_SUBSTRATE_COUNT = 15;
    public Boolean requiredCanSeeSky = null;
    public Boolean requiresTree = null;
    public String requiresBlockAbove = null;
    public List<String> flowers = new ArrayList<String>();
    public List<BiomeDictionary.Type> biomeTypes = new ArrayList<BiomeDictionary.Type>();
    public Block block;
    public int meta;

    public Hive(Block block, int meta) {
        this.block = block;
        this.meta = meta;
    }

    public boolean areAllRequirementsMet(BiomeGenBase biome, Surrounding local, boolean canSeeSky, int height) {
        if (this.requiredBiome != null && biome.field_76756_M != this.requiredBiome.field_76756_M || this.minTemperature != null && biome.field_76750_F < this.minTemperature.floatValue() || this.maxTemperature != null && biome.field_76750_F > this.maxTemperature.floatValue() || this.minRainfall != null && biome.field_76751_G < this.minRainfall.floatValue() || this.maxRainfall != null && biome.field_76751_G > this.maxRainfall.floatValue() || this.minYLevel != null && (float)height < this.minYLevel.floatValue() || this.maxYLevel != null && (float)height > this.maxYLevel.floatValue() || this.requiredCanSeeSky != null && canSeeSky != this.requiredCanSeeSky) {
            return false;
        }
        if (this.requiresBlockAbove != null && !this.requiresBlockAbove.equals(local.blockAbove)) {
            return false;
        }
        if (this.requiresTree != null && this.requiresTree.booleanValue() && local.leafCount < 20) {
            return false;
        }
        if (this.requiredSubstrate != null) {
            int substrateCount = 0;
            if (local.blocks.containsKey(this.requiredSubstrate)) {
                substrateCount = local.blocks.get(this.requiredSubstrate);
            }
            if (substrateCount < REQUIRED_SUBSTRATE_COUNT) {
                return false;
            }
        }
        if (!this.biomeTypes.isEmpty()) {
            BiomeDictionary.Type[] types = BiomeDictionary.getTypesForBiome((BiomeGenBase)biome);
            Iterator<BiomeDictionary.Type> it = this.biomeTypes.iterator();
            while (it.hasNext()) {
                boolean found = false;
                BiomeDictionary.Type currentType = it.next();
                for (int j = 0; j < types.length; ++j) {
                    if (types[j] != currentType) continue;
                    found = true;
                }
                if (found) continue;
                return false;
            }
        }
        if (!this.flowers.isEmpty()) {
            Iterator<String> it = this.flowers.iterator();
            boolean found = false;
            while (it.hasNext()) {
                if (!local.blocks.containsKey(it.next())) continue;
                found = true;
                break;
            }
            if (!found) {
                return false;
            }
        }
        return true;
    }

    public int getSpawnChanceModifier(Surrounding local) {
        int flowerCount = 0;
        if (!this.flowers.isEmpty()) {
            Iterator<String> it = this.flowers.iterator();
            boolean found = false;
            while (it.hasNext()) {
                String key = it.next();
                if (!local.blocks.containsKey(key)) continue;
                flowerCount += local.blocks.get(key).intValue();
            }
        }
        return this.defaultSpawnBonus + flowerCount;
    }
}

