/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.worldgen;

import cpw.mods.fml.common.IWorldGenerator;
import evilcraft.GeneralConfig;
import evilcraft.blocks.DarkOre;
import evilcraft.blocks.DarkOreConfig;
import evilcraft.entities.monster.NetherfishConfig;
import evilcraft.worldgen.NetherfishSpawnGenerator;
import evilcraft.worldgen.WorldGenMinableConfigurable;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;

public class EvilWorldGenerator
implements IWorldGenerator {
    private WorldGenMinableConfigurable darkOres = new WorldGenMinableConfigurable(DarkOre.getInstance(), DarkOreConfig.blocksPerVein, DarkOreConfig.veinsPerChunk, DarkOreConfig.startY, DarkOreConfig.endY);
    private WorldGenMinableConfigurable extraSilverfish = new WorldGenMinableConfigurable(Blocks.field_150418_aU, 8, GeneralConfig.silverfish_BlocksPerVein, GeneralConfig.silverfish_VeinsPerChunk, GeneralConfig.silverfish_StartY, GeneralConfig.silverfish_EndY);
    private WorldGenMinableConfigurable netherfish = new NetherfishSpawnGenerator();

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        if (world.field_73011_w.field_76574_g == 0) {
            this.generateSurface(world, random, chunkX * 16, chunkZ * 16);
        }
        if (world.field_73011_w.field_76574_g == -1) {
            this.generateNether(world, random, chunkX * 16, chunkZ * 16);
        }
    }

    private void generateSurface(World world, Random rand, int chunkX, int chunkZ) {
        this.darkOres.loopGenerate(world, rand, chunkX, chunkZ);
        if (GeneralConfig.extraSilverfish) {
            this.extraSilverfish.loopGenerate(world, rand, chunkX, chunkZ);
        }
    }

    private void generateNether(World world, Random rand, int chunkX, int chunkZ) {
        if (NetherfishConfig._instance.isEnabled()) {
            this.netherfish.loopGenerate(world, rand, chunkX, chunkZ);
        }
    }
}

