/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import evilcraft.api.Helpers;
import evilcraft.api.config.ExtendedConfig;
import evilcraft.api.config.ItemConfig;
import evilcraft.api.config.configurable.ConfigurableDamageIndicatedItemFluidContainer;
import evilcraft.fluids.Blood;
import evilcraft.items.BloodContainerConfig;
import evilcraft.items.BloodExtractorConfig;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;

public class BloodContainer
extends ConfigurableDamageIndicatedItemFluidContainer {
    private static BloodContainer _instance = null;
    private IIcon[] icons = new IIcon[BloodContainerConfig.getContainerLevels()];
    private static final int MB_FILL_PERTICK = 10;

    public static void initInstance(ExtendedConfig<ItemConfig> eConfig) {
        if (_instance == null) {
            _instance = new BloodContainer(eConfig);
        } else {
            eConfig.showDoubleInitError();
        }
    }

    public static BloodContainer getInstance() {
        return _instance;
    }

    private BloodContainer(ExtendedConfig<ItemConfig> eConfig) {
        super(eConfig, BloodExtractorConfig.containerSize, Blood.getInstance());
        this.setPlaceFluids(true);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        for (int i = 0; i < this.icons.length; ++i) {
            this.icons[i] = iconRegister.func_94245_a(this.func_111208_A() + "_" + i);
        }
    }

    public IIcon func_77617_a(int damage) {
        return this.icons[Math.min(damage & 7, this.icons.length - 1)];
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List itemList) {
        for (int i = 0; i < this.icons.length; ++i) {
            this.component.getSubItems(item, tab, itemList, this.fluid, i);
        }
    }

    public int getCapacity(ItemStack container) {
        return this.capacity << (container.func_77960_j() & 7);
    }

    public String func_77667_c(ItemStack itemStack) {
        return super.func_77658_a() + "." + BloodContainerConfig.containerLevelNames[Math.min(itemStack.func_77960_j() & 7, this.icons.length - 1)];
    }

    @Override
    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer player) {
        if (player.func_70093_af()) {
            if (!world.field_72995_K) {
                BloodContainer.toggleContainerActivation(itemStack);
            }
            return itemStack;
        }
        return super.func_77659_a(itemStack, world, player);
    }

    public boolean func_77636_d(ItemStack itemStack) {
        return BloodContainer.isContainerActivated(itemStack);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        super.func_77624_a(itemStack, entityPlayer, list, par4);
        list.add(Helpers.getLocalizedInfo((Item)this, ".main"));
        String autoSupply = EnumChatFormatting.RESET + StatCollector.func_74838_a((String)(this.func_77658_a() + ".info.disabled"));
        if (BloodContainer.isContainerActivated(itemStack)) {
            autoSupply = EnumChatFormatting.GREEN + StatCollector.func_74838_a((String)(this.func_77658_a() + ".info.enabled"));
        }
        list.add(EnumChatFormatting.BOLD + StatCollector.func_74838_a((String)(this.func_77658_a() + ".info.autoSupply")) + " " + autoSupply);
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity entity, int par4, boolean par5) {
        EntityPlayer player;
        ItemStack held;
        FluidStack tickFluid;
        if (entity instanceof EntityPlayer && !world.field_72995_K && BloodContainer.isContainerActivated(itemStack) && (tickFluid = this.getFluid(itemStack)) != null && tickFluid.amount > 0 && (held = (player = (EntityPlayer)entity).func_71045_bC()) != null && held != itemStack && held.func_77973_b() instanceof IFluidContainerItem) {
            IFluidContainerItem fluidContainer = (IFluidContainerItem)held.func_77973_b();
            FluidStack heldFluid = fluidContainer.getFluid(held);
            if (tickFluid.amount >= 10 && (heldFluid == null || heldFluid != null && heldFluid.isFluidEqual(tickFluid) && heldFluid.amount < fluidContainer.getCapacity(held))) {
                int filled = fluidContainer.fill(held, new FluidStack(tickFluid.getFluid(), 10), true);
                this.drain(itemStack, filled, true);
            }
        }
        super.func_77663_a(itemStack, world, entity, par4, par5);
    }

    public static boolean isContainerActivated(ItemStack itemStack) {
        return itemStack != null && itemStack.func_77978_p() != null && itemStack.func_77978_p().func_74767_n("enabled");
    }

    public static void toggleContainerActivation(ItemStack itemStack) {
        NBTTagCompound tag = itemStack.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
            itemStack.func_77982_d(tag);
        }
        tag.func_74757_a("enabled", !BloodContainer.isContainerActivated(itemStack));
    }
}

