/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import evilcraft.api.IInformationProvider;
import evilcraft.api.config.BlockConfig;
import evilcraft.api.config.ExtendedConfig;
import evilcraft.api.config.configurable.ConfigurableBlock;
import evilcraft.blocks.ExcrementPileConfig;
import evilcraft.items.Broom;
import evilcraft.items.BroomConfig;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ExcrementPile
extends ConfigurableBlock
implements IInformationProvider {
    private static ExcrementPile _instance = null;
    private static final int CHANCE_DESPAWN = 1;
    private static final int CHANCE_BONEMEAL = 3;
    private static final int POISON_DURATION = 3;
    private static final int PIG_BOOST_DURATION = 3;

    public static void initInstance(ExtendedConfig<BlockConfig> eConfig) {
        if (_instance == null) {
            _instance = new ExcrementPile(eConfig);
        } else {
            eConfig.showDoubleInitError();
        }
    }

    public static ExcrementPile getInstance() {
        return _instance;
    }

    private ExcrementPile(ExtendedConfig<BlockConfig> eConfig) {
        super(eConfig, Material.field_151571_B);
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.125f, 1.0f);
        this.func_149675_a(true);
        this.setBlockBoundsForPileDepth(0);
    }

    public Item func_149650_a(int par1, Random random, int zero) {
        return Item.func_150898_a((Block)this);
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        return null;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public void func_149683_g() {
        this.setBlockBoundsForPileDepth(0);
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        this.setBlockBoundsForPileDepth(world.func_72805_g(x, y, z));
    }

    protected void setBlockBoundsForPileDepth(int meta) {
        int j = meta & 7;
        float f = (float)(2 * (1 + j)) / 16.0f;
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, f, 1.0f);
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y - 1, z);
        if (block == null) {
            return false;
        }
        if (block == this && (world.func_72805_g(x, y - 1, z) & 7) == 7) {
            return true;
        }
        if (!block.isLeaves((IBlockAccess)world, x, y - 1, z) && !block.func_149662_c()) {
            return false;
        }
        return block.func_149688_o().func_76230_c();
    }

    public boolean canHarvestBlock(EntityPlayer player, int meta) {
        return player.func_71045_bC() != null && BroomConfig._instance.isEnabled() && player.func_71045_bC().func_77973_b() == Broom.getInstance();
    }

    public void func_149636_a(World world, EntityPlayer player, int x, int y, int z, int meta) {
        super.func_149636_a(world, player, x, y, z, meta);
        world.func_147468_f(x, y, z);
    }

    public int func_149745_a(Random random) {
        return 1;
    }

    public int func_149738_a(World world) {
        return 100;
    }

    public void func_149674_a(World world, int x, int y, int z, Random random) {
        if (random.nextInt(1) == 0) {
            if (random.nextInt(3) == 0) {
                for (int xr = x - 2; xr <= x + 2; ++xr) {
                    for (int zr = z - 2; zr <= z + 2; ++zr) {
                        if (random.nextInt(9) != 0) continue;
                        Block blockBelow = world.func_147439_a(xr, y - 1, zr);
                        if (blockBelow == Blocks.field_150346_d) {
                            world.func_147449_b(xr, y - 1, zr, (Block)Blocks.field_150349_c);
                        } else if (blockBelow == Blocks.field_150349_c) {
                            ItemDye.applyBonemeal((ItemStack)new ItemStack(Items.field_151100_aR, 1), (World)world, (int)xr, (int)(y - 1), (int)zr, null);
                        }
                        ItemDye.applyBonemeal((ItemStack)new ItemStack(Items.field_151100_aR, 1), (World)world, (int)xr, (int)y, (int)zr, null);
                    }
                }
            }
            world.func_147468_f(x, y, z);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random random) {
        if (random.nextInt(100) == 0) {
            int meta = world.func_72805_g(x, y, z);
            float height = (float)(meta + 1) / 8.0f;
            double d0 = (double)x + 0.5 + ((double)random.nextFloat() - 0.5) * 0.2;
            double d1 = (float)y + 0.0625f + height;
            double d2 = (double)z + 0.5 + ((double)random.nextFloat() - 0.5) * 0.2;
            float f1 = 0.1f - random.nextFloat() * 0.2f;
            float f2 = 0.1f - random.nextFloat() * 0.2f;
            float f3 = 0.1f - random.nextFloat() * 0.2f;
            world.func_72869_a("happyVillager", d0, d1, d2, (double)f1, (double)f2, (double)f3);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149646_a(IBlockAccess world, int x, int y, int z, int side) {
        return side == 1 ? true : super.func_149646_a(world, x, y, z, side);
    }

    public int quantityDropped(int meta, int fortune, Random random) {
        return (meta & 7) + 1;
    }

    public boolean isReplaceable(IBlockAccess world, int x, int y, int z) {
        return true;
    }

    public void func_149695_a(World world, int x, int y, int z, Block neighbourBlock) {
        if (!this.func_149742_c(world, x, y, z)) {
            world.func_147468_f(x, y, z);
        }
    }

    public void func_149670_a(World world, int x, int y, int z, Entity entity) {
        if (entity instanceof EntityLivingBase) {
            if (entity instanceof EntityPig) {
                if (this.isChanceWithHeight(world, x, y, z)) {
                    ((EntityLivingBase)entity).func_70690_d(new PotionEffect(Potion.field_76432_h.field_76415_H, 60, 1));
                    ((EntityLivingBase)entity).func_70690_d(new PotionEffect(Potion.field_76424_c.field_76415_H, 60, 1));
                }
            } else if ((entity instanceof EntityPlayer || ExcrementPileConfig.hurtEntities) && this.isChanceWithHeight(world, x, y, z)) {
                ((EntityLivingBase)entity).func_70690_d(new PotionEffect(Potion.field_76436_u.field_76415_H, 60, 1));
            }
        }
        super.func_149670_a(world, x, y, z, entity);
    }

    private boolean isChanceWithHeight(World world, int x, int y, int z) {
        float height = ((float)(world.func_72805_g(x, y, z) & 7) + 1.0f) * 0.125f;
        return world.field_73012_v.nextFloat() * 10.0f < height;
    }

    public static boolean canHeightenPileAt(World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        return meta < 7;
    }

    public static void heightenPileAt(World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        if (meta < 7) {
            world.func_72921_c(x, y, z, meta + 1, 2);
        }
    }

    @Override
    public String getInfo(ItemStack itemStack) {
        return IInformationProvider.INFO_PREFIX + "Will form below animals.";
    }

    @Override
    public void provideInformation(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
    }
}

