/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.api.gui.client;

import evilcraft.api.entities.tileentitites.EvilCraftTileEntity;
import evilcraft.api.entities.tileentitites.InventoryTileEntity;
import evilcraft.api.entities.tileentitites.TankInventoryTileEntity;
import evilcraft.api.fluids.SingleUseTank;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Container;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class GuiContainerTankInventory<T extends TankInventoryTileEntity>
extends GuiContainer {
    private boolean showTank = false;
    private int tankWidth;
    private int tankHeight;
    private int tankX;
    private int tankY;
    private int tankTargetX;
    private int tankTargetY;
    private boolean showProgress = false;
    private int progressWidth;
    private int progressHeight;
    private int progressX;
    private int progressY;
    private int progressTargetX;
    private int progressTargetY;
    protected T tile;
    private ResourceLocation texture;

    public GuiContainerTankInventory(Container container, T tile) {
        super(container);
        this.tile = tile;
        this.texture = new ResourceLocation("evilcraft", ((EvilCraftTileEntity)((Object)tile)).getBlock().getGuiTexture());
    }

    protected void setTank(int tankWidth, int tankHeight, int tankX, int tankY, int tankTargetX, int tankTargetY) {
        this.showTank = true;
        this.tankWidth = tankWidth;
        this.tankHeight = tankHeight;
        this.tankX = tankX;
        this.tankY = tankY;
        this.tankTargetX = tankTargetX;
        this.tankTargetY = tankTargetY;
    }

    protected void setProgress(int progressWidth, int progressHeight, int progressX, int progressY, int progressTargetX, int progressTargetY) {
        this.showProgress = true;
        this.progressWidth = progressWidth;
        this.progressHeight = progressHeight;
        this.progressX = progressX;
        this.progressY = progressY;
        this.progressTargetX = progressTargetX;
        this.progressTargetY = progressTargetY;
    }

    protected boolean isShowProgress() {
        return this.showProgress;
    }

    protected int getProgressScaled(int scale) {
        return 0;
    }

    protected void func_146976_a(float f, int x, int y) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(this.texture);
        int j = (this.field_146294_l - this.field_146999_f) / 2;
        int k = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(j, k, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.isShowProgress()) {
            int progressScaled = this.getProgressScaled(this.progressWidth);
            this.func_73729_b(j + this.progressTargetX, k + this.progressTargetY, this.progressX, this.progressY, progressScaled, this.progressHeight);
        }
    }

    protected void drawForgegroundString() {
        this.field_146289_q.func_78276_b(((InventoryTileEntity)((Object)this.tile)).func_145825_b(), 8, 4, 0x404040);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.drawForgegroundString();
        GL11.glEnable((int)3042);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        SingleUseTank tank = ((TankInventoryTileEntity)((Object)this.tile)).getTank();
        if (this.shouldRenderTank()) {
            int tankSize = tank.getFluidAmount() * this.tankHeight / tank.getCapacity();
            this.drawTank(this.tankTargetX, this.tankTargetY, tank.getAcceptedFluid().getID(), tankSize);
        }
        GL11.glDisable((int)3042);
    }

    public void func_73863_a(int mouseX, int mouseY, float gameTicks) {
        super.func_73863_a(mouseX, mouseY, gameTicks);
        this.drawTooltips(mouseX, mouseY);
    }

    protected boolean shouldRenderTank() {
        if (!this.showTank) {
            return false;
        }
        SingleUseTank tank = ((TankInventoryTileEntity)((Object)this.tile)).getTank();
        return tank != null && tank.getAcceptedFluid() != null && tank.getFluidAmount() > 0;
    }

    protected void drawTank(int xOffset, int yOffset, int fluidID, int level) {
        FluidStack stack = new FluidStack(fluidID, 1);
        if (fluidID > 0 && stack != null) {
            IIcon icon = stack.getFluid().getIcon();
            if (icon == null) {
                icon = Blocks.field_150355_j.func_149691_a(0, 0);
            }
            int verticalOffset = 0;
            while (level > 0) {
                int textureHeight = 0;
                if (level > 16) {
                    textureHeight = 16;
                    level -= 16;
                } else {
                    textureHeight = level;
                    level = 0;
                }
                this.field_146297_k.field_71446_o.func_110577_a(this.field_146297_k.field_71446_o.func_130087_a(0));
                this.func_94065_a(xOffset, yOffset - textureHeight - verticalOffset, icon, this.tankWidth, textureHeight);
                verticalOffset += 16;
            }
            this.field_146297_k.field_71446_o.func_110577_a(this.texture);
            this.func_73729_b(xOffset, yOffset - this.tankHeight, this.tankX, this.tankY, this.tankWidth, this.tankHeight);
        }
    }

    protected void drawTooltips(int mouseX, int mouseY) {
        if (this.func_146978_c(this.tankTargetX, this.tankTargetY - this.tankHeight, this.tankWidth, this.tankHeight, mouseX, mouseY) && this.shouldRenderTank()) {
            SingleUseTank tank = ((TankInventoryTileEntity)((Object)this.tile)).getTank();
            String fluidName = StatCollector.func_74838_a((String)("fluid.fluids." + FluidRegistry.getFluidName((int)tank.getFluid().fluidID)));
            this.drawBarTooltip(fluidName, "mB", tank.getFluidAmount(), tank.getCapacity(), mouseX, mouseY);
        }
    }

    protected void drawBarTooltip(String name, String unit, int value, int max, int x, int y) {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(name);
        lines.add(value + " / " + max + " " + unit);
        this.drawTooltip(lines, x, y);
    }

    protected void drawTooltip(List<String> lines, int x, int y) {
        GL11.glPushMatrix();
        GL11.glDisable((int)2929);
        GL11.glDisable((int)32826);
        GL11.glDisable((int)2896);
        int tooltipWidth = 0;
        for (int i = 0; i < lines.size(); ++i) {
            int tempWidth = this.field_146289_q.func_78256_a(lines.get(i));
            if (tempWidth <= tooltipWidth) continue;
            tooltipWidth = tempWidth;
        }
        int xStart = x + 12;
        int yStart = y - 12;
        int tooltipHeight = 8;
        if (lines.size() > 1) {
            tooltipHeight += 2 + (lines.size() - 1) * 10;
        }
        if (this.field_147009_r + yStart + tooltipHeight + 6 > this.field_146295_m) {
            yStart = this.field_146295_m - tooltipHeight - this.field_147009_r - 6;
        }
        this.field_73735_i = 300.0f;
        GuiContainerTankInventory.field_146296_j.field_77023_b = 300.0f;
        int color1 = -267386864;
        this.func_73733_a(xStart - 3, yStart - 4, xStart + tooltipWidth + 3, yStart - 3, color1, color1);
        this.func_73733_a(xStart - 3, yStart + tooltipHeight + 3, xStart + tooltipWidth + 3, yStart + tooltipHeight + 4, color1, color1);
        this.func_73733_a(xStart - 3, yStart - 3, xStart + tooltipWidth + 3, yStart + tooltipHeight + 3, color1, color1);
        this.func_73733_a(xStart - 4, yStart - 3, xStart - 3, yStart + tooltipHeight + 3, color1, color1);
        this.func_73733_a(xStart + tooltipWidth + 3, yStart - 3, xStart + tooltipWidth + 4, yStart + tooltipHeight + 3, color1, color1);
        int color2 = 0x505000FF;
        int color3 = (color2 & 0xFEFEFE) >> 1 | color2 & 0xFF000000;
        this.func_73733_a(xStart - 3, yStart - 3 + 1, xStart - 3 + 1, yStart + tooltipHeight + 3 - 1, color2, color3);
        this.func_73733_a(xStart + tooltipWidth + 2, yStart - 3 + 1, xStart + tooltipWidth + 3, yStart + tooltipHeight + 3 - 1, color2, color3);
        this.func_73733_a(xStart - 3, yStart - 3, xStart + tooltipWidth + 3, yStart - 3 + 1, color2, color2);
        this.func_73733_a(xStart - 3, yStart + tooltipHeight + 2, xStart + tooltipWidth + 3, yStart + tooltipHeight + 3, color3, color3);
        for (int stringIndex = 0; stringIndex < lines.size(); ++stringIndex) {
            String line = lines.get(stringIndex);
            line = stringIndex == 0 ? "\u00a7" + Integer.toHexString(15) + line : "\u00a77" + line;
            this.field_146289_q.func_78261_a(line, xStart, yStart, -1);
            if (stringIndex == 0) {
                yStart += 2;
            }
            yStart += 10;
        }
        GL11.glPopMatrix();
        GL11.glEnable((int)2929);
        this.field_73735_i = 0.0f;
        GuiContainerTankInventory.field_146296_j.field_77023_b = 0.0f;
    }
}

