/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.items;

import evilcraft.api.config.ExtendedConfig;
import evilcraft.api.config.ItemConfig;
import evilcraft.api.config.configurable.ConfigurableDamageIndicatedItemFluidContainer;
import evilcraft.blocks.BloodStainedBlock;
import evilcraft.fluids.Blood;
import evilcraft.items.BloodExtractorConfig;
import evilcraft.render.particle.EntityBloodSplashFX;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.ItemFluidContainer;

public class BloodExtractor
extends ConfigurableDamageIndicatedItemFluidContainer {
    private static BloodExtractor _instance = null;

    public static void initInstance(ExtendedConfig<ItemConfig> eConfig) {
        if (_instance == null) {
            _instance = new BloodExtractor(eConfig);
        } else {
            eConfig.showDoubleInitError();
        }
    }

    public static BloodExtractor getInstance() {
        return _instance;
    }

    private BloodExtractor(ExtendedConfig<ItemConfig> eConfig) {
        super(eConfig, BloodExtractorConfig.containerSize, Blood.getInstance());
        this.setPlaceFluids(true);
    }

    public boolean onItemUseFirst(ItemStack itemStack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        Block block = world.func_147439_a(x, y, z);
        if (block == BloodStainedBlock.getInstance() && player.func_70093_af()) {
            Random random = world.field_73012_v;
            int toFill = BloodExtractorConfig.minMB + random.nextInt(BloodExtractorConfig.maxMB - BloodExtractorConfig.minMB);
            ItemFluidContainer container = (ItemFluidContainer)itemStack.func_77973_b();
            int filled = container.fill(itemStack, new FluidStack((Fluid)Blood.getInstance(), toFill), true);
            if (filled > 0) {
                int metaData = world.func_72805_g(x, y, z);
                world.func_147449_b(x, y, z, BloodStainedBlock.getInstance().getBlockFromMetadata(metaData));
                if (world.field_72995_K) {
                    EntityBloodSplashFX.spawnParticles(world, x, y + 1, z, 5, 1 + random.nextInt(2));
                }
                return false;
            }
            return false;
        }
        return super.onItemUseFirst(itemStack, player, world, x, y, z, side, hitX, hitY, hitZ);
    }

    @Override
    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer player) {
        if (!player.func_70093_af()) {
            return super.func_77659_a(itemStack, world, player);
        }
        return itemStack;
    }
}

