/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import evilcraft.api.Helpers;
import evilcraft.api.RenderHelpers;
import evilcraft.api.config.BlockConfig;
import evilcraft.api.config.ExtendedConfig;
import evilcraft.api.config.configurable.ConfigurableBlockWithInnerBlocks;
import evilcraft.api.render.AlternatingBlockIconComponent;
import evilcraft.render.particle.EntityBloodSplashFX;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BloodStainedBlock
extends ConfigurableBlockWithInnerBlocks {
    private static BloodStainedBlock _instance = null;
    private AlternatingBlockIconComponent alternatingBlockIconComponent = new AlternatingBlockIconComponent(this.getAlternateIconsAmount());

    public static void initInstance(ExtendedConfig<BlockConfig> eConfig) {
        if (_instance == null) {
            _instance = new BloodStainedBlock(eConfig);
        } else {
            eConfig.showDoubleInitError();
        }
    }

    public static BloodStainedBlock getInstance() {
        return _instance;
    }

    private BloodStainedBlock(ExtendedConfig<BlockConfig> eConfig) {
        super(eConfig, Material.field_151578_c);
        this.func_149711_c(0.5f);
        this.func_149672_a(field_149767_g);
    }

    @Override
    protected Block[] makeInnerBlockList() {
        return new Block[]{Blocks.field_150349_c, Blocks.field_150346_d, Blocks.field_150348_b, Blocks.field_150417_aV, Blocks.field_150347_e, Blocks.field_150354_m};
    }

    public int getAlternateIconsAmount() {
        return 3;
    }

    @Override
    public int getRenderPasses() {
        return 2;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.alternatingBlockIconComponent.registerIcons(this.func_149641_N(), iconRegister);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        return this.getIcon(side, world.func_72805_g(x, y, z), this.pass, this.alternatingBlockIconComponent.getAlternateIcon(world, x, y, z, side));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return this.getIcon(side, meta, this.pass, this.alternatingBlockIconComponent.getBaseIcon());
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side, int meta, int renderPass, IIcon defaultIcon) {
        if (renderPass < 0) {
            return RenderHelpers.EMPTYICON;
        }
        if (renderPass == 1) {
            if (side != ForgeDirection.UP.ordinal()) {
                return RenderHelpers.EMPTYICON;
            }
            return defaultIcon;
        }
        return this.getBlockFromMetadata(meta).func_149691_a(side, 0);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149699_a(World par1World, int par2, int par3, int par4, EntityPlayer par5EntityPlayer) {
        BloodStainedBlock.splash(par1World, par2, par3, par4);
        super.func_149699_a(par1World, par2, par3, par4, par5EntityPlayer);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149724_b(World par1World, int par2, int par3, int par4, Entity par5Entity) {
        BloodStainedBlock.splash(par1World, par2, par3, par4);
        super.func_149724_b(par1World, par2, par3, par4, par5Entity);
    }

    @SideOnly(value=Side.CLIENT)
    public static void splash(World world, int x, int y, int z) {
        EntityBloodSplashFX.spawnParticles(world, x, y + 1, z, 1, 1 + world.field_73012_v.nextInt(3));
    }

    public void func_149639_l(World world, int x, int y, int z) {
        world.func_147449_b(x, y, z, this.getBlockFromMetadata(world.func_72805_g(x, y, z)));
    }

    @Override
    public String getInfo(ItemStack itemStack) {
        return "Block: " + EnumChatFormatting.ITALIC + this.getBlockFromMetadata(itemStack.func_77960_j()).func_149732_F();
    }

    @Override
    public void provideInformation(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        list.add(Helpers.getLocalizedInfo(this));
    }
}

