/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.api.entities.tileentitites;

import evilcraft.api.entities.tileentitites.InventoryTileEntity;
import evilcraft.api.fluids.SingleUseTank;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public abstract class TankInventoryTileEntity
extends InventoryTileEntity
implements IFluidHandler {
    protected SingleUseTank tank;

    public TankInventoryTileEntity(int inventorySize, String inventoryName, int tankSize, String tankName) {
        super(inventorySize, inventoryName);
        this.tank = new SingleUseTank(tankName, tankSize, this);
    }

    public TankInventoryTileEntity(int inventorySize, String inventoryName, int tankSize, String tankName, Fluid acceptedFluid) {
        this(inventorySize, inventoryName, tankSize, tankName);
        this.tank.setAcceptedFluid(acceptedFluid);
    }

    public SingleUseTank getTank() {
        return this.tank;
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.tank.readFromNBT(data);
    }

    @Override
    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        this.tank.writeToNBT(data);
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        int filled = this.tank.fill(resource, doFill);
        return filled;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource == null || !resource.isFluidEqual(this.tank.getFluid())) {
            return null;
        }
        FluidStack drained = this.drain(from, resource.amount, doDrain);
        return drained;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        FluidStack drained = this.tank.drain(maxDrain, doDrain);
        return drained;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.tank.getAcceptedFluid() == null || this.tank.getAcceptedFluid().equals(fluid);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.tank.getAcceptedFluid() == null || this.tank.getAcceptedFluid().equals(fluid);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        FluidTankInfo[] info = new FluidTankInfo[]{this.tank.getInfo()};
        return info;
    }
}

