/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.api.config.configurable;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import evilcraft.api.Helpers;
import evilcraft.api.config.ElementType;
import evilcraft.api.config.ExtendedConfig;
import evilcraft.api.config.configurable.Configurable;
import evilcraft.api.entities.tileentitites.EvilCraftTileEntity;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class ConfigurableBlockContainer
extends BlockContainer
implements Configurable {
    protected ExtendedConfig eConfig = null;
    public static ElementType TYPE = ElementType.BLOCKCONTAINER;
    protected Random random;
    private Class<? extends EvilCraftTileEntity> tileEntity;
    protected boolean hasGui = false;
    private boolean rotatable;
    protected IIcon[] sideIcons = new IIcon[Helpers.DIRECTIONS.size()];

    public ConfigurableBlockContainer(ExtendedConfig eConfig, Material material, Class<? extends EvilCraftTileEntity> tileEntity) {
        super(material);
        this.setConfig(eConfig);
        this.func_149663_c(this.getUniqueName());
        this.random = new Random();
        this.tileEntity = tileEntity;
        this.func_149711_c(5.0f);
        this.func_149672_a(Block.field_149788_p);
    }

    public Class<? extends TileEntity> getTileEntity() {
        return this.tileEntity;
    }

    @Override
    public void setConfig(ExtendedConfig eConfig) {
        this.eConfig = eConfig;
    }

    @Override
    public String getUniqueName() {
        return "blocks." + this.eConfig.NAMEDID;
    }

    public boolean hasGui() {
        return this.hasGui;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        if (this.isRotatable()) {
            for (ForgeDirection direction : Helpers.DIRECTIONS) {
                this.sideIcons[direction.ordinal()] = iconRegister.func_94245_a(this.func_149641_N() + "_" + direction.name());
            }
        } else {
            this.field_149761_L = iconRegister.func_94245_a(this.func_149641_N());
        }
    }

    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        if (this.isRotatable()) {
            int meta = world.func_72805_g(x, y, z);
            EvilCraftTileEntity tile = (EvilCraftTileEntity)world.func_147438_o(x, y, z);
            ForgeDirection rotatedDirection = Helpers.TEXTURESIDE_ORIENTATION[tile.getRotation().ordinal()][side];
            return this.func_149691_a(rotatedDirection.ordinal(), meta);
        }
        return super.func_149673_e(world, x, y, z, side);
    }

    public IIcon func_149691_a(int side, int meta) {
        if (this.isRotatable()) {
            return this.sideIcons[side];
        }
        return super.func_149691_a(side, meta);
    }

    public String func_149641_N() {
        return "evilcraft:" + this.eConfig.NAMEDID;
    }

    @Override
    public boolean isEntity() {
        return false;
    }

    public TileEntity func_149915_a(World world, int meta) {
        try {
            EvilCraftTileEntity tile = this.tileEntity.newInstance();
            tile.setRotatable(this.isRotatable());
            return tile;
        }
        catch (InstantiationException e1) {
            e1.printStackTrace();
        }
        catch (IllegalAccessException e2) {
            e2.printStackTrace();
        }
        return null;
    }

    public boolean func_149662_c() {
        return false;
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        Helpers.preDestroyBlock(world, x, y, z);
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack stack) {
        if (entity != null) {
            EvilCraftTileEntity tile = (EvilCraftTileEntity)world.func_147438_o(x, y, z);
            if (stack.func_77978_p() != null) {
                stack.func_77978_p().func_74768_a("x", x);
                stack.func_77978_p().func_74768_a("y", y);
                stack.func_77978_p().func_74768_a("z", z);
                tile.func_145839_a(stack.func_77978_p());
            }
            if (tile.isRotatable()) {
                ForgeDirection facing = Helpers.getEntityFacingDirection(entity);
                tile.setRotation(facing);
            }
        }
        super.func_149689_a(world, x, y, z, entity, stack);
    }

    public boolean rotateBlock(World world, int x, int y, int z, ForgeDirection axis) {
        EvilCraftTileEntity tile;
        if (!world.field_72995_K && (tile = (EvilCraftTileEntity)world.func_147438_o(x, y, z)).isRotatable()) {
            tile.setRotation(tile.getRotation().getRotation(axis));
            return true;
        }
        return false;
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        ItemStack itemStack = new ItemStack(this.func_149650_a(metadata, world.field_73012_v, fortune), 1, this.func_149692_a(metadata));
        EvilCraftTileEntity tile = (EvilCraftTileEntity)world.func_147438_o(x, y, z);
        if (tile != null && this.isKeepNBTOnDrop()) {
            itemStack.func_77982_d(tile.getNBTTagCompound());
        }
        drops.add(itemStack);
        super.func_149749_a(world, x, y, z, Blocks.field_150350_a, 0);
        return drops;
    }

    public boolean isKeepNBTOnDrop() {
        return true;
    }

    public boolean isRotatable() {
        return this.rotatable;
    }

    public void setRotatable(boolean rotatable) {
        this.rotatable = rotatable;
    }

    public String getGuiTexture() {
        return "textures/gui/" + this.eConfig.NAMEDID + "_gui.png";
    }
}

