/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.api;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import evilcraft.api.Coordinate;
import evilcraft.api.DirectionCorner;
import evilcraft.api.IInformationProvider;
import evilcraft.api.entities.tileentitites.EvilCraftTileEntity;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class Helpers {
    public static final int MINECRAFT_DAY = 24000;
    public static final int COMPARATOR_MULTIPLIER = 15;
    public static List<ForgeDirection> DIRECTIONS = Arrays.asList(ForgeDirection.VALID_DIRECTIONS);
    public static List<DirectionCorner> DIRECTIONS_CORNERS = Arrays.asList(DirectionCorner.VALID_DIRECTIONS);
    public static final ForgeDirection[] ENTITYFACING = new ForgeDirection[]{ForgeDirection.SOUTH, ForgeDirection.WEST, ForgeDirection.NORTH, ForgeDirection.EAST};
    public static ForgeDirection[][] TEXTURESIDE_ORIENTATION = new ForgeDirection[][]{{ForgeDirection.DOWN, ForgeDirection.UP, ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.WEST, ForgeDirection.EAST}, {ForgeDirection.DOWN, ForgeDirection.UP, ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.WEST, ForgeDirection.EAST}, {ForgeDirection.DOWN, ForgeDirection.UP, ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.WEST, ForgeDirection.EAST}, {ForgeDirection.DOWN, ForgeDirection.UP, ForgeDirection.SOUTH, ForgeDirection.NORTH, ForgeDirection.EAST, ForgeDirection.WEST}, {ForgeDirection.DOWN, ForgeDirection.UP, ForgeDirection.EAST, ForgeDirection.WEST, ForgeDirection.NORTH, ForgeDirection.SOUTH}, {ForgeDirection.DOWN, ForgeDirection.UP, ForgeDirection.WEST, ForgeDirection.EAST, ForgeDirection.SOUTH, ForgeDirection.NORTH}};
    private static boolean ISOBFUSICATED_CHECKED = false;
    private static boolean ISOBFUSICATED;
    private static Map<IDType, Integer> ID_COUNTER;
    public static List<String> CHESTGENCATEGORIES;

    public static boolean isDay(World world) {
        return world.func_72820_D() % 24000L < 12000L;
    }

    public static void setDay(World world, boolean toDay) {
        int currentTime = (int)world.func_72820_D();
        int newTime = currentTime - currentTime % 12000 + 12000;
        world.func_72877_b((long)newTime);
    }

    public static Entity spawnCreature(World world, int entityID, double x, double y, double z) {
        if (!EntityList.field_75627_a.containsKey(entityID)) {
            return null;
        }
        Entity entity = EntityList.func_75616_a((int)entityID, (World)world);
        if (entity != null && entity.func_70089_S()) {
            EntityLiving entityliving = (EntityLiving)entity;
            entity.func_70012_b(x, y, z, MathHelper.func_76142_g((float)(world.field_73012_v.nextFloat() * 360.0f)), 0.0f);
            entityliving.field_70759_as = entityliving.field_70177_z;
            entityliving.field_70761_aq = entityliving.field_70177_z;
            entityliving.func_110161_a((IEntityLivingData)null);
            world.func_72838_d(entity);
            entityliving.func_70642_aH();
        }
        return entity;
    }

    public static int RGBToInt(int r, int g, int b) {
        return r << 16 | g << 8 | b;
    }

    public static void preDestroyBlock(World world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof IInventory && !world.field_72995_K) {
            Helpers.dropItems(world, (IInventory)tile, x, y, z);
            Helpers.clearInventory((IInventory)tile);
        }
        if (tile instanceof EvilCraftTileEntity) {
            ((EvilCraftTileEntity)tile).destroy();
        }
    }

    public static void dropItems(World world, ItemStack stack, int x, int y, int z) {
        if (stack.field_77994_a > 0) {
            float offsetMultiply = 0.7f;
            double offsetX = (double)(world.field_73012_v.nextFloat() * offsetMultiply) + (double)(1.0f - offsetMultiply) * 0.5;
            double offsetY = (double)(world.field_73012_v.nextFloat() * offsetMultiply) + (double)(1.0f - offsetMultiply) * 0.5;
            double offsetZ = (double)(world.field_73012_v.nextFloat() * offsetMultiply) + (double)(1.0f - offsetMultiply) * 0.5;
            EntityItem entityitem = new EntityItem(world, (double)x + offsetX, (double)y + offsetY, (double)z + offsetZ, stack);
            entityitem.field_145804_b = 10;
            world.func_72838_d((Entity)entityitem);
        }
    }

    public static void dropItems(World world, IInventory inventory, int x, int y, int z) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack itemStack = inventory.func_70301_a(i);
            if (itemStack == null || itemStack.field_77994_a <= 0) continue;
            Helpers.dropItems(world, inventory.func_70301_a(i).func_77946_l(), x, y, z);
        }
    }

    public static void clearInventory(IInventory inventory) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            inventory.func_70299_a(i, null);
        }
    }

    public static int doesEnchantApply(ItemStack itemStack, int enchantID) {
        NBTTagList enchantmentList;
        if (itemStack != null && (enchantmentList = itemStack.func_77986_q()) != null) {
            for (int i = 0; i < enchantmentList.func_74745_c(); ++i) {
                if (enchantmentList.func_150305_b(i).func_74765_d("id") != enchantID) continue;
                return i;
            }
        }
        return -1;
    }

    public static int getEnchantmentLevel(ItemStack itemStack, int enchantmentListID) {
        NBTTagList enchlist = itemStack.func_77986_q();
        return enchlist.func_150305_b(enchantmentListID).func_74765_d("lvl");
    }

    public static Iterator<Coordinate> getSideIterator(int xc, int yc, int zc) {
        LinkedList<Coordinate> coordinates = new LinkedList<Coordinate>();
        for (int x = xc - 1; x <= xc + 1; ++x) {
            for (int y = yc - 1; y <= yc + 1; ++y) {
                for (int z = zc - 1; z <= zc + 1; ++z) {
                    if (Math.abs(x - xc) + Math.abs(y - yc) + Math.abs(z - zc) != 1) continue;
                    coordinates.add(new Coordinate(x, y, z));
                }
            }
        }
        return coordinates.iterator();
    }

    public static Iterator<ForgeDirection> getDirectionIterator() {
        return DIRECTIONS.iterator();
    }

    public static boolean isOp(ICommandSender sender) {
        return MinecraftServer.func_71276_C().func_71203_ab().func_72353_e(sender.func_70005_c_());
    }

    public static Object tryParse(String newValue, Object oldValue) {
        Object newValueParsed = null;
        try {
            if (oldValue instanceof Integer) {
                newValueParsed = Integer.parseInt(newValue);
            } else if (oldValue instanceof Boolean) {
                newValueParsed = Boolean.parseBoolean(newValue);
            } else if (oldValue instanceof Double) {
                newValueParsed = Double.parseDouble(newValue);
            } else if (oldValue instanceof String) {
                newValueParsed = newValue;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return newValueParsed;
    }

    public static ForgeDirection getEntityFacingDirection(EntityLivingBase entity) {
        int facingDirection = MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        return ENTITYFACING[facingDirection];
    }

    public static ForgeDirection getForgeDirectionFromXSign(int xSign) {
        return xSign > 0 ? ForgeDirection.EAST : ForgeDirection.WEST;
    }

    public static ForgeDirection getForgeDirectionFromZSing(int zSign) {
        return zSign > 0 ? ForgeDirection.SOUTH : ForgeDirection.NORTH;
    }

    public static boolean isObfusicated() {
        if (!ISOBFUSICATED_CHECKED) {
            ISOBFUSICATED_CHECKED = true;
            ISOBFUSICATED = false;
            try {
                Minecraft.func_71410_x().getClass().getField("currentScreen");
            }
            catch (NoSuchFieldException e) {
                ISOBFUSICATED = true;
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return ISOBFUSICATED;
    }

    public static boolean isPlayerInventoryFull(EntityPlayer player) {
        return player.field_71071_by.func_70447_i() == -1;
    }

    public static boolean isClientSide() {
        return FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT;
    }

    public static void onEntityCollided(World world, int x, int y, int z, Entity entity) {
        Block block = world.func_147439_a(x, y, z);
        if (block != null) {
            block.func_149670_a(world, x, y, z, entity);
        }
    }

    public static float normalizeAngle_180(float angle) {
        angle %= 360.0f;
        while (angle <= -180.0f) {
            angle += 360.0f;
        }
        while (angle > 180.0f) {
            angle -= 360.0f;
        }
        return angle;
    }

    public static String getLocalizedInfo(Block block) {
        return IInformationProvider.INFO_PREFIX + StatCollector.func_74838_a((String)(block.func_149739_a() + ".info"));
    }

    public static String getLocalizedInfo(Item item) {
        return Helpers.getLocalizedInfo(item, "");
    }

    public static String getLocalizedInfo(Item item, String suffix) {
        return IInformationProvider.INFO_PREFIX + StatCollector.func_74838_a((String)(item.func_77658_a() + ".info" + suffix));
    }

    public static NetworkRegistry.TargetPoint createTargetPointFromEntityPosition(Entity entity, int range) {
        return new NetworkRegistry.TargetPoint(entity.field_71093_bK, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, (double)range);
    }

    public static int getNewId(IDType type) {
        Integer ID = ID_COUNTER.get((Object)type);
        if (ID == null) {
            ID = new Integer(0);
        }
        ID_COUNTER.put(type, ID + 1);
        return ID;
    }

    static {
        ID_COUNTER = new HashMap<IDType, Integer>();
        CHESTGENCATEGORIES = new LinkedList<String>();
        CHESTGENCATEGORIES.add("bonusChest");
        CHESTGENCATEGORIES.add("dungeonChest");
        CHESTGENCATEGORIES.add("mineshaftCorridor");
        CHESTGENCATEGORIES.add("pyramidDesertyChest");
        CHESTGENCATEGORIES.add("pyramidJungleChest");
        CHESTGENCATEGORIES.add("pyramidJungleDispenser");
        CHESTGENCATEGORIES.add("strongholdCorridor");
        CHESTGENCATEGORIES.add("strongholdCrossing");
        CHESTGENCATEGORIES.add("strongholdLibrary");
        CHESTGENCATEGORIES.add("villageBlacksmith");
    }

    public static enum IDType {
        ENTITY,
        GUI;

    }

    public static enum NBTTag_Types {
        NBTTagEnd,
        NBTTagByte,
        NBTTagShort,
        NBTTagInt,
        NBTTagLong,
        NBTTagFloat,
        NBTTagDouble,
        NBTTagByteArray,
        NBTTagString,
        NBTTagList,
        NBTTagCompound,
        NBTTagIntArray;

    }
}

