/*
 * Decompiled with CFR 0.152.
 */
package evilcraft;

import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.network.FMLEventChannel;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import evilcraft.Configs;
import evilcraft.CustomDeathMessageRegistry;
import evilcraft.GeneralConfig;
import evilcraft.Recipes;
import evilcraft.api.Debug;
import evilcraft.api.LoggerHelper;
import evilcraft.api.config.ConfigHandler;
import evilcraft.commands.CommandEvilCraft;
import evilcraft.gui.GuiHandler;
import evilcraft.gui.client.GuiMainMenuEvilifier;
import evilcraft.proxies.CommonProxy;
import evilcraft.worldgen.DarkTempleGenerator;
import evilcraft.worldgen.EvilDungeonGenerator;
import evilcraft.worldgen.EvilWorldGenerator;
import net.minecraft.command.ICommand;
import org.apache.logging.log4j.Level;

@Mod(modid="evilcraft", name="EvilCraft", useMetadata=true, version="0.2.3b", dependencies="after:BuildCraft|Transport;after:ThermalExpansion")
public class EvilCraft {
    @SidedProxy(clientSide="evilcraft.proxies.ClientProxy", serverSide="evilcraft.proxies.CommonProxy")
    public static CommonProxy proxy;
    public static EvilCraft _instance;
    public static FMLEventChannel channel;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        LoggerHelper.init();
        LoggerHelper.log(Level.INFO, "preInit()");
        _instance = this;
        Configs.getInstance().registerGeneralConfigs();
        ConfigHandler.getInstance().handle(event);
        Configs.getInstance().registerVanillaDictionary();
        Configs.getInstance().registerConfigs();
        if (GeneralConfig.debug) {
            Debug.checkPreConfigurables(Configs.getInstance().configs);
        }
        ConfigHandler.getInstance().handle(event);
        if (GeneralConfig.debug) {
            Debug.checkPostConfigurables();
        }
        CustomDeathMessageRegistry.register();
        proxy.registerEventHooks();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        LoggerHelper.log(Level.INFO, "init()");
        GameRegistry.registerWorldGenerator((IWorldGenerator)new EvilWorldGenerator(), (int)5);
        GameRegistry.registerWorldGenerator((IWorldGenerator)new EvilDungeonGenerator(), (int)2);
        GameRegistry.registerWorldGenerator((IWorldGenerator)new DarkTempleGenerator(), (int)1);
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new GuiHandler());
        if (event.getSide() == Side.CLIENT) {
            GuiMainMenuEvilifier.evilifyMainMenu();
        }
        proxy.registerRenderers();
        proxy.registerKeyBindings();
        proxy.registerPacketHandlers();
        proxy.registerTickHandlers();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        LoggerHelper.log(Level.INFO, "postInit()");
        Recipes.registerRecipes();
    }

    @Mod.EventHandler
    public void onServerStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandEvilCraft());
    }

    public static void log(String message) {
        EvilCraft.log(message, Level.INFO);
    }

    public static void log(String message, Level level) {
        LoggerHelper.log(level, message);
    }
}

