/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.worldgen.structure;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.World;

public abstract class QuarterSymmetricalStructure {
    private List<Integer> layerHeights = new ArrayList<Integer>();
    private List<BlockWrapper[]> layers = new ArrayList<BlockWrapper[]>();
    protected int quarterWidth;
    protected int quarterHeight;

    public QuarterSymmetricalStructure(int quarterWidth, int quarterHeight) {
        this.quarterWidth = quarterWidth;
        this.quarterHeight = quarterHeight;
        this.generateLayers();
    }

    protected abstract void generateLayers();

    protected void addLayer(int height, BlockWrapper[] layer) {
        this.layerHeights.add(height);
        this.layers.add(layer);
    }

    protected void buildCorner(World world, int x, int y, int z, int incX, int incZ) {
        for (int i = 0; i < this.layerHeights.size(); ++i) {
            int start;
            int layerHeight = this.layerHeights.get(i);
            BlockWrapper[] layer = this.layers.get(i);
            for (int zr = start = incX == incZ ? 0 : 1; zr < this.quarterHeight; ++zr) {
                for (int xr = start; xr < this.quarterWidth; ++xr) {
                    BlockWrapper wrapper = layer[(this.quarterWidth - xr - 1) * this.quarterHeight + zr];
                    if (wrapper == null) continue;
                    world.func_147465_d(x + xr * incX, y + layerHeight, z + zr * incZ, wrapper.block, wrapper.metadata, 2);
                }
            }
        }
        this.postBuildCorner(world, x, y, z, incX, incZ);
    }

    protected void postBuildCorner(World world, int x, int y, int z, int incX, int incZ) {
    }

    public boolean generate(World world, Random random, int x, int y, int z) {
        this.buildCorner(world, x, y, z, 1, 1);
        this.buildCorner(world, x, y, z, -1, 1);
        this.buildCorner(world, x, y, z, 1, -1);
        this.buildCorner(world, x, y, z, -1, -1);
        return true;
    }

    public class BlockWrapper {
        public Block block;
        public int metadata;

        public BlockWrapper(Block block) {
            this(block, 0);
        }

        public BlockWrapper(Block block, int metadata) {
            this.block = block;
            this.metadata = metadata;
        }
    }
}

