/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.network;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import evilcraft.EvilCraft;
import evilcraft.api.Helpers;
import evilcraft.network.FartPacket;
import evilcraft.render.particle.EntityFartFX;
import io.netty.buffer.ByteBuf;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.world.World;

public class FartPacketHandler {
    private static final int FART_RANGE = 3000;
    private static final int MAX_PARTICLES = 200;
    private static final int MIN_PARTICLES = 100;
    private static final float CLIENT_PLAYER_Y_OFFSET = -0.8f;
    private static final float REMOTE_PLAYER_Y_OFFSET = 0.65f;
    private static final String[] ALLOW_RAINBOW_FARTS = new String[]{"kroeserr", "_EeB_"};

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onClientPacketReceived(FMLNetworkEvent.ClientCustomPacketEvent event) {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        if (event.packet.payload().readableBytes() > 0) {
            this.handleClientFartPacket((EntityPlayer)player, event.packet);
        }
    }

    @SubscribeEvent
    public void onServerPacketReceived(FMLNetworkEvent.ServerCustomPacketEvent event) {
        EntityPlayerMP player = ((NetHandlerPlayServer)event.handler).field_147369_b;
        EvilCraft.channel.sendToAllAround((FMLProxyPacket)FartPacket.createFartPacket((EntityPlayer)player), Helpers.createTargetPointFromEntityPosition((Entity)player, 3000));
    }

    private void handleClientFartPacket(EntityPlayer player, FMLProxyPacket packet) {
        boolean isRemotePlayer;
        ByteBuf buffer = packet.payload();
        World world = player.field_70170_p;
        String username = ByteBufUtils.readUTF8String((ByteBuf)packet.payload());
        boolean bl = isRemotePlayer = !player.getDisplayName().equals(username);
        if (isRemotePlayer) {
            player = world.func_72924_a(username);
            double posX = buffer.readDouble();
            double posY = buffer.readDouble();
            double posZ = buffer.readDouble();
            this.spawnFartParticles(world, player, posX, posY, posZ, true);
        } else {
            this.spawnFartParticles(world, player, false);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnFartParticles(World world, EntityPlayer player, boolean isRemotePlayer) {
        this.spawnFartParticles(world, player, player.field_70165_t, player.field_70163_u, player.field_70161_v, isRemotePlayer);
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnFartParticles(World world, EntityPlayer player, double posX, double posY, double posZ, boolean isRemotePlayer) {
        if (player == null) {
            return;
        }
        Random rand = world.field_73012_v;
        int numParticles = rand.nextInt(100) + 100;
        boolean rainbow = this.hasRainbowFart(player);
        double yaw = (double)player.field_70177_z * Math.PI / 180.0;
        double playerXOffset = Math.sin(yaw) * 0.7;
        double playerZOffset = -Math.cos(yaw) * 0.7;
        float playerYOffset = isRemotePlayer ? 0.65f : -0.8f;
        for (int i = 0; i < numParticles; ++i) {
            double extraDistance = (double)rand.nextFloat() % 0.3;
            double particleX = posX + playerXOffset + extraDistance;
            double particleY = posY + (double)playerYOffset;
            double particleZ = posZ + playerZOffset + extraDistance;
            float particleMotionX = -0.5f + rand.nextFloat();
            float particleMotionY = -0.5f + rand.nextFloat();
            float particleMotionZ = -0.5f + rand.nextFloat();
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)new EntityFartFX(world, particleX, particleY, particleZ, particleMotionX, particleMotionY, particleMotionZ, rainbow));
        }
    }

    public boolean hasRainbowFart(EntityPlayer player) {
        for (String name : ALLOW_RAINBOW_FARTS) {
            if (!name.equals(player.func_70005_c_())) continue;
            return true;
        }
        return false;
    }
}

