/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.entities.tileentities.tickaction.bloodchest;

import evilcraft.api.config.configurable.ConfigurableEnchantment;
import evilcraft.api.entities.tileentitites.tickaction.ITickAction;
import evilcraft.blocks.BloodChestConfig;
import evilcraft.enchantment.EnchantmentBreaking;
import evilcraft.entities.tileentities.TileBloodChest;
import java.util.LinkedList;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.ItemStack;

public class RepairItemTickAction
implements ITickAction<TileBloodChest> {
    protected static final int MB_PER_DAMAGE = 1;
    protected static final int TICKS_PER_DAMAGE = 2;
    private static final int CHANCE_RANDOM_ENCHANT = 10000;
    private static final LinkedList<ConfigurableEnchantment> BAD_ENCHANTS = new LinkedList();

    @Override
    public boolean canTick(TileBloodChest tile, ItemStack itemStack, int slot, int tick) {
        return !tile.getTank().isEmpty() && itemStack != null;
    }

    private void repair(TileBloodChest tile, ItemStack itemStack) {
        tile.getTank().drain(1, true);
        int newDamage = itemStack.func_77960_j() - 1;
        itemStack.func_77964_b(newDamage);
        if (BloodChestConfig.addRandomBadEnchants && tile.func_145831_w().field_73012_v.nextInt(10000) == 0) {
            ConfigurableEnchantment enchantment = BAD_ENCHANTS.get(tile.func_145831_w().field_73012_v.nextInt(BAD_ENCHANTS.size()));
            itemStack.func_77966_a((Enchantment)enchantment, enchantment.func_77319_d() + tile.func_145831_w().field_73012_v.nextInt(enchantment.func_77325_b() - enchantment.func_77319_d()));
        }
    }

    @Override
    public void onTick(TileBloodChest tile, ItemStack itemStack, int slot, int tick) {
        if (tick >= this.getRequiredTicks(tile, slot) && !tile.getTank().isEmpty() && tile.getTank().getFluidAmount() >= 1 && itemStack != null && itemStack.func_77951_h() && itemStack.func_77973_b().isRepairable()) {
            this.repair(tile, itemStack);
        }
    }

    @Override
    public int getRequiredTicks(TileBloodChest tile, int slot) {
        return 2;
    }

    static {
        BAD_ENCHANTS.add(EnchantmentBreaking.getInstance());
    }
}

