/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.api.config.configurable;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import evilcraft.api.config.ElementType;
import evilcraft.api.config.ExtendedConfig;
import evilcraft.api.config.configurable.Configurable;
import evilcraft.api.render.CustomRenderBlocks;
import evilcraft.api.render.IMultiRenderPassBlock;
import evilcraft.api.render.MultiPassBlockRenderer;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;

public abstract class ConfigurableBlock
extends Block
implements Configurable,
IMultiRenderPassBlock {
    protected ExtendedConfig eConfig = null;
    public static ElementType TYPE = ElementType.BLOCK;
    protected int pass = 0;
    protected CustomRenderBlocks renderer;
    protected boolean isInventoryBlock = false;

    public ConfigurableBlock(ExtendedConfig eConfig, Material material) {
        super(material);
        this.setConfig(eConfig);
        this.func_149663_c(this.getUniqueName());
    }

    @Override
    public void setConfig(ExtendedConfig eConfig) {
        this.eConfig = eConfig;
    }

    @Override
    public String getUniqueName() {
        return "blocks." + this.eConfig.NAMEDID;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.field_149761_L = iconRegister.func_94245_a(this.func_149641_N());
    }

    public String func_149641_N() {
        return "evilcraft:" + this.eConfig.NAMEDID;
    }

    @Override
    public boolean isEntity() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return this.getIcon(side, meta, this.pass);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side, int meta, int renderPass) {
        if (renderPass < 0) {
            return null;
        }
        return super.func_149691_a(side, meta);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149645_b() {
        return this.getRenderPasses() == 1 ? super.func_149645_b() : MultiPassBlockRenderer.ID;
    }

    @Override
    public int getRenderPasses() {
        return 1;
    }

    @Override
    public void setRenderPass(int pass) {
        this.pass = pass < this.getRenderPasses() ? pass : this.getRenderPasses() - 1;
    }

    @Override
    public boolean shouldRender(int pass) {
        return true;
    }

    @Override
    public void setRenderBlocks(CustomRenderBlocks renderer) {
        this.renderer = renderer;
    }

    @Override
    public CustomRenderBlocks getRenderBlocks() {
        return this.renderer;
    }

    @Override
    public void updateTileEntity(IBlockAccess world, int x, int y, int z) {
    }

    @Override
    public void setInventoryBlock(boolean isInventoryBlock) {
        this.isInventoryBlock = isInventoryBlock;
    }
}

