/*
 * Decompiled with CFR 0.152.
 */
package enhancedbiomes.world.gen;

import enhancedbiomes.blocks.EnhancedBiomesBlocks;
import enhancedbiomes.helpers.EnhancedBiomesMath;
import enhancedbiomes.helpers.EnhancedBiomesWorldHelper;
import enhancedbiomes.world.gen.geometry.WorldGenCylinderIfEmpty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeavesBase;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;

public class WorldGenKapok
extends WorldGenAbstractTree {
    int height;
    Block woodId;
    int woodMeta;
    BlockLeavesBase leavesId;
    int leavesMeta;

    public WorldGenKapok(Block woodId, int woodMeta, BlockLeavesBase leavesId, int leavesMeta, int height) {
        super(true);
        this.height = height;
        this.woodId = woodId;
        this.woodMeta = woodMeta;
        this.leavesId = leavesId;
        this.leavesMeta = leavesMeta;
    }

    public boolean func_76484_a(World var1, Random var2, int var3, int var4, int var5) {
        int a;
        if (!var1.func_147439_a(var3, var4 - 1, var5).canSustainPlant((IBlockAccess)var1, var3, var4 - 1, var5, ForgeDirection.UP, (IPlantable)EnhancedBiomesBlocks.saplingEB)) {
            return false;
        }
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < 2; ++x) {
                for (int z = 0; z < 2; ++z) {
                    if (var1.func_147439_a(var3 + z, var4 + y, var5 + x) == Blocks.field_150350_a) continue;
                    return false;
                }
            }
        }
        for (int i = 0; i < this.height; ++i) {
            var1.func_147465_d(var3, var4 + i, var5, this.woodId, this.woodMeta, 3);
            var1.func_147465_d(var3 + 1, var4 + i, var5, this.woodId, this.woodMeta, 3);
            var1.func_147465_d(var3, var4 + i, var5 + 1, this.woodId, this.woodMeta, 3);
            var1.func_147465_d(var3 + 1, var4 + i, var5 + 1, this.woodId, this.woodMeta, 3);
        }
        ArrayList<Integer> buttressList = new ArrayList<Integer>(Arrays.asList(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11));
        for (a = 0; a < 4; ++a) {
            int currentButress = buttressList.get(var2.nextInt(buttressList.size()));
            int x = var3;
            int z = var5;
            int endX = var3;
            int endZ = var5;
            switch (currentButress) {
                case 0: {
                    --x;
                    z += 0;
                    break;
                }
                case 1: {
                    --x;
                    --z;
                    break;
                }
                case 2: {
                    x += 0;
                    --z;
                    break;
                }
                case 3: {
                    ++x;
                    --z;
                    break;
                }
                case 4: {
                    x += 2;
                    --z;
                    break;
                }
                case 5: {
                    x += 2;
                    z += 0;
                    break;
                }
                case 6: {
                    x += 2;
                    ++z;
                    break;
                }
                case 7: {
                    x += 2;
                    z += 2;
                    break;
                }
                case 8: {
                    ++x;
                    z += 2;
                    break;
                }
                case 9: {
                    x += 0;
                    z += 2;
                    break;
                }
                case 10: {
                    --x;
                    z += 2;
                    break;
                }
                case 11: {
                    --x;
                    ++z;
                    break;
                }
                default: {
                    --x;
                    --z;
                }
            }
            endX = x - var3 == 1 || x - var3 == 2 ? x + 2 : x - 2;
            endZ = z - var5 == 1 || z - var5 == 2 ? z + 2 : z - 2;
            for (int b = 0; b < 4; ++b) {
                EnhancedBiomesWorldHelper.setBlockIfEmpty(x, var4 + b, z, this.woodId, this.woodMeta, 3, var1);
                EnhancedBiomesWorldHelper.setBlockIfEmpty((int)EnhancedBiomesMath.average(x, endX), var4 + b - 2, (int)EnhancedBiomesMath.average(z, endZ), this.woodId, this.woodMeta, 3, var1);
                EnhancedBiomesWorldHelper.setBlockIfEmpty(endX, var4 + b - 3, endZ, this.woodId, this.woodMeta, 3, var1);
            }
        }
        for (a = 0; a < 10; ++a) {
            int heightOnTrunk = this.height - var2.nextInt(10) - 3;
            int disX = var2.nextInt(22) - 10;
            int disY = var2.nextInt(7) - 3;
            int disZ = var2.nextInt(22) - 10;
            int posX = var3 + disX;
            int posY = var4 + heightOnTrunk + disY;
            int posZ = var5 + disZ;
            for (int b = 0; b < 10; ++b) {
                int x = disX * (b + 1) / 10;
                int y = disY * (b + 1) / 10;
                int z = disZ * (b + 1) / 10;
                var1.func_147465_d(var3 + x, var4 + heightOnTrunk - 1 + y, var5 + z, this.woodId, this.woodMeta, 3);
                if (b != 9) continue;
                posX = var3 + x;
                posY = var4 + heightOnTrunk - 1 + y;
                posZ = var5 + z;
            }
            var1.func_147465_d(posX, posY, posZ, this.woodId, this.woodMeta, 3);
            new WorldGenCylinderIfEmpty((Block)this.leavesId, this.leavesMeta, 5, 1).func_76484_a(var1, var2, posX, posY, posZ);
            new WorldGenCylinderIfEmpty((Block)this.leavesId, this.leavesMeta, 3, 1).func_76484_a(var1, var2, posX, posY + 1, posZ);
        }
        int chX = var2.nextInt(2);
        int chZ = var2.nextInt(2);
        var1.func_147465_d(var3, var4 + this.height, var5, this.woodId, this.woodMeta, 3);
        new WorldGenCylinderIfEmpty((Block)this.leavesId, this.leavesMeta, 7, 1).func_76484_a(var1, var2, var3 + chX, var4 + this.height, var5 + chZ);
        new WorldGenCylinderIfEmpty((Block)this.leavesId, this.leavesMeta, 5, 1).func_76484_a(var1, var2, var3 + chX, var4 + this.height + 1, var5 + chZ);
        return true;
    }
}

