/*
 * Decompiled with CFR 0.152.
 */
package enhancedbiomes.handlers;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import enhancedbiomes.EnhancedBiomesMod;
import enhancedbiomes.world.ChunkProviderEnhancedBiomes;
import enhancedbiomes.world.MapGenCavesEnhancedBiomes;
import enhancedbiomes.world.MapGenRavineEnhancedBiomes;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.ChunkProviderGenerate;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import net.minecraftforge.event.terraingen.ChunkProviderEvent;
import net.minecraftforge.event.terraingen.InitNoiseGensEvent;

public class ReplaceBiomeBlocksHandler {
    private static double[] stoneNoise = new double[256];
    private static double[] stoneVariantNoise = new double[256];
    private static NoiseGeneratorPerlin perlin;

    @SubscribeEvent
    public void replaceBlocksForBiome(ChunkProviderEvent.ReplaceBiomeBlocks e) {
        if (e.biomeArray != null && (e.chunkProvider instanceof ChunkProviderGenerate || e.chunkProvider instanceof ChunkProviderEnhancedBiomes) && e.world.field_73011_w.field_76574_g == 0) {
            if (perlin == null) {
                perlin = new NoiseGeneratorPerlin(e.world.field_73012_v, 4);
            }
            double d0 = 0.03125;
            stoneNoise = perlin.func_151599_a(stoneNoise, (double)(e.chunkX * 16), (double)(e.chunkZ * 16), 16, 16, d0 * 2.0, d0 * 2.0, 1.0);
            stoneVariantNoise = perlin.func_151599_a(stoneNoise, (double)(e.chunkX * 16), (double)(e.chunkZ * 16), 16, 16, d0 * 2.0, d0 * 2.0, 1.0);
            for (int var8 = 0; var8 < 16; ++var8) {
                for (int var9 = 0; var9 < 16; ++var9) {
                    EnhancedBiomesMod.setStoneNoiseForCoords(e.chunkX * 16 + var8, e.chunkZ * 16 + var9, stoneVariantNoise[var9 + var8 * 16]);
                    BiomeGenBase biomegenbase = e.biomeArray[var9 + var8 * 16];
                    biomegenbase.func_150573_a(e.world, e.world.field_73012_v, e.blockArray, e.metaArray, e.chunkX * 16 + var8, e.chunkZ * 16 + var9, stoneNoise[var9 + var8 * 16]);
                    int i1 = e.chunkX * 16 + var8 & 0xF;
                    int j1 = e.chunkZ * 16 + var9 & 0xF;
                    int k1 = e.blockArray.length / 256;
                    for (int l1 = 255; l1 >= 0; --l1) {
                        int i2 = (j1 * 16 + i1) * k1 + l1;
                        if (e.blockArray[i2] == Blocks.field_150348_b) {
                            e.blockArray[i2] = EnhancedBiomesMod.getRockForCoordsAndBiome(e.chunkX * 16 + var8, e.chunkZ * 16 + var9, biomegenbase.field_76756_M);
                            e.metaArray[i2] = EnhancedBiomesMod.getRockMetaForCoordsAndBiome(e.chunkX * 16 + var8, e.chunkZ * 16 + var9, biomegenbase.field_76756_M);
                        } else if (e.blockArray[i2] == Blocks.field_150347_e) {
                            e.blockArray[i2] = EnhancedBiomesMod.getCobbleFromStone(EnhancedBiomesMod.getRockForCoordsAndBiome(e.chunkX * 16 + var8, e.chunkZ * 16 + var9, biomegenbase.field_76756_M));
                            e.metaArray[i2] = EnhancedBiomesMod.getRockMetaForCoordsAndBiome(e.chunkX * 16 + var8, e.chunkZ * 16 + var9, biomegenbase.field_76756_M);
                        } else if (e.blockArray[i2] == Blocks.field_150346_d) {
                            e.blockArray[i2] = EnhancedBiomesMod.soilList[biomegenbase.field_76756_M];
                            e.metaArray[i2] = EnhancedBiomesMod.soilMetaList[biomegenbase.field_76756_M];
                        } else if (e.blockArray[i2] == Blocks.field_150349_c) {
                            e.blockArray[i2] = EnhancedBiomesMod.grassList[biomegenbase.field_76756_M];
                            e.metaArray[i2] = EnhancedBiomesMod.grassMetaList[biomegenbase.field_76756_M];
                        }
                        e.setResult(Event.Result.DENY);
                    }
                }
            }
            new MapGenCavesEnhancedBiomes().create(e.chunkProvider, e.world, e.chunkX, e.chunkZ, e.blockArray, e.metaArray);
            new MapGenRavineEnhancedBiomes().create(e.chunkProvider, e.world, e.chunkX, e.chunkZ, e.blockArray, e.metaArray);
        }
    }

    @SubscribeEvent
    public void receiveNoiseGens(InitNoiseGensEvent e) {
        if (e.world.field_73011_w.field_76574_g == 0 && e.originalNoiseGens[3] instanceof NoiseGeneratorPerlin) {
            if (perlin == null) {
                perlin = (NoiseGeneratorPerlin)e.originalNoiseGens[3];
            }
        }
        e.newNoiseGens = e.originalNoiseGens;
    }
}

