/*
 * Decompiled with CFR 0.152.
 */
package enhancedbiomes.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import enhancedbiomes.blocks.BlockPlanksEB;
import enhancedbiomes.blocks.EnhancedBiomesBlocks;
import enhancedbiomes.helpers.TreeGen;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.IGrowable;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.event.terraingen.TerrainGen;

public class BlockSaplingEnhancedBiomes
extends BlockBush
implements IGrowable {
    public static final String[] woodType = BlockPlanksEB.woodType;
    public static final String[] names = EnhancedBiomesBlocks.woodNames;
    IIcon[] saplingIcons = new IIcon[woodType.length];
    float pixelSize = 0.0625f;

    public BlockSaplingEnhancedBiomes() {
        float var3 = 0.4f;
        this.func_149676_a(0.5f - var3, 0.0f, 0.5f - var3, 0.5f + var3, var3 * 2.0f, 0.5f + var3);
    }

    public void func_149719_a(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
        float[] wh = this.getSaplingWidthAndHeight(par1IBlockAccess.func_72805_g(par2, par3, par4));
        wh[0] = wh[0] * (this.pixelSize / 2.0f);
        wh[1] = wh[1] * this.pixelSize;
        this.func_149676_a(0.5f - wh[0], 0.0f, 0.5f - wh[0], 0.5f + wh[0], wh[1], 0.5f + wh[0]);
    }

    public float[] getSaplingWidthAndHeight(int meta) {
        float[] wh = new float[2];
        switch (meta) {
            case 0: {
                wh[0] = 16.0f;
                wh[1] = 16.0f;
                break;
            }
            case 1: {
                wh[0] = 14.0f;
                wh[1] = 13.0f;
                break;
            }
            case 2: {
                wh[0] = 6.0f;
                wh[1] = 15.0f;
                break;
            }
            case 3: {
                wh[0] = 8.0f;
                wh[1] = 9.0f;
                break;
            }
            case 4: {
                wh[0] = 10.0f;
                wh[1] = 13.0f;
                break;
            }
            case 5: {
                wh[0] = 8.0f;
                wh[1] = 15.0f;
                break;
            }
            case 6: {
                wh[0] = 10.0f;
                wh[1] = 16.0f;
                break;
            }
            case 7: {
                wh[0] = 6.0f;
                wh[1] = 16.0f;
                break;
            }
            case 8: {
                wh[0] = 14.0f;
                wh[1] = 16.0f;
                break;
            }
            case 9: {
                wh[0] = 16.0f;
                wh[1] = 15.0f;
                break;
            }
            case 10: {
                wh[0] = 8.0f;
                wh[1] = 14.0f;
                break;
            }
            case 11: {
                wh[0] = 16.0f;
                wh[1] = 16.0f;
                break;
            }
            case 12: {
                wh[0] = 12.0f;
                wh[1] = 11.0f;
                break;
            }
            case 13: {
                wh[0] = 16.0f;
                wh[1] = 16.0f;
                break;
            }
            case 14: {
                wh[0] = 16.0f;
                wh[1] = 15.0f;
                break;
            }
            case 15: {
                wh[0] = 16.0f;
                wh[1] = 16.0f;
                break;
            }
            default: {
                wh[0] = 16.0f;
                wh[1] = 16.0f;
            }
        }
        return wh;
    }

    public void func_149674_a(World par1World, int par2, int par3, int par4, Random par5Random) {
        if (!par1World.field_72995_K) {
            super.func_149674_a(par1World, par2, par3, par4, par5Random);
            if (par1World.func_72957_l(par2, par3 + 1, par4) >= 9 && par5Random.nextInt(7) == 0) {
                this.markOrGrowMarked(par1World, par2, par3, par4, par5Random);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister par1IconRegister) {
        for (int a = 0; a < 16; ++a) {
            if (EnhancedBiomesBlocks.woodNames[a] == "" || EnhancedBiomesBlocks.woodNames[a] == "Dead") continue;
            this.saplingIcons[a] = par1IconRegister.func_94245_a("enhancedbiomes:sapling_" + woodType[a]);
        }
    }

    public IIcon func_149691_a(int par1, int par2) {
        return this.saplingIcons[par2];
    }

    public void markOrGrowMarked(World par1World, int par2, int par3, int par4, Random par5Random) {
        this.growTree(par1World, par2, par3, par4, par5Random);
    }

    public void growTree(World par1World, int par2, int par3, int par4, Random par5Random) {
        if (!TerrainGen.saplingGrowTree((World)par1World, (Random)par5Random, (int)par2, (int)par3, (int)par4)) {
            return;
        }
        int meta = par1World.func_72805_g(par2, par3, par4);
        WorldGenAbstractTree var7 = null;
        int var8 = 0;
        int var9 = 0;
        boolean var10 = false;
        for (var8 = 0; var8 >= -1; --var8) {
            for (var9 = 0; var9 >= -1; --var9) {
                if (meta == 4) {
                    if (!this.isSameSapling(par1World, par2 + var8, par3, par4 + var9, meta) || !this.isSameSapling(par1World, par2 + var8 + 1, par3, par4 + var9, meta) || !this.isSameSapling(par1World, par2 + var8, par3, par4 + var9 + 1, meta) || !this.isSameSapling(par1World, par2 + var8 + 1, par3, par4 + var9 + 1, meta)) continue;
                    var7 = TreeGen.fir_large(par5Random);
                    var10 = true;
                    break;
                }
                if (meta != 15 || !this.isSameSapling(par1World, par2 + var8, par3, par4 + var9, meta) || !this.isSameSapling(par1World, par2 + var8 + 1, par3, par4 + var9, meta) || !this.isSameSapling(par1World, par2 + var8, par3, par4 + var9 + 1, meta) || !this.isSameSapling(par1World, par2 + var8 + 1, par3, par4 + var9 + 1, meta)) continue;
                var7 = TreeGen.kapok(par5Random);
                var10 = true;
                break;
            }
            if (var7 != null) break;
        }
        if (var7 == null) {
            var9 = 0;
            var8 = 0;
            switch (meta) {
                case 0: {
                    var7 = TreeGen.greatOak(par5Random);
                    break;
                }
                case 1: {
                    var7 = TreeGen.thorntree();
                    break;
                }
                case 2: {
                    var7 = TreeGen.poplar(par5Random);
                    break;
                }
                case 3: {
                    var7 = TreeGen.mangrove();
                    break;
                }
                case 4: {
                    var7 = TreeGen.fir(par5Random);
                    break;
                }
                case 5: {
                    var7 = TreeGen.cypress(par5Random);
                    break;
                }
                case 6: {
                    var7 = TreeGen.pine(par5Random);
                    break;
                }
                case 7: {
                    var7 = TreeGen.silverPine(par5Random);
                    break;
                }
                case 8: {
                    var7 = TreeGen.alder(par5Random);
                    break;
                }
                case 9: {
                    var7 = TreeGen.eucalyptus(par5Random);
                    break;
                }
                case 10: {
                    var7 = TreeGen.aspen(par5Random);
                    break;
                }
                case 11: {
                    var7 = null;
                    break;
                }
                case 12: {
                    var7 = TreeGen.baobab(par5Random);
                    break;
                }
                case 13: {
                    var7 = null;
                    break;
                }
                case 14: {
                    var7 = TreeGen.cherry(par5Random);
                    break;
                }
                case 15: {
                    var7 = null;
                    break;
                }
                default: {
                    var7 = TreeGen.greatOak(par5Random);
                }
            }
            if (var7 == null) {
                var7 = TreeGen.greatOak(par5Random);
            }
        }
        if (var10) {
            par1World.func_147468_f(par2 + var8, par3, par4 + var9);
            par1World.func_147468_f(par2 + var8 + 1, par3, par4 + var9);
            par1World.func_147468_f(par2 + var8, par3, par4 + var9 + 1);
            par1World.func_147468_f(par2 + var8 + 1, par3, par4 + var9 + 1);
        } else {
            par1World.func_147468_f(par2, par3, par4);
        }
        if (!((WorldGenerator)var7).func_76484_a(par1World, par5Random, par2 + var8, par3, par4 + var9)) {
            if (var10) {
                par1World.func_147465_d(par2 + var8, par3, par4 + var9, (Block)this, meta, 3);
                par1World.func_147465_d(par2 + var8 + 1, par3, par4 + var9, (Block)this, meta, 3);
                par1World.func_147465_d(par2 + var8, par3, par4 + var9 + 1, (Block)this, meta, 3);
                par1World.func_147465_d(par2 + var8 + 1, par3, par4 + var9 + 1, (Block)this, meta, 3);
            } else {
                par1World.func_147465_d(par2, par3, par4, (Block)this, meta, 3);
            }
        }
    }

    public boolean isSameSapling(World par1World, int par2, int par3, int par4, int par5) {
        return par1World.func_147439_a(par2, par3, par4) == this && par1World.func_72805_g(par2, par3, par4) == par5;
    }

    public int func_149692_a(int par1) {
        return par1;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        for (int a = 0; a < 16; ++a) {
            if (EnhancedBiomesBlocks.woodNames[a] == "" || EnhancedBiomesBlocks.woodNames[a] == "Dead") continue;
            par3List.add(new ItemStack(par1, 1, a));
        }
    }

    public boolean func_149851_a(World p_149851_1_, int p_149851_2_, int p_149851_3_, int p_149851_4_, boolean p_149851_5_) {
        return true;
    }

    public boolean func_149852_a(World p_149852_1_, Random p_149852_2_, int p_149852_3_, int p_149852_4_, int p_149852_5_) {
        return (double)p_149852_1_.field_73012_v.nextFloat() < 0.45;
    }

    public void func_149853_b(World p_149853_1_, Random p_149853_2_, int p_149853_3_, int p_149853_4_, int p_149853_5_) {
        this.markOrGrowMarked(p_149853_1_, p_149853_3_, p_149853_4_, p_149853_5_, p_149853_2_);
    }
}

