/*
 * Decompiled with CFR 0.152.
 */
package enhancedbiomes;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import enhancedbiomes.blocks.EnhancedBiomesBlocks;
import enhancedbiomes.handlers.CaveHandler;
import enhancedbiomes.handlers.ModOreHandler;
import enhancedbiomes.handlers.OreHandler;
import enhancedbiomes.handlers.RareBiomeHandler;
import enhancedbiomes.handlers.ReplaceBiomeBlocksHandler;
import enhancedbiomes.handlers.SeasonTickHandler;
import enhancedbiomes.handlers.SubBiomeEventHandler;
import enhancedbiomes.handlers.UseHoeEventHandler;
import enhancedbiomes.handlers.VanillaHandler;
import enhancedbiomes.handlers.VillageBlocksHandler;
import enhancedbiomes.handlers.VillageMapHandler;
import enhancedbiomes.proxy.CommonProxy;
import enhancedbiomes.world.WorldTypeEnhancedBiomes;
import enhancedbiomes.world.biome.EnhancedBiomesBiome;
import enhancedbiomes.world.biometype.BiomeTypes;
import java.io.File;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;

@Mod(modid="enhancedbiomes", name="Enhanced Biomes", version="2.3 for MC 1.7.10", useMetadata=true)
public class EnhancedBiomesMod {
    @SidedProxy(clientSide="enhancedbiomes.proxy.ClientProxy", serverSide="enhancedbiomes.proxy.CommonProxy")
    public static CommonProxy proxy;
    @Mod.Instance(value="SMEZ's Enhanced Biomes Mod")
    public static EnhancedBiomesMod instance;
    public static WorldType enhancedBiomesWorldType;
    private static Block[] rockList;
    private static byte[] rockMetaList;
    private static Block[] rockList2;
    private static byte[] rockMetaList2;
    public static Block[] soilList;
    public static byte[] soilMetaList;
    public static Block[] grassList;
    public static byte[] grassMetaList;
    public static Block[] woodList;
    public static byte[] woodMetaList;
    public static float[] biomeTempsList;
    public static boolean[] isStoneVillageList;
    private static ArrayList<ArrayList<Double>> stoneNoisePP;
    private static ArrayList<ArrayList<Double>> stoneNoiseNP;
    private static ArrayList<ArrayList<Double>> stoneNoisePN;
    private static ArrayList<ArrayList<Double>> stoneNoiseNN;
    public static boolean runBiomeCheck;
    public static boolean worldType;
    public static boolean vanilla;
    public static boolean seasons;
    public static int biomeSize;
    public static int villageDistance;
    public static int villageSize;
    public static int ratioIsland;
    public static int ratioOcean;
    public static int seasonLength;
    public static boolean useNewBlocks;
    public static boolean useVillageMods;
    public static boolean useListedRareBiomes;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        File configFile = new File("config/Enhanced Biomes/General.cfg");
        Configuration config = new Configuration(configFile);
        config.load();
        worldType = config.get("general", "Allow world type module", true).getBoolean(true);
        vanilla = config.get("general", "Allow vanilla module", true).getBoolean(true);
        seasons = config.get("general", "Allow seasons module", true).getBoolean(true);
        biomeSize = config.get("general", "Size of biomes", 4, "Normal is 4, large biomes is 6, but other sizes can be chosen").getInt();
        villageDistance = config.get("general", "Distance between villages", 32, "Normal is 32").getInt();
        villageSize = config.get("general", "Size of villages", 0, "Normal is 0").getInt();
        useNewBlocks = config.get("general", "Use new stone", true, "If false, the new stones will not generate instead of regular stone").getBoolean(true);
        useVillageMods = config.get("general", "Enable the modifications to villages", true, "Disabling this will solve issues with other mods which edit the way villages generate").getBoolean(true);
        useListedRareBiomes = config.get("general", "Use EB's rare biome code (Rare biomes have to be registered with EB to work)", true, "If true, rare biomes can have any ID, if false, their ID must be 128 more than their standard biome's ID").getBoolean(true);
        seasonLength = config.get("general", "Days in each season", 4, "Default is 4").getInt();
        config.save();
        configFile = new File("config/Enhanced Biomes/Oceans.cfg");
        config = new Configuration(configFile);
        config.load();
        ratioIsland = config.get("general", "Ratio of Islands", 3, "Default is 3. This determines the ratio of islands to ocean in the 1/3 of the ocean that they generate in").getInt();
        ratioOcean = config.get("general", "Ratio of Ocean", 5, "Default is 5").getInt();
        config.save();
        if (vanilla) {
            VanillaHandler.config();
        }
        EnhancedBiomesBiome.config();
        if (worldType) {
            enhancedBiomesWorldType = new WorldTypeEnhancedBiomes("typeEB");
        }
        if (vanilla) {
            VanillaHandler.load();
        }
        EnhancedBiomesBlocks.load();
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        EnhancedBiomesBiome.load();
        BiomeTypes.registerAllBiomeTypes();
        RareBiomeHandler.registerRareBiomes();
        for (int a = 0; a < BiomeGenBase.func_150565_n().length; ++a) {
            if (rockList[a] == null) {
                EnhancedBiomesMod.rockList[a] = EnhancedBiomesMod.getRocksForBiome(a)[0];
            }
            if (rockMetaList[a] == 0) {
                EnhancedBiomesMod.rockMetaList[a] = EnhancedBiomesMod.getRockMetasForBiome(a)[0];
            }
            if (rockList2[a] == null) {
                EnhancedBiomesMod.rockList2[a] = EnhancedBiomesMod.getRocksForBiome(a)[1];
            }
            if (rockMetaList2[a] == 0) {
                EnhancedBiomesMod.rockMetaList2[a] = EnhancedBiomesMod.getRockMetasForBiome(a)[1];
            }
            if (soilList[a] == null) {
                EnhancedBiomesMod.soilList[a] = EnhancedBiomesMod.getSoilForBiome(a);
            }
            if (soilMetaList[a] == 0) {
                EnhancedBiomesMod.soilMetaList[a] = EnhancedBiomesMod.getSoilMetaForBiome(a);
            }
            if (grassList[a] == null) {
                EnhancedBiomesMod.grassList[a] = EnhancedBiomesMod.getGrassForBiome(a);
            }
            if (grassMetaList[a] == 0) {
                EnhancedBiomesMod.grassMetaList[a] = soilMetaList[a];
            }
            if (woodList[a] == null) {
                EnhancedBiomesMod.woodList[a] = Blocks.field_150344_f;
            }
            EnhancedBiomesMod.biomeTempsList[a] = BiomeGenBase.func_150565_n()[a] != null ? BiomeGenBase.func_150565_n()[a].field_76750_F : 0.5f;
        }
        if (useVillageMods) {
            MinecraftForge.TERRAIN_GEN_BUS.register((Object)new VillageMapHandler());
            MinecraftForge.TERRAIN_GEN_BUS.register((Object)new VillageBlocksHandler());
        }
        MinecraftForge.TERRAIN_GEN_BUS.register((Object)new SubBiomeEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new ReplaceBiomeBlocksHandler());
        MinecraftForge.TERRAIN_GEN_BUS.register((Object)new ReplaceBiomeBlocksHandler());
        MinecraftForge.TERRAIN_GEN_BUS.register((Object)new CaveHandler());
        MinecraftForge.ORE_GEN_BUS.register((Object)new OreHandler());
        MinecraftForge.EVENT_BUS.register((Object)new ModOreHandler());
        MinecraftForge.EVENT_BUS.register((Object)new UseHoeEventHandler());
        if (seasons) {
            FMLCommonHandler.instance().bus().register((Object)new SeasonTickHandler());
        }
        if (runBiomeCheck) {
            for (int x = 0; x < BiomeGenBase.func_150565_n().length; ++x) {
                if (BiomeGenBase.func_150565_n()[x] == null) continue;
                BiomeGenBase biome = BiomeGenBase.func_150565_n()[x];
                Block top = null;
                if (biome.field_76752_A != null) {
                    top = biome.field_76752_A;
                }
                Block filler = null;
                if (biome.field_76753_B != null) {
                    filler = biome.field_76753_B;
                }
                System.out.println(x + ": " + biome.field_76791_y);
                System.out.println("Height: " + biome.field_76748_D + ", " + biome.field_76749_E);
                System.out.println("Temperature: " + biome.field_76750_F);
                System.out.println("Rainfall: " + biome.field_76751_G);
                if (top != null) {
                    System.out.println("Top block: " + top.func_149732_F());
                }
                if (filler != null) {
                    System.out.println("Filler block: " + filler.func_149732_F());
                }
                System.out.print("Biome Types: ");
                for (int a = 0; a < BiomeDictionary.getTypesForBiome((BiomeGenBase)biome).length; ++a) {
                    System.out.print(BiomeDictionary.getTypesForBiome((BiomeGenBase)biome)[a].toString() + ", ");
                }
                System.out.println();
            }
            System.exit(0);
        }
        proxy.init();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
    }

    private static Block[] getRocksForBiome(int id) {
        Block[] bl = new Block[]{Blocks.field_150348_b, Blocks.field_150348_b};
        if (!useNewBlocks) {
            return bl;
        }
        BiomeGenBase biome = BiomeGenBase.func_150565_n()[id];
        if (biome == null) {
            return bl;
        }
        if (BiomeTypes.getNature(biome) == BiomeDictionary.Type.getType((String)"VOLCANIC", (BiomeDictionary.Type[])new BiomeDictionary.Type[0]) || BiomeTypes.getSoil(biome) == BiomeDictionary.Type.WASTELAND) {
            bl[0] = EnhancedBiomesBlocks.stoneEB;
        } else if (biome.field_76753_B == Blocks.field_150354_m || BiomeTypes.getSoil(biome) == BiomeDictionary.Type.SANDY) {
            bl[0] = EnhancedBiomesBlocks.stoneEB;
        } else if (BiomeTypes.getSoil(biome) == BiomeDictionary.Type.SNOWY) {
            bl[0] = EnhancedBiomesBlocks.stoneEB;
        } else if (BiomeTypes.getTreeType(biome) == BiomeDictionary.Type.JUNGLE) {
            bl[0] = EnhancedBiomesBlocks.stoneEB;
        } else if (BiomeTypes.getBiomeType(biome) == BiomeDictionary.Type.FOREST) {
            bl[0] = EnhancedBiomesBlocks.stoneEB;
        } else if (BiomeTypes.getBiomeType(biome) == BiomeDictionary.Type.PLAINS) {
            bl[0] = EnhancedBiomesBlocks.stoneEB;
        } else if (BiomeTypes.getHeight(biome) == BiomeDictionary.Type.MOUNTAIN) {
            bl[0] = EnhancedBiomesBlocks.stoneEB;
        } else if (BiomeTypes.getNature(biome) == BiomeDictionary.Type.OCEAN) {
            bl[0] = EnhancedBiomesBlocks.stoneEB;
        }
        if (BiomeTypes.getNature(biome) == BiomeDictionary.Type.getType((String)"VOLCANIC", (BiomeDictionary.Type[])new BiomeDictionary.Type[0])) {
            bl[1] = EnhancedBiomesBlocks.stoneEB;
        } else if (BiomeTypes.getNature(biome) == BiomeDictionary.Type.RIVER || BiomeTypes.getHeight(biome) == BiomeDictionary.Type.BEACH) {
            bl[1] = EnhancedBiomesBlocks.stoneEB;
        } else if (BiomeTypes.getBiomeType(biome) == BiomeDictionary.Type.FOREST && BiomeTypes.getTreeType(biome) == BiomeDictionary.Type.getType((String)"EBDEF", (BiomeDictionary.Type[])new BiomeDictionary.Type[0]) && (BiomeTypes.getTemp(biome) == BiomeDictionary.Type.getType((String)"EBDEF", (BiomeDictionary.Type[])new BiomeDictionary.Type[0]) || BiomeTypes.getTemp(biome) == BiomeDictionary.Type.HOT) || BiomeTypes.getBiomeType(biome) == BiomeDictionary.Type.MESA || BiomeTypes.getTreeType(biome) == BiomeDictionary.Type.SAVANNA) {
            bl[1] = EnhancedBiomesBlocks.stoneEB;
        } else if (BiomeTypes.getHeight(biome) == BiomeDictionary.Type.MOUNTAIN) {
            bl[1] = EnhancedBiomesBlocks.stoneEB;
        } else if (BiomeTypes.getTreeType(biome) == BiomeDictionary.Type.CONIFEROUS) {
            bl[1] = EnhancedBiomesBlocks.stoneEB;
        } else if (BiomeTypes.getBiomeType(biome) == BiomeDictionary.Type.FOREST) {
            bl[1] = EnhancedBiomesBlocks.stoneEB;
        } else if (BiomeTypes.getNature(biome) == BiomeDictionary.Type.OCEAN) {
            bl[1] = EnhancedBiomesBlocks.stoneEB;
        }
        return bl;
    }

    private static byte[] getRockMetasForBiome(int id) {
        byte[] bl = new byte[]{0, 0};
        if (!useNewBlocks) {
            return bl;
        }
        BiomeGenBase biome = BiomeGenBase.func_150565_n()[id];
        if (biome == null) {
            return bl;
        }
        if (BiomeTypes.getNature(biome) == BiomeDictionary.Type.getType((String)"VOLCANIC", (BiomeDictionary.Type[])new BiomeDictionary.Type[0]) || BiomeTypes.getSoil(biome) == BiomeDictionary.Type.WASTELAND) {
            bl[0] = 0;
        } else if (biome.field_76753_B == Blocks.field_150354_m || BiomeTypes.getSoil(biome) == BiomeDictionary.Type.SANDY) {
            bl[0] = 2;
        } else if (BiomeTypes.getSoil(biome) == BiomeDictionary.Type.SNOWY) {
            bl[0] = 5;
        } else if (BiomeTypes.getTreeType(biome) == BiomeDictionary.Type.JUNGLE) {
            bl[0] = 1;
        } else if (BiomeTypes.getBiomeType(biome) == BiomeDictionary.Type.FOREST) {
            bl[0] = 4;
        } else if (BiomeTypes.getBiomeType(biome) == BiomeDictionary.Type.PLAINS) {
            bl[0] = 5;
        } else if (BiomeTypes.getHeight(biome) == BiomeDictionary.Type.MOUNTAIN) {
            bl[0] = 3;
        } else if (BiomeTypes.getNature(biome) == BiomeDictionary.Type.OCEAN) {
            bl[0] = 2;
        }
        if (BiomeTypes.getNature(biome) == BiomeDictionary.Type.getType((String)"VOLCANIC", (BiomeDictionary.Type[])new BiomeDictionary.Type[0])) {
            bl[1] = 0;
        } else if (BiomeTypes.getNature(biome) == BiomeDictionary.Type.RIVER || BiomeTypes.getHeight(biome) == BiomeDictionary.Type.BEACH) {
            bl[1] = 3;
        } else if (BiomeTypes.getBiomeType(biome) == BiomeDictionary.Type.FOREST && BiomeTypes.getTreeType(biome) == BiomeDictionary.Type.getType((String)"EBDEF", (BiomeDictionary.Type[])new BiomeDictionary.Type[0]) && (BiomeTypes.getTemp(biome) == BiomeDictionary.Type.getType((String)"EBDEF", (BiomeDictionary.Type[])new BiomeDictionary.Type[0]) || BiomeTypes.getTemp(biome) == BiomeDictionary.Type.HOT) || BiomeTypes.getBiomeType(biome) == BiomeDictionary.Type.MESA || BiomeTypes.getTreeType(biome) == BiomeDictionary.Type.SAVANNA) {
            bl[1] = 2;
        } else if (BiomeTypes.getHeight(biome) == BiomeDictionary.Type.MOUNTAIN) {
            bl[1] = 1;
        } else if (BiomeTypes.getTreeType(biome) == BiomeDictionary.Type.CONIFEROUS) {
            bl[1] = 5;
        } else if (BiomeTypes.getBiomeType(biome) == BiomeDictionary.Type.FOREST) {
            bl[1] = 4;
        } else if (BiomeTypes.getNature(biome) == BiomeDictionary.Type.OCEAN) {
            bl[1] = 0;
        }
        return bl;
    }

    private static Block getSoilForBiome(int id) {
        if (!useNewBlocks) {
            return Blocks.field_150346_d;
        }
        BiomeGenBase biome = BiomeGenBase.func_150565_n()[id];
        if (biome == null) {
            return Blocks.field_150346_d;
        }
        if (BiomeTypes.getBiomeType(biome) == BiomeDictionary.Type.MESA) {
            return EnhancedBiomesBlocks.dirtEB;
        }
        if (BiomeTypes.getBiomeType(biome) == BiomeDictionary.Type.FOREST && BiomeTypes.getTreeType(biome) != BiomeDictionary.Type.SAVANNA) {
            return EnhancedBiomesBlocks.dirtEB;
        }
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.COLD)) {
            return EnhancedBiomesBlocks.dirtEB;
        }
        if (BiomeTypes.getNature(biome) == BiomeDictionary.Type.RIVER || BiomeTypes.getBiomeType(biome) == BiomeDictionary.Type.SWAMP) {
            return EnhancedBiomesBlocks.dirtEB;
        }
        if (BiomeTypes.getNature(biome) == BiomeDictionary.Type.getType((String)"VOLCANIC", (BiomeDictionary.Type[])new BiomeDictionary.Type[0]) || BiomeTypes.getNature(biome) == BiomeDictionary.Type.OCEAN) {
            return EnhancedBiomesBlocks.dirtEB;
        }
        if (biome.field_76753_B == Blocks.field_150354_m || BiomeTypes.getSoil(biome) == BiomeDictionary.Type.SANDY || BiomeTypes.getTreeType(biome) == BiomeDictionary.Type.SAVANNA) {
            return EnhancedBiomesBlocks.dirtEB;
        }
        if (BiomeTypes.getBiomeType(biome) == BiomeDictionary.Type.PLAINS) {
            return EnhancedBiomesBlocks.dirtEB;
        }
        if (BiomeTypes.getTemp(biome) == BiomeDictionary.Type.DRY) {
            return EnhancedBiomesBlocks.dirtEB;
        }
        return Blocks.field_150346_d;
    }

    private static byte getSoilMetaForBiome(int id) {
        if (!useNewBlocks) {
            return 0;
        }
        BiomeGenBase biome = BiomeGenBase.func_150565_n()[id];
        if (biome == null) {
            return 0;
        }
        if (BiomeTypes.getBiomeType(biome) == BiomeDictionary.Type.MESA) {
            return 5;
        }
        if (BiomeTypes.getNature(biome) == BiomeDictionary.Type.RIVER || BiomeTypes.getBiomeType(biome) == BiomeDictionary.Type.SWAMP) {
            return 4;
        }
        if (BiomeTypes.getNature(biome) == BiomeDictionary.Type.getType((String)"VOLCANIC", (BiomeDictionary.Type[])new BiomeDictionary.Type[0]) || BiomeTypes.getNature(biome) == BiomeDictionary.Type.OCEAN) {
            return 1;
        }
        if (BiomeTypes.getBiomeType(biome) == BiomeDictionary.Type.FOREST && BiomeTypes.getTreeType(biome) != BiomeDictionary.Type.SAVANNA) {
            return 0;
        }
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.COLD)) {
            return 3;
        }
        if (biome.field_76753_B == Blocks.field_150354_m || BiomeTypes.getSoil(biome) == BiomeDictionary.Type.SANDY || BiomeTypes.getTreeType(biome) == BiomeDictionary.Type.SAVANNA) {
            return 7;
        }
        if (BiomeTypes.getBiomeType(biome) == BiomeDictionary.Type.PLAINS) {
            return 6;
        }
        if (BiomeTypes.getTemp(biome) == BiomeDictionary.Type.DRY) {
            return 5;
        }
        return 0;
    }

    private static Block getGrassForBiome(int id) {
        if (!useNewBlocks) {
            return Blocks.field_150349_c;
        }
        if (EnhancedBiomesMod.getSoilForBiome(id) == Blocks.field_150346_d) {
            return Blocks.field_150349_c;
        }
        return EnhancedBiomesBlocks.grassEB;
    }

    public static boolean isValidIslandBiome(BiomeGenBase biome) {
        if (biome.field_76748_D >= 0.2f) {
            return true;
        }
        return BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP);
    }

    public static float getTideHeight(long time) {
        float r = 63.5f;
        r = (time %= 24000L) <= 6000L ? (float)(63.5 + (double)((int)(time / 500L)) * 0.125) : (time <= 18000L ? (float)(65.0 - (double)((int)((time - 6000L) / 500L)) * 0.125) : (float)(62.0 + (double)((int)((time - 18000L) / 500L)) * 0.125));
        return r;
    }

    private static Block getRockForPos(int biomeID, double d) {
        return d < -0.5 ? rockList2[biomeID] : rockList[biomeID];
    }

    private static byte getRockMetaForPos(int biomeID, double d) {
        return d < -0.5 ? rockMetaList2[biomeID] : rockMetaList[biomeID];
    }

    public static void setStoneNoiseForCoords(int oriX, int oriZ, double noise) {
        int x = Math.abs(oriX);
        int z = Math.abs(oriZ);
        if ((oriX >= 0 ? (oriZ >= 0 ? stoneNoisePP : stoneNoisePN) : (oriZ >= 0 ? stoneNoiseNP : stoneNoiseNN)).size() <= x) {
            ArrayList blankArray = new ArrayList();
            ArrayList<ArrayList<Double>> arrayList = oriX >= 0 ? (oriZ >= 0 ? stoneNoisePP : stoneNoisePN) : (oriZ >= 0 ? stoneNoiseNP : stoneNoiseNN);
            for (int a = (v946).size(); a < x + 1; ++a) {
                (oriX >= 0 ? (oriZ >= 0 ? stoneNoisePP : stoneNoisePN) : (oriZ >= 0 ? stoneNoiseNP : stoneNoiseNN)).add(a, blankArray);
            }
        }
        if ((oriX >= 0 ? (oriZ >= 0 ? stoneNoisePP : stoneNoisePN) : (oriZ >= 0 ? stoneNoiseNP : stoneNoiseNN)).get(x).size() <= z) {
            ArrayList<ArrayList<Double>> arrayList = oriX >= 0 ? (oriZ >= 0 ? stoneNoisePP : stoneNoisePN) : (oriZ >= 0 ? stoneNoiseNP : stoneNoiseNN);
            for (int a = (v975).get(x).size(); a < z + 1; ++a) {
                (oriX >= 0 ? (oriZ >= 0 ? stoneNoisePP : stoneNoisePN) : (oriZ >= 0 ? stoneNoiseNP : stoneNoiseNN)).get(x).add(a, 0.0);
            }
        }
        (oriX >= 0 ? (oriZ >= 0 ? stoneNoisePP : stoneNoisePN) : (oriZ >= 0 ? stoneNoiseNP : stoneNoiseNN)).get(x).set(z, noise);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static double getStoneNoiseForCoords(int oriX, int oriZ) {
        int x = Math.abs(oriX);
        int z = Math.abs(oriZ);
        if ((oriX >= 0 ? (oriZ >= 0 ? stoneNoisePP : stoneNoisePN) : (oriZ >= 0 ? stoneNoiseNP : stoneNoiseNN)).size() < x) return 0.0;
        if ((oriX >= 0 ? (oriZ >= 0 ? stoneNoisePP : stoneNoisePN) : (oriZ >= 0 ? stoneNoiseNP : stoneNoiseNN)).get(x).size() < z) {
            return 0.0;
        }
        double d = (oriX >= 0 ? (oriZ >= 0 ? stoneNoisePP : stoneNoisePN) : (oriZ >= 0 ? stoneNoiseNP : stoneNoiseNN)).get(x).get(z);
        return d;
    }

    public static Block getRockForCoords(int x, int z, World world) {
        return EnhancedBiomesMod.getRockForPos(world.func_72807_a((int)x, (int)z).field_76756_M, EnhancedBiomesMod.getStoneNoiseForCoords(x, z));
    }

    public static byte getRockMetaForCoords(int x, int z, World world) {
        return EnhancedBiomesMod.getRockMetaForPos(world.func_72807_a((int)x, (int)z).field_76756_M, EnhancedBiomesMod.getStoneNoiseForCoords(x, z));
    }

    public static Block getRockForCoordsAndBiome(int x, int z, int biomeID) {
        return EnhancedBiomesMod.getRockForPos(biomeID, EnhancedBiomesMod.getStoneNoiseForCoords(x, z));
    }

    public static byte getRockMetaForCoordsAndBiome(int x, int z, int biomeID) {
        return EnhancedBiomesMod.getRockMetaForPos(biomeID, EnhancedBiomesMod.getStoneNoiseForCoords(x, z));
    }

    public static Block getDominantStone(int biomeID) {
        return rockList[biomeID];
    }

    public static byte getDominantStoneMeta(int biomeID) {
        return rockMetaList[biomeID];
    }

    public static Block getCobbleFromStone(Block stone) {
        return stone == EnhancedBiomesBlocks.stoneEB ? EnhancedBiomesBlocks.stoneCobbleEB : Blocks.field_150347_e;
    }

    static {
        rockList = new Block[BiomeGenBase.func_150565_n().length];
        rockMetaList = new byte[BiomeGenBase.func_150565_n().length];
        rockList2 = new Block[BiomeGenBase.func_150565_n().length];
        rockMetaList2 = new byte[BiomeGenBase.func_150565_n().length];
        soilList = new Block[BiomeGenBase.func_150565_n().length];
        soilMetaList = new byte[BiomeGenBase.func_150565_n().length];
        grassList = new Block[BiomeGenBase.func_150565_n().length];
        grassMetaList = new byte[BiomeGenBase.func_150565_n().length];
        woodList = new Block[BiomeGenBase.func_150565_n().length];
        woodMetaList = new byte[BiomeGenBase.func_150565_n().length];
        biomeTempsList = new float[BiomeGenBase.func_150565_n().length];
        isStoneVillageList = new boolean[BiomeGenBase.func_150565_n().length];
        stoneNoisePP = new ArrayList();
        stoneNoiseNP = new ArrayList();
        stoneNoisePN = new ArrayList();
        stoneNoiseNN = new ArrayList();
        runBiomeCheck = false;
    }
}

