/*
 * Decompiled with CFR 0.152.
 */
package enderglove.common.item;

import com.google.common.collect.Sets;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import enderglove.common.EnderGlove;
import enderglove.common.config.Config;
import enderglove.common.config.ConfigItems;
import enderglove.common.entity.EntityMinedBlock;
import enderglove.common.lib.InventoryHelper;
import enderglove.common.lib.LibInfo;
import enderglove.common.lib.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRedstoneOre;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityEnderPearl;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryEnderChest;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;

public class ItemEnderGlove
extends ItemTool {
    private static final Set<Block> blocksEffectiveAgainst = Sets.newHashSet((Object[])new Block[]{Blocks.field_150347_e, Blocks.field_150348_b});
    private int xCoord;
    private int yCoord;
    private int zCoord;

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister ir) {
        this.field_77791_bV = ir.func_94245_a(LibInfo.PREFIX + "enderglove");
    }

    public ItemEnderGlove() {
        super(1.0f, ItemEnderGlove.getToolLevel(), blocksEffectiveAgainst);
        this.func_77664_n();
        this.func_77637_a(CreativeTabs.field_78040_i);
        this.setNoRepair();
        if (Config.hasDurability) {
            this.func_77656_e(Config.durability);
        }
    }

    private static Item.ToolMaterial getToolLevel() {
        int crystalsLevel = EnchantmentHelper.func_77506_a((int)Config.enchCrystalsId, (ItemStack)new ItemStack(ConfigItems.itemEnderGlove));
        if (crystalsLevel > 0) {
            return Item.ToolMaterial.EMERALD;
        }
        return Item.ToolMaterial.IRON;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack is, EntityPlayer player, List list, boolean flag) {
        list.add(EnumChatFormatting.GREEN + "The power of the End");
        list.add(EnumChatFormatting.GREEN + "in your hands!");
    }

    public boolean func_77644_a(ItemStack is, EntityLivingBase target, EntityLivingBase attacker) {
        if (attacker instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)attacker;
            if (player.field_71075_bZ.field_75098_d && EnchantmentHelper.func_77506_a((int)Config.enchCreativeId, (ItemStack)is) > 0) {
                target.func_70091_d((double)this.xCoord, (double)this.yCoord, (double)this.zCoord);
                target.func_70107_b((double)this.xCoord, (double)this.yCoord, (double)this.zCoord);
                Utils.playSFX(player.field_70170_p, (int)target.field_70169_q, (int)target.field_70167_r, (int)target.field_70166_s, "mob.endermen.portal");
            }
        }
        return false;
    }

    public boolean func_150894_a(ItemStack is, World world, Block block, int x, int y, int z, EntityLivingBase entityLiving) {
        EntityPlayer player = (EntityPlayer)entityLiving;
        InventoryEnderChest enderInv = InventoryHelper.getPlayerEnderChest(player);
        int md = world.func_72805_g(x, y, z);
        if (world.field_72995_K) {
            world.func_72838_d((Entity)new EntityMinedBlock(world, (float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f, block, md));
        }
        int flameAmount = EnchantmentHelper.func_77506_a((int)Config.enchFlameTouchId, (ItemStack)is);
        ItemStack smeltableBlock = Utils.getDroppedItemStack(world, player, block, x, y, z, md);
        if (flameAmount > 0 && Utils.isSmeltable(smeltableBlock)) {
            ItemStack stack = FurnaceRecipes.func_77602_a().func_151395_a(smeltableBlock).func_77946_l();
            byte level = (byte)EnchantmentHelper.func_77506_a((int)Enchantment.field_77346_s.field_77352_x, (ItemStack)is);
            if (block.func_149732_F().contains("Ore")) {
                switch (level) {
                    case 1: {
                        stack.field_77994_a += world.field_73012_v.nextInt(2);
                        break;
                    }
                    case 2: {
                        ++stack.field_77994_a;
                        break;
                    }
                    case 3: {
                        stack.field_77994_a += 1 + world.field_73012_v.nextInt(7) / 6;
                    }
                }
            }
            if (!world.field_72995_K) {
                if (InventoryHelper.isInvEmpty((IInventory)enderInv, stack)) {
                    InventoryHelper.addItemStackToInventory((IInventory)InventoryHelper.getPlayerEnderChest(player), stack);
                    Utils.spawnBlockEntity(player, block, x, y, z, md, stack);
                } else {
                    Utils.spawnStackInWorld(world, x, y, z, stack);
                }
            }
            EnderGlove.proxy.blockFlameFX(world, x, y, z, 4);
            Utils.playSFX(world, x, y, z, "fire.ignite");
        } else if (EnchantmentHelper.func_77502_d((EntityLivingBase)player) && block.canSilkHarvest(world, player, x, y, z, md)) {
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            ItemStack stack = null;
            stack = block instanceof BlockRedstoneOre ? Utils.createStackedBlock() : Utils.createStackedBlock(block, md);
            if (stack != null) {
                items.add(stack);
            }
            for (ItemStack drops : items) {
                if (world.field_72995_K) continue;
                if (InventoryHelper.isInvEmpty((IInventory)enderInv, drops)) {
                    InventoryHelper.addItemStackToInventory((IInventory)enderInv, drops);
                    Utils.spawnBlockEntity(player, block, x, y, z, md, drops);
                    continue;
                }
                Utils.spawnStackInWorld(world, x, y, z, drops);
            }
            EnderGlove.proxy.blockSparkleFX(world, x, y, z, 4);
            Utils.playSFX(world, x, y, z, "mob.endermen.portal");
        } else {
            ArrayList items = block.getDrops(world, x, y, z, md, EnchantmentHelper.func_77517_e((EntityLivingBase)player));
            for (ItemStack drops : items) {
                if (world.field_72995_K) continue;
                if (InventoryHelper.isInvEmpty((IInventory)enderInv, drops)) {
                    InventoryHelper.addItemStackToInventory((IInventory)enderInv, drops);
                    Utils.spawnBlockEntity(player, block, x, y, z, md, drops);
                    continue;
                }
                Utils.spawnStackInWorld(world, x, y, z, drops);
            }
            EnderGlove.proxy.blockSparkleFX(world, x, y, z, 4);
            Utils.playSFX(world, x, y, z, "mob.endermen.portal");
        }
        return super.func_150894_a(is, world, block, x, y, z, entityLiving);
    }

    public int func_77619_b() {
        return this.field_77862_b.func_77995_e();
    }

    public int getHarvestLevel(ItemStack is, String toolClass) {
        return Items.field_151035_b.getHarvestLevel(is, toolClass);
    }

    public float getDigSpeed(ItemStack is, Block block, int md) {
        return 1.3f;
    }

    public EnumRarity func_77613_e(ItemStack is) {
        return EnumRarity.epic;
    }

    public boolean onBlockStartBreak(ItemStack is, int x, int y, int z, EntityPlayer player) {
        return super.onBlockStartBreak(is, x, y, z, player);
    }

    public boolean onDroppedByPlayer(ItemStack item, EntityPlayer player) {
        return true;
    }

    public ItemStack func_77659_a(ItemStack is, World world, EntityPlayer player) {
        int teleAmount = EnchantmentHelper.func_77506_a((int)Config.enchTeleportId, (ItemStack)is);
        if (teleAmount > 0) {
            world.func_72956_a((Entity)player, "random.bow", 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
            is.func_77972_a(1, (EntityLivingBase)player);
            if (!world.field_72995_K) {
                world.func_72838_d((Entity)new EntityEnderPearl(world, (EntityLivingBase)player));
            }
        }
        return is;
    }

    public boolean func_77648_a(ItemStack is, EntityPlayer player, World world, int x, int y, int z, int md, float hitX, float hitY, float hitZ) {
        int creativeAmount = EnchantmentHelper.func_77506_a((int)Config.enchCreativeId, (ItemStack)is);
        if (creativeAmount > 0 && player.func_70093_af() && player.field_71075_bZ.field_75098_d) {
            this.xCoord = x;
            this.yCoord = y;
            this.zCoord = z;
            Utils.sendMessage(player, "Position set to: [" + this.xCoord + ", " + this.yCoord + ", " + this.zCoord + "]");
            Utils.playSFX(world, x, y, z, "random.orb");
            return true;
        }
        return super.func_77648_a(is, player, world, x, y, z, md, hitX, hitY, hitZ);
    }
}

