/*
 * Decompiled with CFR 0.152.
 */
package enderglove.common.lib;

import enderglove.common.entity.EntityMinedBlock;
import enderglove.common.item.ItemEnderGlove;
import enderglove.common.lib.InventoryHelper;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryEnderChest;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class Utils {
    public static void sendMessage(EntityPlayer player, String msg) {
        ChatComponentText chat = new ChatComponentText(msg);
        if (!player.field_70170_p.field_72995_K) {
            player.func_145747_a((IChatComponent)chat);
        }
    }

    public static ItemStack getDroppedItemStack(World world, EntityPlayer player, Block block, int x, int y, int z, int md) {
        ArrayList items = block.getDrops(world, x, y, z, md, EnchantmentHelper.func_77517_e((EntityLivingBase)player));
        ItemStack drops = null;
        if (items != null && items.size() > 0) {
            for (int size = 0; size < items.size(); ++size) {
                drops = (ItemStack)items.get(size);
            }
        }
        return drops;
    }

    public static boolean isSmeltable(ItemStack is) {
        return is != null && FurnaceRecipes.func_77602_a().func_151395_a(is) != null;
    }

    public static void playSFX(World world, int x, int y, int z, String sound) {
        world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, sound, 1.0f, world.field_73012_v.nextFloat() * 0.4f + 0.8f);
    }

    public static boolean isCarryingGlove(EntityPlayer player) {
        return player != null && player.field_71071_by.func_70448_g() != null && player.field_71071_by.func_70448_g().func_77973_b() instanceof ItemEnderGlove;
    }

    public static ItemStack createStackedBlock(Block block, int metadata) {
        int md = 0;
        Item item = Item.func_150898_a((Block)block);
        if (item != null && item.func_77614_k()) {
            md = metadata;
        }
        return new ItemStack(item, 1, md);
    }

    public static ItemStack createStackedBlock() {
        return new ItemStack(Blocks.field_150450_ax);
    }

    private boolean handleTileEntities() {
        return false;
    }

    public static int getRotationMeta(EntityLivingBase entLiving) {
        int md = 0;
        int rot = MathHelper.func_76128_c((double)((double)(entLiving.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        switch (rot) {
            case 0: {
                md = 2;
            }
            case 1: {
                md = 5;
            }
            case 2: {
                md = 3;
            }
            case 3: {
                md = 4;
            }
        }
        return md;
    }

    public static void spawnStackInWorld(World world, int x, int y, int z, ItemStack stack) {
        world.func_147468_f(x, y, z);
        world.func_72838_d((Entity)new EntityItem(world, (double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), stack.func_77946_l()));
    }

    @Deprecated
    public static void spawnBlockEntity(EntityPlayer player, Block block, int x, int y, int z, int md, ItemStack drops) {
        InventoryEnderChest enderInv = InventoryHelper.getPlayerEnderChest(player);
        if (player.field_70170_p.field_72995_K && InventoryHelper.isInvEmpty((IInventory)enderInv, drops)) {
            player.field_70170_p.func_72838_d((Entity)new EntityMinedBlock(player.field_70170_p, (float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f, block, md));
        }
    }
}

