/*
 * Decompiled with CFR 0.152.
 */
package enderglove.common.lib;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryEnderChest;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class InventoryHelper {
    public static InventoryEnderChest getPlayerEnderChest(EntityPlayer p) {
        return p.func_71005_bN();
    }

    public static boolean addItemStackToInventory(IInventory inv, ItemStack is) {
        if (!is.func_77951_h()) {
            int stackSize;
            do {
                stackSize = is.field_77994_a;
                is.field_77994_a = InventoryHelper.storePartially(inv, is);
            } while (is.field_77994_a > 0 && is.field_77994_a < stackSize);
            return is.field_77994_a < stackSize;
        }
        int slot = InventoryHelper.getFirstEmptySlot(inv, is);
        if (slot >= 0) {
            inv.func_70299_a(slot, ItemStack.func_77944_b((ItemStack)is));
            is.field_77994_a = 0;
            return true;
        }
        return false;
    }

    public static int storePartially(IInventory inv, ItemStack is) {
        int canStore;
        Item item = is.func_77973_b();
        int size = is.field_77994_a;
        if (is.func_77976_d() == 1) {
            int freeSlot = InventoryHelper.getFirstEmptySlot(inv, is);
            if (freeSlot < 0) {
                return size;
            }
            if (inv.func_70301_a(freeSlot) == null) {
                inv.func_70299_a(freeSlot, ItemStack.func_77944_b((ItemStack)is));
            }
            return 0;
        }
        int freeSlot = InventoryHelper.getNonFilledStack(inv, is);
        if (freeSlot < 0) {
            freeSlot = InventoryHelper.getFirstEmptySlot(inv, is);
        }
        if (freeSlot < 0) {
            return size;
        }
        if (inv.func_70301_a(freeSlot) == null) {
            inv.func_70299_a(freeSlot, new ItemStack(item, 0, is.func_77960_j()));
        }
        if ((canStore = size) > inv.func_70301_a(freeSlot).func_77976_d() - inv.func_70301_a((int)freeSlot).field_77994_a) {
            canStore = inv.func_70301_a(freeSlot).func_77976_d() - inv.func_70301_a((int)freeSlot).field_77994_a;
        }
        if (canStore > inv.func_70297_j_() - inv.func_70301_a((int)freeSlot).field_77994_a) {
            canStore = inv.func_70297_j_() - inv.func_70301_a((int)freeSlot).field_77994_a;
        }
        if (canStore == 0) {
            return size;
        }
        inv.func_70301_a((int)freeSlot).field_77994_a += canStore;
        return size -= canStore;
    }

    public static int getNonFilledStack(IInventory inv, ItemStack is) {
        for (int slot = 0; slot < inv.func_70302_i_(); ++slot) {
            ItemStack stackInSlot = inv.func_70301_a(slot);
            if (stackInSlot == null || stackInSlot.func_77973_b() != is.func_77973_b() || !stackInSlot.func_77985_e() || stackInSlot.field_77994_a >= stackInSlot.func_77976_d() || stackInSlot.field_77994_a >= inv.func_70297_j_() || stackInSlot.func_77981_g() && stackInSlot.func_77960_j() != is.func_77960_j()) continue;
            return slot;
        }
        return -1;
    }

    public static int getFirstEmptySlot(IInventory inv, ItemStack is) {
        for (int slot = 0; slot < inv.func_70302_i_(); ++slot) {
            if (inv.func_70301_a(slot) != null) continue;
            return slot;
        }
        return -1;
    }

    public static boolean isInPlayerInventory(EntityPlayer player, Item item) {
        for (int slot = 0; slot < player.field_71071_by.field_70462_a.length; ++slot) {
            if (player.field_71071_by.field_70462_a[slot] == null || player.field_71071_by.field_70462_a[slot].func_77973_b() != item) continue;
            return true;
        }
        return false;
    }

    public static boolean isInEnderInventory(EntityPlayer player, Item item) {
        InventoryEnderChest enderInv = InventoryHelper.getPlayerEnderChest(player);
        for (int slot = 0; slot < enderInv.func_70302_i_(); ++slot) {
            if (enderInv.func_70301_a(slot) == null || enderInv.func_70301_a(slot).func_77973_b() != item) continue;
            return true;
        }
        return false;
    }

    public static int getEnderSlotForItem(EntityPlayer player, Item item) {
        InventoryEnderChest enderInv = InventoryHelper.getPlayerEnderChest(player);
        for (int slot = 0; slot < enderInv.func_70302_i_(); ++slot) {
            if (enderInv.func_70301_a(slot) == null || enderInv.func_70301_a(slot).func_77973_b() != item) continue;
            return slot;
        }
        return -1;
    }

    public static int getPlayerSlotForItem(EntityPlayer player, Item item) {
        for (int slot = 0; slot < player.field_71071_by.field_70462_a.length; ++slot) {
            if (player.field_71071_by.field_70462_a[slot] == null || player.field_71071_by.field_70462_a[slot].func_77973_b() != item) continue;
            return slot;
        }
        return -1;
    }

    public static boolean consumeEnderInventoryItem(EntityPlayer player, Item item) {
        InventoryEnderChest enderInv = InventoryHelper.getPlayerEnderChest(player);
        int slot = InventoryHelper.getEnderSlotForItem(player, item);
        if (slot < 0) {
            return false;
        }
        if (--enderInv.func_70301_a((int)slot).field_77994_a <= 0) {
            enderInv.func_70301_a((int)slot).field_77994_a = 0;
        }
        return true;
    }

    public static boolean isInvEmpty(IInventory inv, ItemStack is) {
        return InventoryHelper.addItemStackToInventory(inv, is);
    }
}

