/*
 * Decompiled with CFR 0.152.
 */
package enderglove.common.lib;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import enderglove.common.config.Config;
import enderglove.common.config.ConfigItems;
import enderglove.common.item.ItemEnderGlove;
import enderglove.common.lib.InventoryHelper;
import enderglove.common.lib.Utils;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;
import net.minecraftforge.event.world.BlockEvent;

public class EventHandlerWorld {
    @SubscribeEvent
    public void harvestDrops(BlockEvent.HarvestDropsEvent event) {
        EntityPlayer player = event.harvester;
        if (event.drops != null && event.drops.size() > 0 && Utils.isCarryingGlove(player)) {
            event.drops.clear();
        }
    }

    @SubscribeEvent
    public void onEnderDragonKilled(LivingDropsEvent event) {
        if (event.entityLiving instanceof EntityDragon && Config.dragonDrop) {
            event.entityLiving.func_145779_a(ConfigItems.itemEnderGlove, 1);
        }
    }

    @SubscribeEvent
    public void blockBreak(BlockEvent.BreakEvent event) {
        EntityPlayer player = event.getPlayer();
        int affAmount = EnchantmentHelper.func_77506_a((int)Config.enchAffluencyId, (ItemStack)player.field_71071_by.func_70448_g());
        if (event.getExpToDrop() > 0) {
            int XP = event.getExpToDrop();
            int affXP = XP + affAmount * affAmount / 2;
            event.setExpToDrop(affXP);
        }
    }

    @SideOnly(value=Side.SERVER)
    @SubscribeEvent
    public void enderTeleport(EnderTeleportEvent event) {
        if (!event.entityLiving.field_70170_p.field_72995_K && event.entityLiving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entityLiving;
            int teleAmount = EnchantmentHelper.func_77506_a((int)Config.enchTeleportId, (ItemStack)player.field_71071_by.func_70448_g());
            if (Utils.isCarryingGlove(player) && teleAmount > 0 && !event.entityLiving.field_70170_p.field_72995_K) {
                event.attackDamage = 10.0f;
            }
        }
    }

    @SubscribeEvent
    public void playerDrops(PlayerDropsEvent event) {
        for (EntityItem entItem : event.drops) {
            ItemStack is = entItem.func_92059_d();
            if (is == null || !(is.func_77973_b() instanceof ItemEnderGlove)) continue;
            is.func_77972_a(2, (EntityLivingBase)event.entityPlayer);
            InventoryHelper.addItemStackToInventory((IInventory)InventoryHelper.getPlayerEnderChest(event.entityPlayer), is);
            Utils.sendMessage(event.entityPlayer, EnumChatFormatting.DARK_PURPLE + is.func_82833_r() + " was succesfully saved to your Ender Chest!");
            Utils.playSFX(event.entityPlayer.field_70170_p, (int)entItem.field_70169_q, (int)entItem.field_70167_r, (int)entItem.field_70166_s, "mob.endermen.portal");
            entItem.func_70106_y();
        }
    }

    public void livingUpdate(LivingEvent.LivingUpdateEvent event) {
    }
}

