/*
 * Decompiled with CFR 0.152.
 */
package enderglove.common.config;

import enderglove.common.lib.enchantment.EnchantmentAffluency;
import enderglove.common.lib.enchantment.EnchantmentArtisan;
import enderglove.common.lib.enchantment.EnchantmentCreative;
import enderglove.common.lib.enchantment.EnchantmentCrystals;
import enderglove.common.lib.enchantment.EnchantmentFlameTouch;
import enderglove.common.lib.enchantment.EnchantmentMagnetism;
import enderglove.common.lib.enchantment.EnchantmentSpelunker;
import enderglove.common.lib.enchantment.EnchantmentTeleport;
import java.io.File;
import net.minecraft.enchantment.Enchantment;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class Config {
    public static Configuration config;
    public static final String CATEGORY_ENCH = "Enchantments";
    public static final String CATEGORY_ENTITIES = "Entities";
    public static int totemsPerChunk;
    public static int artisanBonusChance;
    public static boolean loadCustomSounds;
    public static Enchantment enchAffluency;
    public static Enchantment enchArtisan;
    public static Enchantment enchSpelunker;
    public static Enchantment enchTeleport;
    public static Enchantment enchCreative;
    public static Enchantment enchFlameTouch;
    public static Enchantment enchEnderField;
    public static Enchantment enchMagnetism;
    public static Enchantment enchCrystals;
    public static int enchAffluencyId;
    public static int enchArtisanId;
    public static int enchSpelunkerId;
    public static int enchTeleportId;
    public static int enchCreativeId;
    public static int enchFlameTouchId;
    public static int enchEFieldId;
    public static int enchMagnetismId;
    public static int enchCrystalsId;
    public static int entMinedBlockId;
    public static String line1;
    public static String line2;
    public static String line3;
    public static boolean dragonDrop;
    public static boolean totemGen;
    public static boolean hasDurability;
    public static boolean chestGen;
    public static int durability;

    public static void initialize(File file) {
        config = new Configuration(file);
        config.load();
        config.addCustomCategoryComment(CATEGORY_ENCH, "Custom enchantments");
        config.addCustomCategoryComment(CATEGORY_ENTITIES, "Entity IDs");
        Property tpc = config.get("general", "totems_per_chunk", totemsPerChunk);
        tpc.comment = "The rarity of the Ender Totems. Setting it to 0 will remove Ender Totem generation.";
        totemsPerChunk = tpc.getInt();
        Property atc = config.get("general", "artisan_bonus_chance", artisanBonusChance);
        atc.comment = "The chance of getting a returned ingredient. Increase for more rarity.";
        artisanBonusChance = atc.getInt();
        dragonDrop = config.get("general", "EnderGlove will drop from Dragon", true).getBoolean(true);
        totemGen = config.get("general", "Ender Totem Generation (Kinda Buggy Right Now)", false).getBoolean(false);
        hasDurability = config.get("general", "Ender Glove Has Durability", true).getBoolean(true);
        chestGen = config.get("general", "Ender Glove generates in Stronghold chests", true).getBoolean(true);
        durability = config.get("general", "Ender Glove Durability Value", 350).getInt();
        int enchIndex = 63;
        Property enchAff = config.get(CATEGORY_ENCH, "ench_affluency", enchIndex++);
        enchAffluency = new EnchantmentAffluency(enchAff.getInt(), 3);
        enchAffluencyId = enchAff.getInt();
        Enchantment.addToBookList((Enchantment)enchAffluency);
        Property enchArt = config.get(CATEGORY_ENCH, "ench_artisan", enchIndex++);
        enchArtisan = new EnchantmentArtisan(enchArt.getInt(), 2);
        enchArtisanId = enchArt.getInt();
        Enchantment.addToBookList((Enchantment)enchArtisan);
        Property enchSpe = config.get(CATEGORY_ENCH, "ench_spelunker", enchIndex++);
        enchSpelunker = new EnchantmentSpelunker(enchSpe.getInt(), 2);
        enchSpelunkerId = enchSpe.getInt();
        Enchantment.addToBookList((Enchantment)enchSpelunker);
        Property enchTel = config.get(CATEGORY_ENCH, "ench_teleport", enchIndex++);
        enchTeleport = new EnchantmentTeleport(enchTel.getInt(), 4);
        enchTeleportId = enchTel.getInt();
        Enchantment.addToBookList((Enchantment)enchTeleport);
        Property enchOP = config.get(CATEGORY_ENCH, "ench_creative", enchIndex++);
        enchCreative = new EnchantmentCreative(enchOP.getInt(), 0);
        enchCreativeId = enchOP.getInt();
        Enchantment.addToBookList((Enchantment)enchCreative);
        Property enchFla = config.get(CATEGORY_ENCH, "ench_flametouch", enchIndex++);
        enchFlameTouch = new EnchantmentFlameTouch(enchFla.getInt(), 3);
        enchFlameTouchId = enchFla.getInt();
        Enchantment.addToBookList((Enchantment)enchFlameTouch);
        Property enchMagnet = config.get(CATEGORY_ENCH, "ench_magnetism", enchIndex++);
        enchMagnetism = new EnchantmentMagnetism(enchMagnet.getInt(), 2);
        enchMagnetismId = enchMagnet.getInt();
        Enchantment.addToBookList((Enchantment)enchMagnetism);
        Property enchCrystal = config.get(CATEGORY_ENCH, "ench_crystals", enchIndex++);
        enchCrystals = new EnchantmentCrystals(enchCrystal.getInt(), 2);
        enchCrystalsId = enchCrystal.getInt();
        Enchantment.addToBookList((Enchantment)enchCrystals);
        int eIdx = 201;
        entMinedBlockId = config.get(CATEGORY_ENTITIES, "minedblock", eIdx++).getInt();
        config.save();
    }

    public static void save() {
        config.save();
    }

    static {
        totemsPerChunk = 2;
        artisanBonusChance = 3;
        loadCustomSounds = false;
        enchAffluency = null;
        enchArtisan = null;
        enchSpelunker = null;
        enchTeleport = null;
        enchCreative = null;
        enchFlameTouch = null;
        enchEnderField = null;
        enchMagnetism = null;
        enchCrystals = null;
    }
}

