/*
 * Decompiled with CFR 0.152.
 */
package com.aesireanempire.eplus.handlers;

import com.aesireanempire.eplus.EnchantingPlus;
import cpw.mods.fml.common.registry.LanguageRegistry;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;

public class LanguageHandler {
    private static LanguageHandler INSTANCE = new LanguageHandler();
    private final List<String> languages = new ArrayList<String>();
    private final String location = "/assets/eplus/lang/";

    private LanguageHandler() {
    }

    public static LanguageHandler getInstance() {
        return INSTANCE;
    }

    public void addLanguage(String uri) {
        if (!this.languages.contains(uri)) {
            this.languages.add(uri);
        }
    }

    public void addLanguages(String langs) {
        InputStream resourceAsStream = this.getClass().getResourceAsStream(langs);
        Scanner scanner = new Scanner(resourceAsStream);
        while (scanner.hasNextLine()) {
            this.addLanguage("/assets/eplus/lang/" + scanner.nextLine());
        }
        scanner.close();
    }

    public List<String> getLanguages() {
        return this.languages;
    }

    private String getLocalFromFileName(String lang) {
        return lang.substring(lang.lastIndexOf("/") + 1, lang.lastIndexOf("."));
    }

    public String getTranslatedString(String string) {
        return LanguageRegistry.instance().getStringLocalization(string).isEmpty() ? LanguageRegistry.instance().getStringLocalization(string, "en_US") : LanguageRegistry.instance().getStringLocalization(string);
    }

    private boolean isXMLlangfile(String lang) {
        return lang.endsWith(".xml");
    }

    public void loadLangauges() {
        for (String lang : this.languages) {
            LanguageRegistry.instance().loadLocalization(lang, this.getLocalFromFileName(lang), this.isXMLlangfile(lang));
            EnchantingPlus.log.info("Localization " + this.getLocalFromFileName(lang) + " loaded");
        }
    }
}

