/*
 * Decompiled with CFR 0.152.
 */
package mod.elementalguns.entity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class EntityBullet
extends Entity {
    public int age;
    public int maxAge = 50;
    public float scale;
    public float gravity;
    public int textureIndex = 0;
    protected boolean inLava = false;
    protected EntityLivingBase thrower;
    private String throwerName;
    private int ticksInGround;
    private int ticksInAir;
    public IIcon particleIcon;

    public EntityBullet(World par1World) {
        super(par1World);
        this.func_70105_a(0.25f, 0.25f);
        this.setScale(0.5f);
    }

    public EntityBullet(World par1World, EntityLivingBase par2EntityLivingBase) {
        super(par1World);
        this.thrower = par2EntityLivingBase;
        if (par2EntityLivingBase instanceof EntityPlayer) {
            this.throwerName = ((EntityPlayer)par2EntityLivingBase).getDisplayName();
        }
        this.func_70105_a(0.25f, 0.25f);
        this.setScale(0.5f);
        this.setPosition(par2EntityLivingBase, 0.36f, 0.2f);
        float f = 0.4f;
        this.field_70159_w = -MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI)) * f;
        this.field_70179_y = MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI)) * f;
        this.field_70181_x = -MathHelper.func_76126_a((float)(this.field_70125_A / 180.0f * (float)Math.PI)) * f;
        this.setThrowableHeading(this.field_70159_w, this.field_70181_x, this.field_70179_y, this.getDistance(), 1.0f);
    }

    public EntityBullet(World par1World, double par2, double par4, double par6) {
        super(par1World);
        this.ticksInGround = 0;
        this.func_70105_a(0.25f, 0.25f);
        this.func_70107_b(par2, par4, par6);
        this.field_70129_M = 0.0f;
    }

    public void setPosition(EntityLivingBase entityLiving, float sideOfffset, float heightOffset) {
        this.func_70012_b(entityLiving.field_70165_t, entityLiving.field_70163_u + (double)entityLiving.func_70047_e(), entityLiving.field_70161_v, entityLiving.field_70177_z, entityLiving.field_70125_A);
        this.field_70165_t -= (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * sideOfffset);
        this.field_70165_t -= (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * (-this.field_70125_A * (heightOffset * 0.01f)));
        this.field_70163_u -= (double)heightOffset;
        this.field_70163_u -= (double)(-MathHelper.func_76126_a((float)(this.field_70125_A / 180.0f * (float)Math.PI))) * (double)heightOffset;
        this.field_70161_v -= (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * sideOfffset);
        this.field_70161_v -= (double)(-MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * (-this.field_70125_A * (heightOffset * 0.01f)));
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.field_70129_M = 0.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public int getTicksBeforeVisible() {
        return 0;
    }

    public void setThrowableHeading(double par1, double par3, double par5, float par7, float par8) {
        float f2 = MathHelper.func_76133_a((double)(par1 * par1 + par3 * par3 + par5 * par5));
        par1 /= (double)f2;
        par3 /= (double)f2;
        par5 /= (double)f2;
        par1 += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)par8;
        par3 += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)par8;
        par5 += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)par8;
        this.field_70159_w = par1 *= (double)par7;
        this.field_70181_x = par3 *= (double)par7;
        this.field_70179_y = par5 *= (double)par7;
        float f3 = MathHelper.func_76133_a((double)(par1 * par1 + par5 * par5));
        this.field_70126_B = this.field_70177_z = (float)(Math.atan2(par1, par5) * 180.0 / Math.PI);
        this.field_70127_C = this.field_70125_A = (float)(Math.atan2(par3, f3) * 180.0 / Math.PI);
        this.ticksInGround = 0;
    }

    public void setOffset(float offset) {
        this.setThrowableHeading(this.field_70159_w, this.field_70181_x, this.field_70179_y, this.getDistance(), offset);
    }

    public EntityBullet multiplyVelocity(float velocity) {
        this.field_70159_w *= (double)velocity;
        this.field_70181_x *= (double)velocity;
        this.field_70179_y *= (double)velocity;
        return this;
    }

    public EntityBullet setGravity(float par1) {
        this.gravity = par1;
        return this;
    }

    public EntityBullet multiplyScaleBy(float multiply) {
        this.func_70105_a(0.2f * multiply, 0.2f * multiply);
        this.scale *= multiply;
        return this;
    }

    protected void setScale(float scale) {
        this.scale = scale;
    }

    public void setMaxAge(int age) {
        this.maxAge = age;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    protected void func_70088_a() {
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K && (this != null && this.field_70128_L || !this.field_70170_p.func_72899_e((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v))) {
            this.func_70106_y();
        }
        if (this.age++ >= this.maxAge) {
            this.func_70106_y();
        }
        this.field_70142_S = this.field_70165_t;
        this.field_70137_T = this.field_70163_u;
        this.field_70136_U = this.field_70161_v;
        super.func_70071_h_();
        ++this.ticksInAir;
        Vec3 vec3 = this.field_70170_p.func_82732_R().func_72345_a(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        Vec3 vec31 = this.field_70170_p.func_82732_R().func_72345_a(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        MovingObjectPosition movingobjectposition = this.field_70170_p.func_72933_a(vec3, vec31);
        vec3 = this.field_70170_p.func_82732_R().func_72345_a(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        vec31 = this.field_70170_p.func_82732_R().func_72345_a(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        if (movingobjectposition != null) {
            vec31 = this.field_70170_p.func_82732_R().func_72345_a(movingobjectposition.field_72307_f.field_72450_a, movingobjectposition.field_72307_f.field_72448_b, movingobjectposition.field_72307_f.field_72449_c);
        }
        if (!this.field_70170_p.field_72995_K) {
            Entity entity = null;
            List list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72314_b(1.0, 1.0, 1.0));
            double d0 = 0.0;
            EntityLivingBase entitylivingbase = this.getThrower();
            for (int j = 0; j < list.size(); ++j) {
                double d1;
                float f;
                AxisAlignedBB axisalignedbb;
                MovingObjectPosition movingobjectposition1;
                Entity entity1 = (Entity)list.get(j);
                if ((!entity1.func_70067_L() || entity1 == this.thrower && this.ticksInAir < 15) && !(entity1 instanceof EntityItem) || (movingobjectposition1 = (axisalignedbb = entity1.field_70121_D.func_72314_b((double)(f = 0.3f), (double)f, (double)f)).func_72327_a(vec3, vec31)) == null || !((d1 = vec3.func_72438_d(movingobjectposition1.field_72307_f)) < d0) && d0 != 0.0) continue;
                entity = entity1;
                d0 = d1;
            }
            if (entity != null) {
                movingobjectposition = new MovingObjectPosition(entity);
            }
        }
        this.inLava = this.func_70058_J();
        if (!this.field_70171_ac) {
            this.field_70171_ac = this.func_70055_a(Material.field_151586_h);
        }
        if (!this.inLava) {
            this.inLava = this.func_70055_a(Material.field_151587_i);
        }
        if (this.isInLiquid()) {
            int x = MathHelper.func_76128_c((double)this.field_70165_t);
            int y = MathHelper.func_76128_c((double)this.field_70163_u);
            int z = MathHelper.func_76128_c((double)this.field_70161_v);
            MovingObjectPosition liquidMovingObjectPosition = new MovingObjectPosition(x, y, z, 0, this.field_70170_p.func_82732_R().func_72345_a(this.field_70165_t, this.field_70163_u, this.field_70161_v), false);
            if (this.func_70090_H()) {
                for (int k = 0; k < 4; ++k) {
                    float f4 = 0.25f;
                    this.field_70170_p.func_72869_a("bubble", this.field_70165_t - this.field_70159_w * (double)f4, this.field_70163_u - this.field_70181_x * (double)f4, this.field_70161_v - this.field_70179_y * (double)f4, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                }
                this.onWaterImpact(liquidMovingObjectPosition);
            }
            if (this.isInLava()) {
                for (int k = 0; k < 4; ++k) {
                    float f4 = 0.25f;
                    this.field_70170_p.func_72869_a("smoke", this.field_70165_t - this.field_70159_w * (double)f4, this.field_70163_u - this.field_70181_x * (double)f4, this.field_70161_v - this.field_70179_y * (double)f4, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                }
                this.onLavaImpact(liquidMovingObjectPosition);
            }
        }
        if (movingobjectposition != null) {
            if (movingobjectposition.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && this.field_70170_p.func_147439_a(movingobjectposition.field_72311_b, movingobjectposition.field_72312_c, movingobjectposition.field_72309_d) == Blocks.field_150427_aO) {
                this.func_70063_aa();
            } else {
                this.onImpact(movingobjectposition);
            }
        }
        this.field_70165_t += this.field_70159_w;
        this.field_70163_u += this.field_70181_x;
        this.field_70161_v += this.field_70179_y;
        float f1 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
        this.field_70125_A = (float)(Math.atan2(this.field_70181_x, f1) * 180.0 / Math.PI);
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
        this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
        float velocityDecrease = 0.99f;
        float garityDecrease = this.getGravityVelocity();
        if (this.isInLiquid()) {
            velocityDecrease = 0.8f;
        }
        this.field_70159_w *= (double)velocityDecrease;
        this.field_70181_x *= (double)velocityDecrease;
        this.field_70179_y *= (double)velocityDecrease;
        this.field_70181_x -= (double)garityDecrease;
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_90999_ad() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasBrightness() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public int getBrightness() {
        return 0;
    }

    public void func_70014_b(NBTTagCompound nbtTagCompound) {
        nbtTagCompound.func_74768_a("Age", this.age);
    }

    public void func_70037_a(NBTTagCompound nbtTagCompound) {
        this.age = nbtTagCompound.func_74762_e("Age");
    }

    public boolean func_70075_an() {
        return false;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + ", Pos (" + this.field_70165_t + "," + this.field_70163_u + "," + this.field_70161_v + "), Age " + this.age;
    }

    protected float getGravityVelocity() {
        return 0.03f;
    }

    protected float getDistance() {
        return 1.5f;
    }

    protected void onImpact(MovingObjectPosition movingObjectPosition) {
    }

    protected void onWaterImpact(MovingObjectPosition movingObjectPosition) {
    }

    protected void onLavaImpact(MovingObjectPosition movingObjectPosition) {
    }

    public boolean isInLava() {
        return this.inLava;
    }

    public boolean isInLiquid() {
        return this.field_70171_ac || this.inLava;
    }

    public EntityLivingBase getThrower() {
        if (this.thrower == null && this.throwerName != null && this.throwerName.length() > 0) {
            this.thrower = this.field_70170_p.func_72924_a(this.throwerName);
        }
        return this.thrower;
    }

    public ResourceLocation getTexture() {
        return null;
    }

    public int getTextureIndex() {
        return this.textureIndex;
    }

    public int getTextureWidth() {
        return 8;
    }

    public int getAmountOfTextures() {
        return 1;
    }
}

