/*
 * Decompiled with CFR 0.152.
 */
package net.lomeli.ec.core;

import cpw.mods.fml.common.registry.EntityRegistry;
import java.awt.Color;
import net.lomeli.ec.entity.EntityCookieCreeper;
import net.lomeli.ec.entity.EntityDarkCreeper;
import net.lomeli.ec.entity.EntityEarthCreeper;
import net.lomeli.ec.entity.EntityElectricCreeper;
import net.lomeli.ec.entity.EntityFakeIllusionCreeper;
import net.lomeli.ec.entity.EntityFireCreeper;
import net.lomeli.ec.entity.EntityGhostCreeper;
import net.lomeli.ec.entity.EntityIceCreeper;
import net.lomeli.ec.entity.EntityIllusionCreeper;
import net.lomeli.ec.entity.EntityLightCreeper;
import net.lomeli.ec.entity.EntityMagmaCreeper;
import net.lomeli.ec.entity.EntityReverseCreeper;
import net.lomeli.ec.entity.EntityWaterCreeper;
import net.lomeli.ec.entity.EntityWindCreeper;
import net.lomeli.ec.lib.ECVars;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityEggInfo;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;

public class EntityRegistering {
    private static BiomeDictionary.Type[] typeList = new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.WASTELAND, BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.BEACH, BiomeDictionary.Type.DESERT, BiomeDictionary.Type.FROZEN, BiomeDictionary.Type.MOUNTAIN};

    public static void loadEntities() {
        EntityRegistering.registerEntity(EntityFireCreeper.class, EntityRegistering.getCreeperName("FireCreeper"), ECVars.fireCreeperID, new Color(894731).getRGB(), new Color(227, 111, 24).getRGB());
        EntityRegistering.registerEntity(EntityWaterCreeper.class, EntityRegistering.getCreeperName("WaterCreeper"), ECVars.waterCreeperID, new Color(894731).getRGB(), new Color(59, 115, 205).getRGB());
        EntityRegistering.registerEntity(EntityElectricCreeper.class, EntityRegistering.getCreeperName("ElectricCreeper"), ECVars.electricCreeperID, new Color(894731).getRGB(), new Color(251, 234, 57).getRGB());
        EntityRegistering.registerEntity(EntityCookieCreeper.class, EntityRegistering.getCreeperName("CookieCreeper"), ECVars.cookieCreeperID, new Color(894731).getRGB(), new Color(202, 147, 98).getRGB());
        EntityRegistering.registerEntity(EntityDarkCreeper.class, EntityRegistering.getCreeperName("DarkCreeper"), ECVars.darkCreeperID, new Color(894731).getRGB(), new Color(50, 50, 50).getRGB());
        EntityRegistering.registerEntity(EntityLightCreeper.class, EntityRegistering.getCreeperName("LightCreeper"), ECVars.lightCreeperID, new Color(894731).getRGB(), new Color(255, 244, 125).getRGB());
        EntityRegistering.registerEntity(EntityEarthCreeper.class, EntityRegistering.getCreeperName("EarthCreeper"), ECVars.earthCreeperID, new Color(894731).getRGB(), new Color(93, 50, 0).getRGB());
        EntityRegistering.registerEntity(EntityMagmaCreeper.class, EntityRegistering.getCreeperName("MagmaCreeper"), ECVars.magmaCreeperID, new Color(894731).getRGB(), new Color(165, 0, 16).getRGB());
        EntityRegistering.registerEntity(EntityReverseCreeper.class, EntityRegistering.getCreeperName("ReverseCreeper"), ECVars.reverseCreeperID, Color.black.getRGB(), new Color(894731).getRGB());
        EntityRegistering.registerEntity(EntityIceCreeper.class, EntityRegistering.getCreeperName("IceCreeper"), ECVars.iceCreeperID, new Color(894731).getRGB(), Color.white.getRGB());
        EntityRegistering.registerEntity(EntityGhostCreeper.class, EntityRegistering.getCreeperName("GhostCreeper"), ECVars.ghostCreeperID, 99999, 99999);
        EntityRegistering.registerEntity(EntityFakeIllusionCreeper.class, EntityRegistering.getCreeperName("IllusionCreeper"), ECVars.fakeIllusionCreeperID, 99999, 99999);
        EntityRegistering.registerEntity(EntityIllusionCreeper.class, EntityRegistering.getCreeperName("IllusionCreeper"), ECVars.illusionCreeperID, new Color(894731).getRGB(), new Color(158, 158, 158).getRGB());
        EntityRegistering.registerEntity(EntityWindCreeper.class, EntityRegistering.getCreeperName("WindCreeper"), ECVars.windCreeperID, new Color(894731).getRGB(), new Color(95, 250, 203).getRGB());
        EntityRegistering.loadSpawn();
    }

    private static void loadSpawn() {
        EntityRegistering.addOverWorldSpawn(EntityFireCreeper.class, ECVars.fireCreeperSpawn, 1, 3);
        EntityRegistering.addOverWorldSpawn(EntityWaterCreeper.class, ECVars.waterCreeperSpawn, 1, 3);
        EntityRegistering.addOverWorldSpawn(EntityElectricCreeper.class, ECVars.electricCreeperSpawn, 1, 3);
        EntityRegistering.addOverWorldSpawn(EntityCookieCreeper.class, ECVars.cookieCreeperSpawn, 1, 2);
        EntityRegistering.addOverWorldSpawn(EntityDarkCreeper.class, ECVars.darkCreeperSpawn, 1, 3);
        EntityRegistering.addOverWorldSpawn(EntityLightCreeper.class, ECVars.lightCreeperSpawn, 1, 3);
        EntityRegistering.addOverWorldSpawn(EntityEarthCreeper.class, ECVars.earthCreeperSpawn, 1, 3);
        EntityRegistering.addNetherSpawn(EntityMagmaCreeper.class, ECVars.magmaCreeperSpawn, 1, 2);
        EntityRegistering.addOverWorldSpawn(EntityReverseCreeper.class, ECVars.reverseCreeperSpawn, 1, 3);
        EntityRegistering.addOverWorldSpawn(EntityIceCreeper.class, ECVars.iceCreeperSpawn, 1, 3);
        EntityRegistering.addOverWorldSpawn(EntityWindCreeper.class, ECVars.windCreeperSpawn, 1, 2);
    }

    private static void addOverWorldSpawn(Class<? extends EntityLiving> entityClass, int spawnprob, int min, int max, EnumCreatureType type) {
        for (int i = 0; i < typeList.length; ++i) {
            EntityRegistry.addSpawn(entityClass, (int)spawnprob, (int)min, (int)max, (EnumCreatureType)type, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)typeList[i]));
        }
    }

    private static void addOverWorldSpawn(Class<? extends EntityLiving> entityClass, int spawnprob, int min, int max) {
        for (int i = 0; i < typeList.length; ++i) {
            EntityRegistry.addSpawn(entityClass, (int)spawnprob, (int)min, (int)max, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)typeList[i]));
        }
    }

    private static void addNetherSpawn(Class<? extends EntityLiving> entityClass, int spawnprob, int min, int max) {
        EntityRegistry.addSpawn(entityClass, (int)spawnprob, (int)min, (int)max, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.NETHER));
    }

    private static void addEndSpawn(Class<? extends EntityLiving> entityClass, int spawnprob, int min, int max) {
        EntityRegistry.addSpawn(entityClass, (int)spawnprob, (int)min, (int)max, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.END));
    }

    private static String getCreeperName(String mob) {
        return "elementalcreepers:" + mob;
    }

    private static void registerEntity(Class<? extends Entity> entityClass, String entityName, int id, int bkEggColor, int fgEggColor) {
        EntityRegistry.instance();
        EntityRegistry.registerGlobalEntityID(entityClass, (String)entityName, (int)id);
        if (bkEggColor != 99999 && fgEggColor != 99999) {
            EntityList.field_75627_a.put(id, new EntityEggInfo(id, bkEggColor, fgEggColor));
        }
    }
}

