/*
 * Decompiled with CFR 0.152.
 */
package net.lomeli.ec.core;

import java.io.File;
import net.lomeli.ec.lib.ECVars;
import net.lomeli.lomlib.util.XMLConfiguration;

public class Config {
    public static XMLConfiguration config;

    public static void loadConfig(File configFile) {
        config = new XMLConfiguration(configFile);
        config.loadXml();
        Config.loadID();
        Config.loadCreeperOptions();
        Config.loadSpawnRates();
        Config.loadBlastRadius();
        config.saveXML();
    }

    private static void loadID() {
        ECVars.fireCreeperID = config.getInt("fireCreeperID", 70, "Creeper IDs", XMLConfiguration.ConfigEnum.GENERAL_CONFIG);
        ECVars.waterCreeperID = Config.setGetInt("waterCreeperID", 71);
        ECVars.electricCreeperID = Config.setGetInt("electricCreeperID", 72);
        ECVars.cookieCreeperID = Config.setGetInt("cookieCreeperID", 73);
        ECVars.darkCreeperID = Config.setGetInt("darkCreeperID", 74);
        ECVars.lightCreeperID = Config.setGetInt("lightCreeperID", 75);
        ECVars.earthCreeperID = Config.setGetInt("earthCreeperID", 76);
        ECVars.magmaCreeperID = Config.setGetInt("magmaCreeperID", 77);
        ECVars.reverseCreeperID = Config.setGetInt("reverseCreeperID", 78);
        ECVars.iceCreeperID = Config.setGetInt("iceCreeperID", 79);
        ECVars.friendlyCreeperID = Config.setGetInt("friendlyCreeperID", 40);
        ECVars.ghostCreeperID = Config.setGetInt("ghostCreeperID", 41);
        ECVars.fakeIllusionCreeperID = Config.setGetInt("fakeIllusionCreeperID", 42);
        ECVars.illusionCreeperID = Config.setGetInt("illusionCreeperID", 43);
        ECVars.windCreeperID = Config.setGetInt("windCreeperID", 47);
    }

    private static void loadCreeperOptions() {
        ECVars.cookieCreeperAmount = config.getInt("cookiesDropped", 4, "The number of cookies a Cookie Creeper drops", XMLConfiguration.ConfigEnum.OTHER);
    }

    private static void loadSpawnRates() {
        ECVars.fireCreeperSpawn = config.getInt("fireCreeperSpawn", 50, "Creeper Spawn Rates", XMLConfiguration.ConfigEnum.GENERAL_CONFIG);
        ECVars.waterCreeperSpawn = Config.setGetInt("waterCreeperSpawn", 50);
        ECVars.electricCreeperSpawn = Config.setGetInt("electricCreeperSpawn", 50);
        ECVars.cookieCreeperSpawn = Config.setGetInt("cookieCreeperSpawn", 50);
        ECVars.darkCreeperSpawn = Config.setGetInt("darkCreeperSpawn", 50);
        ECVars.lightCreeperSpawn = Config.setGetInt("lightCreeperSpawn", 20);
        ECVars.earthCreeperSpawn = Config.setGetInt("earthCreeperSpawn", 50);
        ECVars.magmaCreeperSpawn = Config.setGetInt("magmaCreeperSpawn", 30);
        ECVars.reverseCreeperSpawn = Config.setGetInt("reverseCreeperSpawn", 30);
        ECVars.iceCreeperSpawn = Config.setGetInt("iceCreeperSpawn", 50);
        ECVars.windCreeperSpawn = Config.setGetInt("windCreeperSpawn", 30);
    }

    private static void loadBlastRadius() {
        ECVars.waterCreeperRadius = config.getInt("waterCreeperRadius", 4, "Creeper Explosion Radius", XMLConfiguration.ConfigEnum.GENERAL_CONFIG);
        ECVars.fireCreeperRadius = Config.setGetInt("fireCreeperRadius", 6);
        ECVars.iceCreeperRadius = Config.setGetInt("iceCreeperRadius", 12);
        ECVars.electricCreeperRadius = Config.setGetInt("electricCreeperRadius", 5);
        ECVars.earthCreeperRadius = Config.setGetInt("earthCreeperRadius", 8);
        ECVars.psychicCreeperRadius = Config.setGetInt("psychicCreeperRadius", 5);
        ECVars.psychicCreeperPower = Config.setGetInt("psychicCreeperPower", 8);
        ECVars.cookieCreeperAmount = Config.setGetInt("cookieCreeperAmount", 5);
        ECVars.magmaCreeperRadius = Config.setGetInt("magmaCreeperRadius", 3);
        ECVars.ghostCreeperRadius = Config.setGetInt("ghostCreeperRadius", 5);
        ECVars.ghostCreeperChance = Config.setGetInt("ghostCreeperChance", 35);
        ECVars.lightCreeperRadius = Config.setGetInt("lightCreeperRadius", 4);
        ECVars.darkCreeperRadius = Config.setGetInt("darkCreeperRadius", 12);
        ECVars.reverseCreeperRadius = Config.setGetInt("reverseCreeperRadius", 8);
        ECVars.windCreeperRadius = Config.setGetInt("windCreeperRadius", 5);
    }

    private static int setGetInt(String tag, int id) {
        return config.getInt(tag, id, XMLConfiguration.ConfigEnum.GENERAL_CONFIG);
    }
}

