/*
 * Decompiled with CFR 0.152.
 */
package eu.thesociety.DragonbornSR.DragonsRadioMod.Block.TileEntity;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import eu.thesociety.DragonbornSR.DragonsRadioMod.ModRadioBlock;
import eu.thesociety.DragonbornSR.DragonsRadioMod.player.MP3Player;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class TileEntityRadio
extends TileEntity {
    private MP3Player player = null;
    public boolean isPlaying = false;
    public String streamURL = "";
    public boolean blockExists = true;
    private World world;
    public float volume = 0.1f;
    private boolean redstoneInput = false;
    public boolean listenToRedstone = false;
    private boolean scheduledRedstoneInput = false;
    private boolean scheduleRedstoneInput = false;

    public TileEntityRadio(World w) {
        this.world = w;
        if (this.isPlaying) {
            this.startStream();
        }
    }

    public TileEntityRadio() {
        if (this.isPlaying) {
            this.startStream();
        }
    }

    public void deleted() {
        this.blockExists = false;
    }

    public Block func_70311_o() {
        return ModRadioBlock.blockRadio;
    }

    public void setWorld(World w) {
        this.world = w;
    }

    public void startStream() {
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        if (!this.isPlaying) {
            this.isPlaying = true;
            if (side == Side.CLIENT) {
                this.player = new MP3Player(this.streamURL, this.world, this.field_70329_l, this.field_70330_m, this.field_70327_n);
                ModRadioBlock.playerList.add(this.player);
            }
        }
    }

    public void stopStream() {
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        if (this.isPlaying) {
            if (side == Side.CLIENT) {
                this.player.stop();
                ModRadioBlock.playerList.remove(this.player);
            }
            this.isPlaying = false;
        }
    }

    public boolean isPlaying() {
        return this.isPlaying;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70313_j() {
        this.stopStream();
        super.func_70313_j();
    }

    public void func_70316_g() {
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        if (side == Side.CLIENT && Minecraft.func_71410_x().field_71439_g != null && this.player != null && !this.func_70320_p()) {
            float vol = (float)this.func_70318_a(Minecraft.func_71410_x().field_71439_g.field_70165_t, Minecraft.func_71410_x().field_71439_g.field_70163_u, Minecraft.func_71410_x().field_71439_g.field_70161_v);
            if (vol > 10000.0f * this.volume) {
                this.player.setVolume(0.0f);
            } else {
                float v2 = 10000.0f / vol / 100.0f;
                if (v2 > 1.0f) {
                    this.player.setVolume(1.0f * this.volume * this.volume);
                } else {
                    this.player.setVolume(v2 * this.volume * this.volume);
                }
            }
            if (vol == 0.0f) {
                this.func_70313_j();
            }
        }
        if (this.scheduleRedstoneInput && this.listenToRedstone) {
            if (!this.scheduledRedstoneInput && this.redstoneInput) {
                PacketDispatcher.sendPacketToAllPlayers((Packet)ModRadioBlock.setPacket(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.streamURL, !this.isPlaying, this.volume, 1));
                this.isPlaying = !this.isPlaying;
            }
            this.redstoneInput = this.scheduledRedstoneInput;
            this.scheduleRedstoneInput = false;
            this.scheduledRedstoneInput = false;
        }
    }

    public void func_70307_a(NBTTagCompound par1NBTTagCompound) {
        super.func_70307_a(par1NBTTagCompound);
        this.streamURL = par1NBTTagCompound.func_74779_i("streamurl");
        this.volume = par1NBTTagCompound.func_74760_g("volume");
        this.listenToRedstone = par1NBTTagCompound.func_74767_n("input");
        this.redstoneInput = par1NBTTagCompound.func_74767_n("lastInput");
        this.isPlaying = par1NBTTagCompound.func_74767_n("lastState");
    }

    public void func_70310_b(NBTTagCompound par1NBTTagCompound) {
        super.func_70310_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74778_a("streamurl", this.streamURL);
        par1NBTTagCompound.func_74776_a("volume", this.volume);
        par1NBTTagCompound.func_74757_a("input", this.listenToRedstone);
        par1NBTTagCompound.func_74757_a("lastInput", this.redstoneInput);
        par1NBTTagCompound.func_74757_a("lastState", this.isPlaying);
    }

    public Packet func_70319_e() {
        int mode = 13;
        if (this.listenToRedstone) {
            mode = 14;
        }
        return ModRadioBlock.setPacket(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.streamURL, this.isPlaying, this.volume, mode);
    }

    public boolean getListenRedstoneInput() {
        return this.listenToRedstone;
    }

    public void setRedstoneInput(boolean input) {
        if (input) {
            this.scheduledRedstoneInput = input;
        }
        this.scheduleRedstoneInput = true;
    }
}

