/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.minecraft.dragon.server.entity.helper;

import info.ata4.minecraft.dragon.server.entity.EntityTameableDragon;
import info.ata4.minecraft.dragon.server.entity.helper.DragonHelper;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DragonReproductionHelper
extends DragonHelper {
    private static final Logger L = LogManager.getLogger();
    public static final String NBT_BREEDER = "HatchedBy";
    public static final String NBT_REPRODUCED = "HasReproduced";
    public static final String NBT_REPRO_COUNT = "ReproductionCount";
    public static final byte REPRO_LIMIT = 2;
    private final int dataIndexBreeder;
    private final int dataIndexReproduced;

    public DragonReproductionHelper(EntityTameableDragon dragon, int dataIndexBreeder, int dataIndexReproCount) {
        super(dragon);
        this.dataIndexBreeder = dataIndexBreeder;
        this.dataIndexReproduced = dataIndexReproCount;
        this.dataWatcher.func_75682_a(dataIndexBreeder, (Object)"");
        this.dataWatcher.func_75682_a(dataIndexReproCount, (Object)0);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74778_a(NBT_BREEDER, this.getBreederName() == null ? "" : this.getBreederName());
        nbt.func_74768_a(NBT_REPRO_COUNT, this.getReproCount());
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.setBreederName(nbt.func_74779_i(NBT_BREEDER));
        int reproCount = 0;
        if (!nbt.func_74764_b(NBT_REPRO_COUNT)) {
            if (nbt.func_74767_n(NBT_REPRODUCED)) {
                ++reproCount;
            }
        } else {
            reproCount = nbt.func_74762_e(NBT_REPRO_COUNT);
        }
        this.setReproCount(reproCount);
    }

    public int getReproCount() {
        return this.dataWatcher.func_75679_c(this.dataIndexReproduced);
    }

    public void setReproCount(int reproCount) {
        L.trace("setReproCount({})", new Object[]{reproCount});
        this.dataWatcher.func_75692_b(this.dataIndexReproduced, (Object)reproCount);
    }

    public void addReproduced() {
        this.setReproCount(this.getReproCount() + 1);
    }

    public boolean canReproduce() {
        return this.getReproCount() < 2;
    }

    public String getBreederName() {
        return this.dataWatcher.func_75681_e(this.dataIndexBreeder);
    }

    public EntityPlayer getBreeder() {
        String breederName = this.getBreederName();
        return this.dragon.field_70170_p.func_72924_a(breederName);
    }

    public void setBreederName(String breederName) {
        L.trace("setBreederName({})", new Object[]{breederName});
        this.dataWatcher.func_75692_b(this.dataIndexBreeder, (Object)breederName);
    }

    public boolean canMateWith(EntityAnimal mate) {
        if (mate == this.dragon) {
            return false;
        }
        if (!this.dragon.func_70909_n()) {
            return false;
        }
        if (!(mate instanceof EntityTameableDragon)) {
            return false;
        }
        if (!this.canReproduce()) {
            return false;
        }
        EntityTameableDragon dragonMate = (EntityTameableDragon)mate;
        if (!dragonMate.func_70909_n()) {
            return false;
        }
        if (!dragonMate.getReproductionHelper().canReproduce()) {
            return false;
        }
        return this.dragon.func_70880_s() && dragonMate.func_70880_s();
    }

    public EntityAgeable createChild(EntityAgeable mate) {
        if (!(mate instanceof EntityTameableDragon)) {
            throw new IllegalArgumentException("The mate isn't a dragon");
        }
        EntityTameableDragon parent1 = this.dragon;
        EntityTameableDragon parent2 = (EntityTameableDragon)mate;
        EntityTameableDragon baby = new EntityTameableDragon(this.dragon.field_70170_p);
        if (parent1.func_94056_bM() && parent2.func_94056_bM()) {
            String babyName;
            String p1Name = parent1.func_94057_bL();
            String p2Name = parent2.func_94057_bL();
            if (p1Name.contains(" ") || p2Name.contains(" ")) {
                String[] p1Names = p1Name.split(" ");
                String[] p2Names = p2Name.split(" ");
                p1Name = this.fixChildName(p1Names[this.rand.nextInt(p1Names.length)]);
                p2Name = this.fixChildName(p2Names[this.rand.nextInt(p2Names.length)]);
                babyName = this.rand.nextBoolean() ? p1Name + " " + p2Name : p2Name + " " + p1Name;
            } else {
                p1Name = this.rand.nextBoolean() ? p1Name.substring(0, (p1Name.length() - 1) / 2) : p1Name.substring((p1Name.length() - 1) / 2);
                p2Name = this.rand.nextBoolean() ? p2Name.substring(0, (p2Name.length() - 1) / 2) : p2Name.substring((p2Name.length() - 1) / 2);
                p2Name = this.fixChildName(p2Name);
                babyName = this.rand.nextBoolean() ? p1Name + p2Name : p2Name + p1Name;
            }
            baby.func_94058_c(babyName);
        }
        baby.getBreedHelper().inheritBreed(parent1, parent2);
        parent1.getReproductionHelper().addReproduced();
        parent2.getReproductionHelper().addReproduced();
        return baby;
    }

    private String fixChildName(String nameOld) {
        if (nameOld == null || nameOld.isEmpty()) {
            return nameOld;
        }
        char[] chars = nameOld.toLowerCase().toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        String nameNew = new String(chars);
        if (!nameOld.equals(nameNew)) {
            L.debug("Fixed child name {} -> {}");
        }
        return nameNew;
    }
}

