/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.minecraft.dragon.server;

import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartedEvent;
import cpw.mods.fml.common.event.FMLServerStoppedEvent;
import cpw.mods.fml.common.registry.EntityRegistry;
import info.ata4.minecraft.dragon.DragonMounts;
import info.ata4.minecraft.dragon.DragonMountsConfig;
import info.ata4.minecraft.dragon.server.cmd.CommandDragon;
import info.ata4.minecraft.dragon.server.entity.EntityTameableDragon;
import info.ata4.minecraft.dragon.server.handler.DragonEggBlockHandler;
import info.ata4.minecraft.dragon.server.network.DragonControlChannelHandler;
import net.minecraft.command.ICommand;
import net.minecraft.command.ServerCommandManager;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.MinecraftForge;

public class ServerProxy {
    private DragonControlChannelHandler controlChannel;
    private DragonMountsConfig config;

    public DragonMountsConfig getConfig() {
        return this.config;
    }

    public DragonControlChannelHandler getControlChannel() {
        return this.controlChannel;
    }

    public void onPreInit(FMLPreInitializationEvent evt) {
        this.config = new DragonMountsConfig(evt.getSuggestedConfigurationFile());
    }

    public void onInit(FMLInitializationEvent evt) {
        this.registerEntities();
        if (DragonMounts.getConfig().isEggsInChests()) {
            this.registerChestItems();
        }
        MinecraftForge.EVENT_BUS.register((Object)new DragonEggBlockHandler());
        this.controlChannel = new DragonControlChannelHandler("DragonControls");
    }

    public void onServerStarted(FMLServerStartedEvent evt) {
        MinecraftServer server = MinecraftServer.func_71276_C();
        ServerCommandManager cmdman = (ServerCommandManager)server.func_71187_D();
        cmdman.func_71560_a((ICommand)new CommandDragon());
    }

    public void onServerStopped(FMLServerStoppedEvent evt) {
    }

    private void registerEntities() {
        int dragonEntityID = this.getConfig().getDragonEntityID();
        if (dragonEntityID == -1) {
            dragonEntityID = EntityRegistry.findGlobalUniqueEntityId();
        }
        EntityRegistry.registerGlobalEntityID(EntityTameableDragon.class, (String)"DragonMount", (int)dragonEntityID, (int)0, (int)0xCC00FF);
    }

    public void registerChestItems() {
        ChestGenHooks chestGenHooksDungeon = ChestGenHooks.getInfo((String)"dungeonChest");
        chestGenHooksDungeon.addItem(new WeightedRandomChestContent(new ItemStack(Blocks.field_150380_bt), 1, 1, 70));
        ChestGenHooks chestGenHooksMineshaft = ChestGenHooks.getInfo((String)"mineshaftCorridor");
        chestGenHooksMineshaft.addItem(new WeightedRandomChestContent(new ItemStack(Blocks.field_150380_bt), 1, 1, 5));
        ChestGenHooks chestGenHooksJungleChest = ChestGenHooks.getInfo((String)"pyramidJungleChest");
        chestGenHooksJungleChest.addItem(new WeightedRandomChestContent(new ItemStack(Blocks.field_150380_bt), 1, 1, 15));
        ChestGenHooks chestGenHooksDesertChest = ChestGenHooks.getInfo((String)"pyramidDesertyChest");
        chestGenHooksDesertChest.addItem(new WeightedRandomChestContent(new ItemStack(Blocks.field_150380_bt), 1, 1, 10));
    }
}

