/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.minecraft.dragon.client.handler;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.ReflectionHelper;
import info.ata4.minecraft.dragon.client.handler.DragonControl;
import info.ata4.minecraft.dragon.server.entity.EntityTameableDragon;
import info.ata4.minecraft.dragon.server.util.PrivateFields;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.GameSettings;

public class DragonEntityWatcher {
    private final Minecraft mc = Minecraft.func_71410_x();
    private final float defaultThirdPersonDistance = this.getThirdPersonDistance();
    private int noticeTicks;
    private boolean ridingDragon;
    private boolean ridingDragonPrev;

    private float getThirdPersonDistance() {
        return ((Float)ReflectionHelper.getPrivateValue(EntityRenderer.class, (Object)this.mc.field_71460_t, (String[])PrivateFields.ENTITYRENDERER_THIRDPERSONDISTANCE)).floatValue();
    }

    private void setThirdPersonDistance(float thirdPersonDistance) {
        ReflectionHelper.setPrivateValue(EntityRenderer.class, (Object)this.mc.field_71460_t, (Object)Float.valueOf(thirdPersonDistance), (String[])PrivateFields.ENTITYRENDERER_THIRDPERSONDISTANCE);
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent evt) {
        if (evt.phase != TickEvent.Phase.START) {
            return;
        }
        if (this.mc.field_71439_g == null) {
            return;
        }
        this.ridingDragon = this.mc.field_71439_g.field_70154_o instanceof EntityTameableDragon;
        if (this.ridingDragon && !this.ridingDragonPrev) {
            this.setThirdPersonDistance(6.0f);
            this.noticeTicks = 70;
        } else if (!this.ridingDragon && this.ridingDragonPrev) {
            this.setThirdPersonDistance(this.defaultThirdPersonDistance);
            this.noticeTicks = 0;
        } else {
            if (this.noticeTicks > 0) {
                --this.noticeTicks;
            }
            if (this.noticeTicks == 1) {
                String keyUpName = GameSettings.func_74298_c((int)DragonControl.KEY_FLY_UP.func_151463_i());
                String keyDownName = GameSettings.func_74298_c((int)DragonControl.KEY_FLY_DOWN.func_151463_i());
                this.mc.field_71456_v.func_110326_a(I18n.func_135052_a((String)"dragon.mountNotice", (Object[])new Object[]{keyUpName, keyDownName}), false);
            }
        }
        this.ridingDragonPrev = this.ridingDragon;
    }
}

