/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.minecraft.dragon;

import info.ata4.minecraft.dragon.util.BasicModConfig;
import java.io.File;
import net.minecraftforge.common.config.Property;

public class DragonMountsConfig
extends BasicModConfig {
    private static final boolean DEF_EGGS_IN_CHESTS = false;
    private static final int DEF_DRAGON_ENTITY_ID = -1;
    private static final boolean DEF_DEBUG = false;
    private Property eggsInChests;
    private Property dragonEntityID;
    private Property debug;

    public DragonMountsConfig(File configFile) {
        super(configFile);
    }

    @Override
    protected void init() {
        this.eggsInChests = this.config.get("server", "eggsInChests", false, "Spawns dragon eggs in generated chests when enabled");
        this.dragonEntityID = this.config.get("server", "dragonEntityID", -1, "Overrides the entity ID for dragons to fix problems with manual IDs from other mods.\nSet to -1 for automatic assignment (recommended).\nWarning: wrong values may cause crashes and loss of data!");
        this.debug = this.config.get("client", "debug", false, "Debug mode. Unless you're a developer or are told to activate it, you don't want to set this to true.");
    }

    public boolean isEggsInChests() {
        return this.eggsInChests.getBoolean(false);
    }

    public void setEggsInChests(boolean enabled) {
        this.eggsInChests.set(enabled);
    }

    public int getDragonEntityID() {
        return this.dragonEntityID.getInt(-1);
    }

    public void getDragonEntityID(int id) {
        this.dragonEntityID.set(id);
    }

    public boolean isDebug() {
        return this.debug.getBoolean(false);
    }

    public void setDebug(boolean enabled) {
        this.debug.set(enabled);
    }
}

