/*
 * Decompiled with CFR 0.152.
 */
package deathcounter.core;

import cpw.mods.fml.common.FMLCommonHandler;
import deathcounter.core.DeathCounter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;

public class CommandDeathCounter
extends CommandBase {
    public String func_71517_b() {
        return "dc";
    }

    public String func_71518_a(ICommandSender par1ICommandSender) {
        return "/" + this.func_71517_b() + " (leaderboard/reset) [all/user]";
    }

    public List func_71514_a() {
        return Arrays.asList("deathcounter");
    }

    public void func_71515_b(ICommandSender var1, String[] var2) {
        if (var2.length > 0) {
            if ("leaderboard".toLowerCase().startsWith(var2[0])) {
                if (var2.length >= 2) {
                    if (var2[1].equalsIgnoreCase("all")) {
                        CommandDeathCounter.broadcastLeaderboard(null);
                        return;
                    }
                    CommandDeathCounter.broadcastLeaderboard(var2[1]);
                    return;
                }
                CommandDeathCounter.broadcastLeaderboard(var1.func_70005_c_());
                return;
            }
            if ("reset".toLowerCase().startsWith(var2[0])) {
                if (var2.length >= 2) {
                    if (var2[1].equalsIgnoreCase("all")) {
                        CommandDeathCounter.func_71522_a((ICommandSender)var1, (String)"dc.command.resetAll", (Object[])new Object[0]);
                        DeathCounter.console(var1.func_70005_c_() + ": Resetting deaths for all players");
                        return;
                    }
                    if (DeathCounter.instance.clearDeath(var2[1])) {
                        CommandDeathCounter.func_71522_a((ICommandSender)var1, (String)"dc.command.resetPlayer", (Object[])new Object[0]);
                        DeathCounter.console(var1.func_70005_c_() + ": Resetting deaths for " + var2[1]);
                        return;
                    }
                    var1.func_145747_a((IChatComponent)new ChatComponentTranslation("dc.command.noDeathsPlayer", new Object[]{var2[1]}));
                    return;
                }
                throw new WrongUsageException("/" + this.func_71517_b() + " reset [all/user]", new Object[0]);
            }
            throw new WrongUsageException("/" + this.func_71517_b() + " (leaderboard/reset) [all/user]", new Object[0]);
        }
        throw new WrongUsageException("/" + this.func_71517_b() + " (leaderboard/reset) [all/user]", new Object[0]);
    }

    public static void broadcastLeaderboard(String s) {
        ArrayList<Object> playersToNotify = new ArrayList<Object>();
        if (s != null) {
            if (!s.equals("Server")) {
                if (FMLCommonHandler.instance().getMinecraftServerInstance().func_71203_ab().func_72361_f(s) == null) {
                    return;
                }
                playersToNotify.add(FMLCommonHandler.instance().getMinecraftServerInstance().func_71203_ab().func_72361_f(s));
            }
        } else {
            List players = FMLCommonHandler.instance().getMinecraftServerInstance().func_71203_ab().field_72404_b;
            for (Object o : players) {
                EntityPlayer player = (EntityPlayer)o;
                playersToNotify.add(player);
            }
        }
        if (s != null && s.equals("Server")) {
            if (DeathCounter.ranking.isEmpty()) {
                DeathCounter.console("No deaths have occured on this server yet.");
            } else {
                DeathCounter.console("Death Leaderboard:");
                for (int i = 1; i <= DeathCounter.leaderboardCount && i - 1 < DeathCounter.ranking.size(); ++i) {
                    DeathCounter.console("   " + DeathCounter.instance.getDisplayedRank(DeathCounter.ranking.get(i - 1)) + "  " + DeathCounter.ranking.get(i - 1) + " (" + DeathCounter.instance.getDeathCount(DeathCounter.ranking.get(i - 1)) + (DeathCounter.instance.getDeathCount(DeathCounter.ranking.get(i - 1)) == 1 ? " Death)" : " Deaths)"));
                }
            }
        } else {
            for (EntityPlayer entityPlayer : playersToNotify) {
                if (DeathCounter.ranking.isEmpty()) {
                    entityPlayer.func_145747_a((IChatComponent)new ChatComponentTranslation("dc.command.noDeaths", new Object[0]));
                    continue;
                }
                boolean isPlayer = false;
                entityPlayer.func_145747_a((IChatComponent)new ChatComponentTranslation("dc.command.leaderboard", new Object[0]));
                for (int i = 1; i <= DeathCounter.leaderboardCount && i - 1 < DeathCounter.ranking.size(); ++i) {
                    String playerName = DeathCounter.ranking.get(i - 1);
                    if (playerName.equals(entityPlayer.func_70005_c_())) {
                        isPlayer = true;
                    }
                    int rank = DeathCounter.instance.getDisplayedRank(playerName);
                    entityPlayer.func_145747_a((IChatComponent)new ChatComponentText((rank == 1 ? "\u00a7e" : (rank == 2 ? "\u00a77" : (rank == 3 ? "\u00a74" : ""))) + (playerName.equals(entityPlayer.func_70005_c_()) ? " ->" : "    ") + rank + "  " + DeathCounter.ranking.get(i - 1) + " (" + DeathCounter.instance.getDeathCount(DeathCounter.ranking.get(i - 1)) + (DeathCounter.instance.getDeathCount(DeathCounter.ranking.get(i - 1)) == 1 ? " Death)" : " Deaths)")));
                }
                if (isPlayer) continue;
                int rank = DeathCounter.instance.getDisplayedRank(entityPlayer.func_70005_c_());
                entityPlayer.func_145747_a((IChatComponent)new ChatComponentText(" ->" + rank + (rank >= 10 ? " " : "  ") + entityPlayer.func_70005_c_() + " (" + DeathCounter.instance.getDeathCount(entityPlayer.func_70005_c_()) + (DeathCounter.instance.getDeathCount(entityPlayer.func_70005_c_()) == 1 ? " Death)" : " Deaths)")));
            }
        }
    }

    public List func_71516_a(ICommandSender ics, String[] args) {
        if (args.length == 1) {
            return CommandDeathCounter.func_71530_a((String[])args, (String[])new String[]{"reset", "leaderboard"});
        }
        if (args.length == 2) {
            return CommandDeathCounter.func_71530_a((String[])args, (String[])FMLCommonHandler.instance().getMinecraftServerInstance().func_71213_z());
        }
        return null;
    }
}

