/*
 * Decompiled with CFR 0.152.
 */
package deathcounter.core;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartedEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import deathcounter.core.CommandDeathCounter;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import net.minecraft.command.CommandHandler;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="DeathCounter", name="DeathCounter", version="3.0.0")
public class DeathCounter {
    public static final String version = "3.0.0";
    public static File saveDir;
    public static HashMap<String, Integer> deathCounter;
    public static ArrayList<String> ranking;
    public static int message;
    public static int leaderboardCount;
    public static int outputToTextFile;
    public static int singleSession;
    @Mod.Instance(value="DeathCounter")
    public static DeathCounter instance;
    private static Logger logger;

    @Mod.EventHandler
    public void preLoad(FMLPreInitializationEvent event) {
        logger = LogManager.getLogger((String)"DeathCounter");
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        message = this.addCommentAndReturnInt(config, "deathcounter", "message", "Death Count Messages?\n0 = Disable\n1 = Short message\n2 = Long message", 2);
        leaderboardCount = this.addCommentAndReturnInt(config, "deathcounter", "leaderboardCount", "Number of names to show in the leaderboards", 5);
        singleSession = this.addCommentAndReturnInt(config, "deathcounter", "singleSession", "Do not save deaths in save folder?\n0 = No\n1 = Yes", 0);
        outputToTextFile = this.addCommentAndReturnInt(config, "deathcounter", "outputToTextFile", "Output deaths to text file in save folder?\n(This is overridden to 0 by the singleSession config)\n0 = No\n1 = Yes", 1);
        config.save();
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)instance);
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        ICommandManager manager = event.getServer().func_71187_D();
        if (manager instanceof CommandHandler) {
            CommandHandler handler = (CommandHandler)manager;
            handler.func_71560_a((ICommand)new CommandDeathCounter());
        }
    }

    @Mod.EventHandler
    public void serverStarted(FMLServerStartedEvent event) {
        deathCounter.clear();
        ranking.clear();
        this.loadDeaths(DimensionManager.getWorld((int)0));
        this.sortRanking();
    }

    public int addCommentAndReturnInt(Configuration config, String cat, String s, String comment, int i) {
        Property prop = config.get(cat, s, i);
        if (!comment.equalsIgnoreCase("")) {
            prop.comment = comment;
        }
        return prop.getInt();
    }

    public void loadDeaths(WorldServer world) {
        File[] files;
        File dir = new File(world.getChunkSaveLocation(), "deathCounter");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        saveDir = dir;
        for (File file : files = dir.listFiles()) {
            if (!file.getName().endsWith(".dat")) continue;
            String user = file.getName().substring(0, file.getName().length() - 4);
            try {
                NBTTagCompound tag = CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(file));
                deathCounter.put(user, tag.func_74762_e("deaths"));
            }
            catch (EOFException e) {
                DeathCounter.console("File for " + user + " is corrupted. Flushing.");
            }
            catch (IOException e) {
                DeathCounter.console("Failed to read file for " + user + ". Flushing.");
            }
        }
    }

    public void sortRanking() {
        for (Map.Entry<String, Integer> e : deathCounter.entrySet()) {
            ranking.remove(e.getKey());
            if (e.getValue() <= 0) continue;
            for (int i = 0; i < ranking.size(); ++i) {
                if (this.getDeathCount(ranking.get(i)) > e.getValue()) continue;
                ranking.add(i, e.getKey());
                break;
            }
            if (ranking.contains(e.getKey())) continue;
            ranking.add(e.getKey());
        }
        if (singleSession != 1 && outputToTextFile == 1) {
            Properties s = new Properties();
            File text = new File(saveDir, "deaths.txt");
            if (text == null || text.isDirectory()) {
                return;
            }
            for (Map.Entry<String, Integer> e : deathCounter.entrySet()) {
                s.setProperty(e.getKey(), Integer.toString(e.getValue()));
            }
            try {
                if (!text.exists()) {
                    text.createNewFile();
                }
                FileOutputStream fos = new FileOutputStream(text);
                s.store(fos, null);
                fos.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void addDeath(EntityPlayer player) {
        File file = new File(saveDir, player.func_70005_c_() + ".dat");
        NBTTagCompound tag = new NBTTagCompound();
        int deaths = this.getDeathCount(player.func_70005_c_()) + 1;
        tag.func_74768_a("deaths", deaths);
        deathCounter.put(player.func_70005_c_(), deaths);
        this.sortRanking();
        try {
            CompressedStreamTools.func_74799_a((NBTTagCompound)tag, (OutputStream)new FileOutputStream(file));
        }
        catch (IOException ioexception) {
            DeathCounter.console("Failed to save death count for " + player.func_70005_c_());
        }
    }

    public boolean clearDeath(String s) {
        if (s == null) {
            File[] files;
            for (File file : files = saveDir.listFiles()) {
                file.delete();
            }
            deathCounter.clear();
            ranking.clear();
            return true;
        }
        File file = new File(saveDir, s + ".dat");
        if (file.exists()) {
            file.delete();
            deathCounter.remove(s);
            this.sortRanking();
            return true;
        }
        return false;
    }

    public int getDeathCount(String s) {
        try {
            return deathCounter.get(s);
        }
        catch (NullPointerException e) {
            return 0;
        }
    }

    public int getDisplayedRank(String s) {
        if (ranking.contains(s)) {
            for (int i = 0; i < ranking.size(); ++i) {
                if (!ranking.get(i).equals(s)) continue;
                int rank = i;
                int deaths = this.getDeathCount(s);
                while (i > 0 && this.getDeathCount(ranking.get(--i)) == deaths) {
                    --rank;
                }
                return rank + 1;
            }
        }
        return ranking.size() + 1;
    }

    @SubscribeEvent
    public void onDeath(LivingDeathEvent event) {
        if (event.entityLiving instanceof EntityPlayer && FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER && FMLCommonHandler.instance().getMinecraftServerInstance().func_71203_ab().func_72361_f(((EntityPlayer)event.entityLiving).func_70005_c_()) != null) {
            EntityPlayer player = (EntityPlayer)event.entityLiving;
            this.addDeath(player);
            if (message > 0) {
                if (message == 1) {
                    player.func_145747_a((IChatComponent)new ChatComponentTranslation("dc.message.deathAndRank", new Object[]{this.getDeathCount(player.func_70005_c_()), this.getDisplayedRank(player.func_70005_c_())}));
                }
                if (message == 2) {
                    player.func_145747_a((IChatComponent)new ChatComponentTranslation("dc.message.death", new Object[]{this.getDeathCount(player.func_70005_c_())}));
                    player.func_145747_a((IChatComponent)new ChatComponentTranslation("dc.message.rank", new Object[]{this.getDisplayedRank(player.func_70005_c_())}));
                }
            }
        }
    }

    @SubscribeEvent
    public void onChatEvent(ServerChatEvent event) {
        if ("!dc".toLowerCase().startsWith(event.message.toLowerCase()) || "!deathcounter".toLowerCase().startsWith(event.message.toLowerCase())) {
            CommandDeathCounter.broadcastLeaderboard(event.username);
            event.setCanceled(true);
        }
    }

    public static void console(String s) {
        logger.log(Level.INFO, s);
    }

    static {
        deathCounter = new HashMap();
        ranking = new ArrayList();
    }
}

