/*
 * Decompiled with CFR 0.152.
 */
package CustomOreGen.Config;

import CustomOreGen.Config.HeightScaleType;
import CustomOreGen.Config.ParserException;
import CustomOreGen.Config.ValidatorNode;
import CustomOreGen.Server.IOreDistribution;
import CustomOreGen.Util.HeightScaledPDist;
import CustomOreGen.Util.PDist;
import org.w3c.dom.Node;

public class ValidatorPDist
extends ValidatorNode {
    private final IOreDistribution _parentDist;
    public String name = null;
    public PDist pdist = null;

    protected ValidatorPDist(ValidatorNode parent, Node node, IOreDistribution parentDistribution) {
        super(parent, node);
        this._parentDist = parentDistribution;
    }

    @Override
    protected boolean validateChildren() throws ParserException {
        super.validateChildren();
        this.name = this.validateRequiredAttribute(String.class, "Name", true);
        HeightScaledPDist heightScaledPDist = null;
        if (this._parentDist == null) {
            this.pdist = new PDist();
        } else {
            Object setting = this._parentDist.getDistributionSetting(this.name);
            if (setting instanceof PDist) {
                this.pdist = (PDist)setting;
            } else if (setting instanceof HeightScaledPDist) {
                heightScaledPDist = (HeightScaledPDist)setting;
                this.pdist = heightScaledPDist.pdist;
            } else {
                throw new ParserException("Setting '" + this.name + "' is not supported by this distribution.", this.getNode());
            }
            if (this.pdist == null) {
                throw new ParserException("Setting '" + this.name + "' is not supported by this distribution.", this.getNode());
            }
        }
        this.pdist.mean = this.validateNamedAttribute(Float.class, "Avg", Float.valueOf(this.pdist.mean), true).floatValue();
        this.pdist.range = this.validateNamedAttribute(Float.class, "Range", Float.valueOf(this.pdist.range), true).floatValue();
        this.pdist.type = this.validateNamedAttribute(PDist.Type.class, "Type", this.pdist.type, true);
        HeightScaleType scaleType = this.validateNamedAttribute(HeightScaleType.class, "ScaleTo", null, true);
        if (scaleType != null) {
            if (heightScaledPDist == null) {
                throw new ParserException("Setting '" + this.name + "' does not support height scaling.", this.getNode());
            }
            heightScaledPDist.scaleTo = scaleType.getHeightScale();
        }
        if (this._parentDist != null) {
            try {
                this._parentDist.setDistributionSetting(this.name, heightScaledPDist != null ? heightScaledPDist : this.pdist);
            }
            catch (IllegalAccessException var2) {
                throw new ParserException("Setting '" + this.name + "' is not configurable.", this.getNode(), (Exception)var2);
            }
            catch (IllegalArgumentException var3) {
                throw new ParserException("Setting '" + this.name + "' is not supported by this distribution.", this.getNode(), (Exception)var3);
            }
        }
        return true;
    }

    public static class Factory
    implements ValidatorNode.IValidatorFactory<ValidatorPDist> {
        private final IOreDistribution _parentDist;

        public Factory(IOreDistribution parentDistribution) {
            this._parentDist = parentDistribution;
        }

        @Override
        public ValidatorPDist createValidator(ValidatorNode parent, Node node) {
            return new ValidatorPDist(parent, node, this._parentDist);
        }
    }
}

