/*
 * Decompiled with CFR 0.152.
 */
package CustomOreGen.Config;

import CustomOreGen.Config.ExpressionEvaluator;
import CustomOreGen.Config.LineAwareSAXHandler;
import CustomOreGen.Config.ValidatorAnnotation;
import CustomOreGen.Config.ValidatorBiomeSet;
import CustomOreGen.Config.ValidatorDistribution;
import CustomOreGen.Config.ValidatorExpression;
import CustomOreGen.Config.ValidatorIfChoice;
import CustomOreGen.Config.ValidatorIfCondition;
import CustomOreGen.Config.ValidatorIfModInstalled;
import CustomOreGen.Config.ValidatorImport;
import CustomOreGen.Config.ValidatorMystcraftSymbol;
import CustomOreGen.Config.ValidatorNode;
import CustomOreGen.Config.ValidatorOption;
import CustomOreGen.Config.ValidatorRefOption;
import CustomOreGen.Config.ValidatorRoot;
import CustomOreGen.Config.ValidatorSection;
import CustomOreGen.Server.ChoiceOption;
import CustomOreGen.Server.ConfigOption;
import CustomOreGen.Server.IOreDistribution;
import CustomOreGen.Server.MapGenCloud;
import CustomOreGen.Server.MapGenClusters;
import CustomOreGen.Server.MapGenVeins;
import CustomOreGen.Server.NumericOption;
import CustomOreGen.Server.WorldConfig;
import CustomOreGen.Server.WorldGenSubstitution;
import CustomOreGen.Util.BiomeDescriptor;
import CustomOreGen.Util.BlockDescriptor;
import CustomOreGen.Util.CIStringMap;
import cpw.mods.fml.common.Loader;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ConfigParser {
    public final WorldConfig target;
    public final ConfigExpressionEvaluator defaultEvaluator = new ConfigExpressionEvaluator();
    protected Random rng = null;
    protected final DocumentBuilder domBuilder;
    protected final SAXParser saxParser;
    private static final Map<String, ValidatorNode.IValidatorFactory> distributionValidators = new HashMap<String, ValidatorNode.IValidatorFactory>();

    public boolean blockExists(String blockDescription) {
        return new BlockDescriptor(blockDescription).getTotalMatchWeight() > 0.0f;
    }

    public boolean biomeExists(String biomeDescription) {
        return new BiomeDescriptor(biomeDescription).getTotalMatchWeight() > 0.0f;
    }

    public float nextRandom() {
        return this.rng == null ? 0.0f : this.rng.nextFloat();
    }

    public ConfigParser(WorldConfig target) throws ParserConfigurationException, SAXException {
        this.target = target;
        DocumentBuilderFactory domBuilderFactory = DocumentBuilderFactory.newInstance();
        domBuilderFactory.setNamespaceAware(true);
        domBuilderFactory.setIgnoringComments(true);
        domBuilderFactory.setIgnoringElementContentWhitespace(true);
        domBuilderFactory.setExpandEntityReferences(true);
        this.domBuilder = domBuilderFactory.newDocumentBuilder();
        SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
        saxParserFactory.setNamespaceAware(true);
        this.saxParser = saxParserFactory.newSAXParser();
    }

    public void parseFile(File file) throws ParserConfigurationException, IOException, SAXException {
        Document fileDOM = this.domBuilder.newDocument();
        fileDOM.setUserData("value", file, null);
        this.saxParser.parse(file, (DefaultHandler)new LineAwareSAXHandler(fileDOM));
        ValidatorNode validator = new ValidatorNode(this, (Node)fileDOM);
        Vector<String> topLevelNodes = new Vector<String>();
        validator.addGlobalValidator((short)1, "Import", new ValidatorImport.Factory(true));
        validator.addGlobalValidator((short)1, "OptionalImport", new ValidatorImport.Factory(false));
        validator.addGlobalValidator((short)1, "Description", new ValidatorAnnotation.Factory());
        validator.addGlobalValidator((short)2, "Description", new ValidatorAnnotation.Factory());
        validator.addGlobalValidator((short)1, "Comment", new ValidatorAnnotation.Factory());
        validator.addGlobalValidator((short)1, "ConfigSection", new ValidatorSection.Factory());
        validator.addGlobalValidator((short)1, "IfCondition", new ValidatorIfCondition.Factory());
        validator.addGlobalValidator((short)1, "IfChoice", new ValidatorIfChoice.Factory(false));
        validator.addGlobalValidator((short)1, "IfNotChoice", new ValidatorIfChoice.Factory(true));
        validator.addGlobalValidator((short)1, "IfModInstalled", new ValidatorIfModInstalled.Factory(false));
        validator.addGlobalValidator((short)1, "IfNotModInstalled", new ValidatorIfModInstalled.Factory(true));
        validator.addGlobalValidator((short)1, "GetOption", new ValidatorRefOption.Factory());
        validator.addGlobalValidator((short)1, "Expression", new ValidatorExpression.Factory(this.defaultEvaluator));
        topLevelNodes.add("OptionDisplayGroup");
        validator.addGlobalValidator((short)1, "OptionDisplayGroup", new ValidatorOption.Factory(ConfigOption.DisplayGroup.class));
        topLevelNodes.add("OptionChoice");
        validator.addGlobalValidator((short)1, "OptionChoice", new ValidatorOption.Factory(ChoiceOption.class));
        topLevelNodes.add("OptionNumeric");
        validator.addGlobalValidator((short)1, "OptionNumeric", new ValidatorOption.Factory(NumericOption.class));
        topLevelNodes.add("MystcraftSymbol");
        validator.addGlobalValidator((short)1, "MystcraftSymbol", new ValidatorMystcraftSymbol.Factory());
        validator.addGlobalValidator((short)1, "BiomeSet", new ValidatorBiomeSet.Factory());
        for (Map.Entry<String, ValidatorNode.IValidatorFactory> entry : distributionValidators.entrySet()) {
            validator.addGlobalValidator((short)1, entry.getKey(), entry.getValue());
            topLevelNodes.add(entry.getKey());
        }
        validator.addGlobalValidator((short)1, "Config", new ValidatorRoot.Factory(topLevelNodes));
        if (this.target.worldInfo == null) {
            this.rng = null;
        } else {
            this.rng = new Random(this.target.worldInfo.func_76063_b());
            this.rng.nextInt();
        }
        validator.validate();
    }

    public static Object parseString(Class type, String value) throws IllegalArgumentException {
        if (type != null && value != null) {
            if (type.isAssignableFrom(String.class)) {
                return value;
            }
            if (type.isEnum()) {
                for (Enum val : (Enum[])type.getEnumConstants()) {
                    if (!val.name().equalsIgnoreCase(value)) continue;
                    return val;
                }
                throw new IllegalArgumentException("Invalid enumeration value '" + value + "'");
            }
            if (!type.isAssignableFrom(Character.TYPE) && !type.isAssignableFrom(Character.class)) {
                if (!type.isAssignableFrom(Boolean.TYPE) && !type.isAssignableFrom(Boolean.class)) {
                    try {
                        if (!type.isAssignableFrom(Byte.TYPE) && !type.isAssignableFrom(Byte.class)) {
                            if (!type.isAssignableFrom(Short.TYPE) && !type.isAssignableFrom(Short.class)) {
                                if (!type.isAssignableFrom(Integer.TYPE) && !type.isAssignableFrom(Integer.class)) {
                                    if (!type.isAssignableFrom(Long.TYPE) && !type.isAssignableFrom(Long.class)) {
                                        if (!type.isAssignableFrom(Float.TYPE) && !type.isAssignableFrom(Float.class)) {
                                            if (!type.isAssignableFrom(Double.TYPE) && !type.isAssignableFrom(Double.class)) {
                                                throw new IllegalArgumentException("Type '" + type.getSimpleName() + "' is not a string, enumeration, or primitve type.");
                                            }
                                            return Double.parseDouble(value);
                                        }
                                        return Float.valueOf(Float.parseFloat(value));
                                    }
                                    return Long.decode(value);
                                }
                                return Integer.decode(value);
                            }
                            return Short.decode(value);
                        }
                        return Byte.decode(value);
                    }
                    catch (NumberFormatException var6) {
                        throw new IllegalArgumentException("Invalid numerical value '" + value + "'", var6);
                    }
                }
                return Boolean.parseBoolean(value);
            }
            return value.length() == 0 ? Character.valueOf('\u0000') : Character.valueOf(value.charAt(0));
        }
        return null;
    }

    public static Number convertNumber(Class<? extends Number> type, Number value) throws IllegalArgumentException {
        if (type != null && value != null) {
            if (!type.isAssignableFrom(Byte.TYPE) && !type.isAssignableFrom(Byte.class)) {
                if (!type.isAssignableFrom(Short.TYPE) && !type.isAssignableFrom(Short.class)) {
                    if (!type.isAssignableFrom(Integer.TYPE) && !type.isAssignableFrom(Integer.class)) {
                        if (!type.isAssignableFrom(Long.TYPE) && !type.isAssignableFrom(Long.class)) {
                            if (!type.isAssignableFrom(Float.TYPE) && !type.isAssignableFrom(Float.class)) {
                                if (!type.isAssignableFrom(Double.TYPE) && !type.isAssignableFrom(Double.class)) {
                                    throw new IllegalArgumentException("Type '" + type.getSimpleName() + "' is not a numeric type.");
                                }
                                return value.doubleValue();
                            }
                            return Float.valueOf(value.floatValue());
                        }
                        return value.longValue();
                    }
                    return value.intValue();
                }
                return value.shortValue();
            }
            return value.byteValue();
        }
        return null;
    }

    public static void addDistributionType(String distributionName, ValidatorNode.IValidatorFactory validatorFactory) {
        if (distributionValidators.containsKey(distributionName)) {
            throw new IllegalArgumentException("A distribution with the name '" + distributionName + "' already exists.");
        }
        distributionValidators.put(distributionName, validatorFactory);
    }

    public static void addDistributionType(String distributionName, IOreDistribution.IDistributionFactory distFactory) {
        ConfigParser.addDistributionType(distributionName, new ValidatorDistribution.Factory(distFactory));
    }

    public static void addDistributionType(String distributionName, Class clazz, boolean canGenerate) {
        ConfigParser.addDistributionType(distributionName, new StdDistFactory(clazz, canGenerate));
    }

    static {
        ConfigParser.addDistributionType("StandardGen", MapGenClusters.class, true);
        ConfigParser.addDistributionType("StandardGenPreset", MapGenClusters.class, false);
        ConfigParser.addDistributionType("Veins", MapGenVeins.class, true);
        ConfigParser.addDistributionType("VeinsPreset", MapGenVeins.class, false);
        ConfigParser.addDistributionType("Cloud", MapGenCloud.class, true);
        ConfigParser.addDistributionType("CloudPreset", MapGenCloud.class, false);
        ConfigParser.addDistributionType("Substitute", WorldGenSubstitution.class, true);
        ConfigParser.addDistributionType("SubstitutePreset", WorldGenSubstitution.class, false);
    }

    private static class StdDistFactory
    implements IOreDistribution.IDistributionFactory {
        protected Constructor _ctor;
        protected boolean _canGen;

        public StdDistFactory(Class clazz, boolean canGenerate) {
            try {
                this._ctor = clazz.getConstructor(Integer.TYPE, Boolean.TYPE);
            }
            catch (NoSuchMethodException var4) {
                throw new IllegalArgumentException(var4);
            }
            this._canGen = canGenerate;
        }

        @Override
        public IOreDistribution createDistribution(int distributionID) {
            try {
                return (IOreDistribution)this._ctor.newInstance(distributionID, this._canGen);
            }
            catch (InvocationTargetException var3) {
                throw new IllegalArgumentException(var3);
            }
            catch (IllegalAccessException var4) {
                throw new IllegalArgumentException(var4);
            }
            catch (InstantiationException var5) {
                throw new IllegalArgumentException(var5);
            }
        }
    }

    public class ConfigExpressionEvaluator
    extends ExpressionEvaluator {
        private Map localIdentifiers = new CIStringMap();

        public ConfigExpressionEvaluator() {
            this.localIdentifiers.put("isModInstalled", new ExpressionEvaluator.EvaluationDelegate(false, Loader.class, "isModLoaded", String.class));
            this.localIdentifiers.put("blockExists", new ExpressionEvaluator.EvaluationDelegate(false, (Object)ConfigParser.this, "blockExists", String.class));
            this.localIdentifiers.put("biomeExists", new ExpressionEvaluator.EvaluationDelegate(false, (Object)ConfigParser.this, "biomeExists", String.class));
            this.localIdentifiers.put("world.nextRandom", new ExpressionEvaluator.EvaluationDelegate(false, (Object)ConfigParser.this, "nextRandom", new Class[0]));
        }

        public ConfigExpressionEvaluator(Object defaultValue) {
            this();
            this.localIdentifiers.put("_default_", defaultValue);
        }

        @Override
        protected Object getIdentifierValue(String identifier) {
            String lkey = identifier.toLowerCase();
            ConfigOption option = ConfigParser.this.target.getConfigOption(identifier);
            if (option != null) {
                return option.getValue();
            }
            Object property = ConfigParser.this.target.getWorldProperty(identifier);
            if (property != null) {
                return property;
            }
            Object value = this.localIdentifiers.get(identifier);
            return value != null ? value : (lkey.startsWith("age.") ? Integer.valueOf(0) : super.getIdentifierValue(identifier));
        }
    }
}

