/*
 * Decompiled with CFR 0.152.
 */
package CustomOreGen.Util;

import CustomOreGen.Server.DistributionSettingMap;
import java.util.Random;

public class PDist
implements DistributionSettingMap.Copyable<PDist> {
    public float mean;
    public float range;
    public Type type;

    public PDist(float mean, float range, Type type) {
        this.set(mean, range, type);
    }

    public PDist(float mean, float range) {
        this.set(mean, range, Type.uniform);
    }

    public PDist() {
        this.set(0.0f, 0.0f, Type.uniform);
    }

    public PDist(PDist pdist) {
        this.copyFrom(pdist);
    }

    @Override
    public void copyFrom(PDist source) {
        this.mean = source.mean;
        this.range = source.range;
        this.type = source.type;
    }

    public PDist set(float mean, float range, Type type) {
        this.mean = mean;
        this.range = range >= 0.0f ? range : -range;
        this.type = type;
        return this;
    }

    public float getMax() {
        return this.mean + this.range;
    }

    public float getMin() {
        return this.mean - this.range;
    }

    public float getValue(Random rand) {
        if (this.range == 0.0f) {
            return this.mean;
        }
        switch (this.type) {
            case uniform: {
                return (rand.nextFloat() * 2.0f - 1.0f) * this.range + this.mean;
            }
            case normal: {
                float value = (float)rand.nextGaussian() / 2.5f;
                if (value < -1.0f) {
                    value = -1.0f;
                } else if (value > 1.0f) {
                    value = 1.0f;
                }
                return value * this.range + this.mean;
            }
        }
        return 0.0f;
    }

    public int getIntValue(Random rand) {
        float fval = this.getValue(rand);
        return PDist.roundToInt(fval, rand);
    }

    public static int roundToInt(float fval, Random rand) {
        int ival;
        if ((fval -= (float)(ival = (int)fval)) > 0.0f && fval > rand.nextFloat()) {
            ++ival;
        } else if (fval < 0.0f && -fval > rand.nextFloat()) {
            --ival;
        }
        return ival;
    }

    public float standardize(float x) {
        return (x - this.mean) / this.range;
    }

    public float cdf(float x) {
        switch (this.type) {
            case uniform: {
                return this.standardize(x);
            }
            case normal: {
                float z = this.standardize(x);
                return (float)(1.0 / (1.0 + Math.exp(-0.07056 * Math.pow(z, 3.0) - 1.5976 * (double)z)));
            }
        }
        return 0.0f;
    }

    public String toString() {
        return String.format("%f +- %f %s", Float.valueOf(this.mean), Float.valueOf(this.range), this.type.name());
    }

    public static enum Type {
        uniform,
        normal;

    }
}

