/*
 * Decompiled with CFR 0.152.
 */
package CustomOreGen.Util;

import CustomOreGen.Server.DistributionSettingMap;
import CustomOreGen.Util.BaseHeightScale;
import CustomOreGen.Util.HeightScale;
import CustomOreGen.Util.PDist;
import java.util.Random;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class HeightScaledPDist
implements DistributionSettingMap.Copyable<HeightScaledPDist> {
    public PDist pdist;
    public HeightScale scaleFrom = new BaseHeightScale();
    public HeightScale scaleTo = new BaseHeightScale();

    public HeightScaledPDist(float mean, float range, PDist.Type type) {
        this.pdist = new PDist(mean, range, type);
    }

    public HeightScaledPDist(float mean, float range) {
        this(mean, range, PDist.Type.uniform);
    }

    public HeightScaledPDist() {
        this(0.0f, 0.0f, PDist.Type.uniform);
    }

    @Override
    public void copyFrom(HeightScaledPDist other) {
        this.pdist.copyFrom(other.pdist);
        this.scaleFrom = other.scaleFrom;
        this.scaleTo = other.scaleTo;
    }

    private float scale(float val, World world, int x, int z) {
        return val * (float)this.scaleTo.getHeight(world, x, z) / (float)this.scaleFrom.getHeight(world, x, z);
    }

    public float getValue(Random rand, World world, int x, int z) {
        return this.scale(this.pdist.getValue(rand), world, x, z);
    }

    public float getValue(Random rand, World world, float x, float z) {
        return this.scale(this.pdist.getValue(rand), world, MathHelper.func_76141_d((float)x), MathHelper.func_76141_d((float)z));
    }

    public float getMax(World world, int x, int z) {
        return this.scale(this.pdist.getMax(), world, x, z);
    }

    public float getMin(World world, int x, int z) {
        return this.scale(this.pdist.getMin(), world, x, z);
    }

    public HeightScaledPDist set(float mean, float range, PDist.Type type, HeightScale scaleTo) {
        this.set(mean, range, type);
        this.scaleTo = scaleTo;
        return this;
    }

    public HeightScaledPDist set(float mean, float range, PDist.Type type) {
        this.pdist.set(mean, range, type);
        return this;
    }

    public int getIntValue(Random rand, World world, int x, int z) {
        float fval = this.getValue(rand, world, x, z);
        return PDist.roundToInt(fval, rand);
    }

    public String toString() {
        return this.pdist.toString() + " * " + this.scaleTo.toString() + "/" + this.scaleFrom.toString();
    }
}

