/*
 * Decompiled with CFR 0.152.
 */
package CustomOreGen.Server;

import CustomOreGen.Server.DistributionSettingMap;
import CustomOreGen.Server.MapGenOreDistribution;
import CustomOreGen.Util.HeightScaledPDist;
import CustomOreGen.Util.IGeometryBuilder;
import CustomOreGen.Util.PDist;
import CustomOreGen.Util.Transform;
import CustomOreGen.Util.VolumeHelper;
import CustomOreGen.Util.WireframeShapes;
import java.util.Random;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;

public class MapGenVeins
extends MapGenOreDistribution {
    @DistributionSettingMap.DistributionSetting(name="branchType", info="Vein branch type (Bezier or Ellipsoid)")
    public BranchType brType = BranchType.Bezier;
    @DistributionSettingMap.DistributionSetting(name="MotherlodeFrequency", info="Number of motherlodes per 16x16 chunk")
    public final HeightScaledPDist mlFrequency = this.frequency;
    @DistributionSettingMap.DistributionSetting(name="MotherlodeRangeLimit", info="Max horizontal distance that a motherlode may be from the parent distribution, in meters")
    public final PDist mlRangeLimit = this.parentRangeLimit;
    @DistributionSettingMap.DistributionSetting(name="MotherlodeSize", info="Motherlode size (radius), in meters")
    public final PDist mlSize = new PDist(2.5f, 1.0f);
    @DistributionSettingMap.DistributionSetting(name="MotherlodeHeight", info="Height of motherlode, in meters")
    public final HeightScaledPDist mlHeight = new HeightScaledPDist(32.0f, 16.0f, PDist.Type.normal);
    @DistributionSettingMap.DistributionSetting(name="BranchFrequency", info="Number of branches per motherlode")
    public final PDist brFrequency = new PDist(3.0f, 2.0f);
    @DistributionSettingMap.DistributionSetting(name="BranchInclination", info="Branch angle from horizontal plane, in radians")
    public final PDist brInclination = new PDist(0.0f, 0.55f);
    @DistributionSettingMap.DistributionSetting(name="BranchLength", info="Length of branches, in meters")
    public final PDist brLength = new PDist(120.0f, 60.0f);
    @DistributionSettingMap.DistributionSetting(name="BranchHeightLimit", info="Max vertical distance that a branch may go above/below motherlode, in meters")
    public final HeightScaledPDist brHeightLimit = new HeightScaledPDist(16.0f, 0.0f);
    @DistributionSettingMap.DistributionSetting(name="SegmentForkFrequency", info="Forking rate of each segment")
    public final PDist sgForkFrequency = new PDist(0.2f, 0.0f);
    @DistributionSettingMap.DistributionSetting(name="SegmentForkLengthMult", info="Multiplier to remaining branch length for each fork")
    public final PDist sgForkLenMult = new PDist(0.75f, 0.25f);
    @DistributionSettingMap.DistributionSetting(name="SegmentLength", info="Length of branch segments, in meters")
    public final PDist sgLength = new PDist(15.0f, 6.0f);
    @DistributionSettingMap.DistributionSetting(name="SegmentAngle", info="Angle at which each segment diverges from the previous segment, in radians")
    public final PDist sgAngle = new PDist(0.5f, 0.5f);
    @DistributionSettingMap.DistributionSetting(name="SegmentRadius", info="Cross-section radius of branch segments, in meters")
    public final PDist sgRadius = new PDist(0.5f, 0.3f);
    @DistributionSettingMap.DistributionSetting(name="OreDensity", info="Density multiplier for individual ore blocks")
    public final PDist orDensity = new PDist(1.0f, 0.0f);
    @DistributionSettingMap.DistributionSetting(name="OreRadiusMult", info="Radius multiplier for individual ore blocks")
    public final PDist orRadiusMult = new PDist(1.0f, 0.1f);
    protected static final DistributionSettingMap _veinsSettingMap = new DistributionSettingMap(MapGenVeins.class);

    public MapGenVeins(int distributionID, boolean canGenerate) {
        super(_veinsSettingMap, distributionID, canGenerate);
        this.name = "Veins_" + distributionID;
        this.frequency.set(0.025f, 0.0f, PDist.Type.uniform);
    }

    @Override
    public boolean validate() throws IllegalStateException {
        float r = this.mlSize.getMax() * this.orRadiusMult.getMax();
        if (this.brFrequency.getMax() > 0.0f) {
            r += this.brLength.getMax();
        }
        this.field_75040_a = (int)(r + 15.9999f) / 16;
        return super.validate();
    }

    @Override
    public MapGenOreDistribution.Component generateStructure(MapGenOreDistribution.StructureGroup structureGroup, Random random) {
        float mlZ;
        float mlY;
        float mlX = (random.nextFloat() + (float)structureGroup.chunkX) * 16.0f;
        if (!structureGroup.canPlaceComponentAt(0, mlX, mlY = this.mlHeight.getValue(random, this.field_75039_c, mlX, mlZ = (random.nextFloat() + (float)structureGroup.chunkZ) * 16.0f) + this.heightOffset.getValue(random), mlZ, random)) {
            return null;
        }
        Transform mlMat = new Transform();
        mlMat.translate(mlX, mlY, mlZ);
        mlMat.rotateZ(random.nextFloat() * ((float)Math.PI * 2));
        mlMat.rotateY(random.nextFloat() * ((float)Math.PI * 2));
        mlMat.scale(this.mlSize.getValue(random), this.mlSize.getValue(random), this.mlSize.getValue(random));
        SolidSphereComponent motherlode = new SolidSphereComponent(structureGroup, mlMat);
        structureGroup.addComponent(motherlode, null);
        for (int br = this.brFrequency.getIntValue(random); br > 0; --br) {
            Random brRandom = new Random(random.nextLong());
            Transform segMat = new Transform();
            segMat.translate(mlX, mlY, mlZ);
            segMat.rotateY(brRandom.nextFloat() * ((float)Math.PI * 2));
            segMat.rotateX(-this.brInclination.getValue(brRandom));
            float maxHeight = mlY + this.brHeightLimit.getValue(brRandom, this.field_75039_c, mlX, mlZ);
            float minHeight = mlY - this.brHeightLimit.getValue(brRandom, this.field_75039_c, mlX, mlZ);
            this.generateBranch(structureGroup, this.brLength.getValue(brRandom), maxHeight, minHeight, segMat, motherlode, brRandom);
        }
        return motherlode;
    }

    public void generateBranch(MapGenOreDistribution.StructureGroup structureGroup, float length, float maxHeight, float minHeight, Transform mat, MapGenOreDistribution.Component parent, Random random) {
        float[] pos = new float[3];
        while (length > 0.0f) {
            float segLen = this.sgLength.getValue(random);
            if (segLen > length) {
                segLen = length;
            }
            length -= segLen;
            float segRad = this.sgRadius.getValue(random);
            mat.translate(0.0f, 0.0f, segLen /= 2.0f);
            Transform segMat = mat.clone().scale(segRad, segRad, segLen);
            MapGenOreDistribution.Component component = null;
            switch (this.brType) {
                case Ellipsoid: {
                    component = new SolidSphereComponent(structureGroup, segMat);
                    break;
                }
                case Bezier: {
                    component = new BezierTubeComponent(structureGroup, segMat);
                }
            }
            structureGroup.addComponent(component, parent);
            parent = component;
            mat.translate(0.0f, 0.0f, segLen);
            pos[0] = 0.0f;
            pos[1] = 0.0f;
            pos[2] = 0.0f;
            mat.transformVector(pos);
            if (pos[1] > maxHeight || pos[1] < minHeight) {
                return;
            }
            if (!structureGroup.canPlaceComponentAt(component.func_74877_c() + 1, pos[0], pos[1], pos[2], random)) {
                return;
            }
            if (length <= 0.0f) {
                return;
            }
            for (int axisTheta = this.sgForkFrequency.getIntValue(random); axisTheta > 0; --axisTheta) {
                Random fkRandom = new Random(random.nextLong());
                Transform fkMat = mat.clone();
                float axisTheta1 = fkRandom.nextFloat() * ((float)Math.PI * 2);
                fkMat.rotate(this.sgAngle.getValue(fkRandom), MathHelper.func_76134_b((float)axisTheta1), MathHelper.func_76126_a((float)axisTheta1), 0.0f);
                float fkLenMult = this.sgForkLenMult.getValue(fkRandom);
                this.generateBranch(structureGroup, length * (fkLenMult > 1.0f ? 1.0f : fkLenMult), maxHeight, minHeight, fkMat, component, fkRandom);
            }
            float var18 = random.nextFloat() * ((float)Math.PI * 2);
            mat.rotate(this.sgAngle.getValue(random), MathHelper.func_76134_b((float)var18), MathHelper.func_76126_a((float)var18), 0.0f);
        }
    }

    public String func_143025_a() {
        return "COG:Veins";
    }

    public int getAverageBranchLength() {
        return this.getAverageBranchLength(this.brLength.mean);
    }

    private int getAverageBranchLength(float length) {
        int avgBrLength = 0;
        while (length > 0.0f) {
            float segLen = this.sgLength.mean;
            if (segLen > length) {
                segLen = length;
            }
            avgBrLength = (int)((float)avgBrLength + segLen);
            length -= segLen;
            for (int axisTheta = Math.round(this.sgForkFrequency.mean); axisTheta > 0; --axisTheta) {
                float fkLenMult = this.sgForkLenMult.mean;
                avgBrLength += this.getAverageBranchLength(length * (fkLenMult > 1.0f ? 1.0f : fkLenMult));
            }
        }
        return avgBrLength;
    }

    @Override
    public double getAverageOreCount() {
        double mlVolume = VolumeHelper.sphericalVolume(this.mlSize.mean * this.orRadiusMult.mean);
        double brVolume = VolumeHelper.cylindricalVolume(this.getAverageBranchLength(), this.sgRadius.mean * this.orRadiusMult.mean);
        double totalVolume = (double)this.brFrequency.mean * brVolume + mlVolume;
        return (double)this.orDensity.mean * totalVolume;
    }

    class SolidSphereComponent
    extends MapGenOreDistribution.Component {
        protected final Transform mat;
        protected final Transform invMat;

        public SolidSphereComponent(MapGenOreDistribution.StructureGroup structureGroup, Transform transform) {
            super(structureGroup);
            float rMax = MapGenVeins.this.orRadiusMult.getMax();
            if (rMax < 0.0f) {
                rMax = 0.0f;
            }
            float[] bb = new float[]{-rMax, -rMax, -rMax, rMax, rMax, rMax};
            transform.transformBB(bb);
            this.field_74887_e = new StructureBoundingBox(MathHelper.func_76141_d((float)bb[0]), MathHelper.func_76141_d((float)bb[1]), MathHelper.func_76141_d((float)bb[2]), MathHelper.func_76141_d((float)bb[3]) + 1, MathHelper.func_76141_d((float)bb[4]) + 1, MathHelper.func_76141_d((float)bb[5]) + 1);
            this.mat = transform.clone();
            this.invMat = transform.determinant() != 0.0f ? transform.inverse() : null;
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox bounds) {
            if (this.invMat == null) {
                return true;
            }
            float maxR2 = MapGenVeins.this.orRadiusMult.getMax();
            if (maxR2 < 0.0f) {
                maxR2 = 0.0f;
            }
            maxR2 *= maxR2;
            float minR2 = MapGenVeins.this.orRadiusMult.getMin();
            if (minR2 < 0.0f) {
                minR2 = 0.0f;
            }
            minR2 *= minR2;
            float[] pos = new float[3];
            for (int x = Math.max(this.field_74887_e.field_78897_a, bounds.field_78897_a); x <= Math.min(this.field_74887_e.field_78893_d, bounds.field_78893_d); ++x) {
                for (int y = Math.max(this.field_74887_e.field_78895_b, bounds.field_78895_b); y <= Math.min(this.field_74887_e.field_78894_e, bounds.field_78894_e); ++y) {
                    for (int z = Math.max(this.field_74887_e.field_78896_c, bounds.field_78896_c); z <= Math.min(this.field_74887_e.field_78892_f, bounds.field_78892_f); ++z) {
                        float rMax;
                        pos[0] = (float)x + 0.5f;
                        pos[1] = (float)y + 0.5f;
                        pos[2] = (float)z + 0.5f;
                        this.invMat.transformVector(pos);
                        float r2 = pos[0] * pos[0] + pos[1] * pos[1] + pos[2] * pos[2];
                        if (!(r2 <= maxR2) || r2 > minR2 && r2 > (rMax = MapGenVeins.this.orRadiusMult.getValue(random)) * rMax || MapGenVeins.this.orDensity.getIntValue(random) < 1) continue;
                        this.attemptPlaceBlock(world, random, x, y, z, bounds);
                    }
                }
            }
            super.func_74875_a(world, random, bounds);
            return true;
        }

        @Override
        public void buildWireframe(IGeometryBuilder gb) {
            super.buildWireframe(gb);
            if (MapGenVeins.this.wfHasWireframe) {
                gb.setPositionTransform(this.mat);
                WireframeShapes.addUnitWireSphere(gb, 8, 8);
                gb.setVertexMode(IGeometryBuilder.PrimitiveType.LINE, new int[0]);
                gb.addVertex(new float[]{0.0f, 0.0f, -1.0f});
                gb.addVertex(new float[]{0.0f, 0.0f, 1.0f});
            }
        }
    }

    public static enum BranchType {
        Ellipsoid,
        Bezier;

    }

    private class BezierTubeComponent
    extends MapGenOreDistribution.Component {
        protected float[] mid;
        protected float[] end;
        protected final float rad;
        protected BezierTubeComponent prev;
        protected BezierTubeComponent next;
        protected final interpolationContext context;
        protected final Transform mat;

        public BezierTubeComponent(MapGenOreDistribution.StructureGroup structureGroup, Transform transform) {
            super(structureGroup);
            this.mid = new float[]{0.0f, 0.0f, 0.0f};
            transform.transformVector(this.mid);
            this.end = new float[]{0.0f, 0.0f, 1.0f};
            transform.transformVector(this.end);
            float[] xunit = new float[]{1.0f, 0.0f, 0.0f, 0.0f};
            transform.transformVector(xunit);
            this.rad = MathHelper.func_76129_c((float)(xunit[0] * xunit[0] + xunit[1] * xunit[1] + xunit[2] * xunit[2]));
            float rMax = this.rad * MapGenVeins.this.orRadiusMult.getMax();
            if (rMax < 0.0f) {
                rMax = 0.0f;
            }
            float[] bb = new float[]{-rMax, -rMax, -1.0f, rMax, rMax, 1.0f};
            transform.transformBB(bb);
            this.field_74887_e = new StructureBoundingBox(MathHelper.func_76141_d((float)bb[0]), MathHelper.func_76141_d((float)bb[1]), MathHelper.func_76141_d((float)bb[2]), MathHelper.func_76141_d((float)bb[3]) + 1, MathHelper.func_76141_d((float)bb[4]) + 1, MathHelper.func_76141_d((float)bb[5]) + 1);
            this.context = new interpolationContext();
            this.mat = transform.identity();
        }

        @Override
        public void setChild(MapGenOreDistribution.Component comp) {
            super.setChild(comp);
            BezierTubeComponent bezierTubeComponent = this.next = comp instanceof BezierTubeComponent ? (BezierTubeComponent)comp : null;
            if (this.next != null) {
                float rMax = this.interpolateRadius(0.5f) * MapGenVeins.this.orRadiusMult.getMax();
                if (rMax < 0.0f) {
                    rMax = 0.0f;
                }
                float[] pos = new float[3];
                this.interpolatePosition(pos, 0.5f);
                StructureBoundingBox bb = new StructureBoundingBox(MathHelper.func_76141_d((float)(pos[0] - rMax)), MathHelper.func_76141_d((float)(pos[1] - rMax)), MathHelper.func_76141_d((float)(pos[2] - rMax)), MathHelper.func_76141_d((float)(pos[0] + rMax)) + 1, MathHelper.func_76141_d((float)(pos[1] + rMax)) + 1, MathHelper.func_76141_d((float)(pos[2] + rMax)) + 1);
                this.field_74887_e.func_78888_b(bb);
            }
        }

        @Override
        public void setParent(MapGenOreDistribution.Component comp) {
            super.setParent(comp);
            BezierTubeComponent bezierTubeComponent = this.prev = comp instanceof BezierTubeComponent ? (BezierTubeComponent)comp : null;
            if (this.prev != null) {
                float t = this.prev.next == this ? -0.5f : -1.0f;
                float rMax = this.interpolateRadius(t) * MapGenVeins.this.orRadiusMult.getMax();
                if (rMax < 0.0f) {
                    rMax = 0.0f;
                }
                float[] pos = new float[3];
                this.interpolatePosition(pos, t);
                StructureBoundingBox bb = new StructureBoundingBox(MathHelper.func_76141_d((float)(pos[0] - rMax)), MathHelper.func_76141_d((float)(pos[1] - rMax)), MathHelper.func_76141_d((float)(pos[2] - rMax)), MathHelper.func_76141_d((float)(pos[0] + rMax)) + 1, MathHelper.func_76141_d((float)(pos[1] + rMax)) + 1, MathHelper.func_76141_d((float)(pos[2] + rMax)) + 1);
                this.field_74887_e.func_78888_b(bb);
            }
        }

        public void interpolatePosition(float[] pos, float t) {
            if (t > 0.0f && this.next != null) {
                float nt = 1.0f - t;
                pos[0] = nt * nt * this.mid[0] + 2.0f * t * nt * this.end[0] + t * t * this.next.mid[0];
                pos[1] = nt * nt * this.mid[1] + 2.0f * t * nt * this.end[1] + t * t * this.next.mid[1];
                pos[2] = nt * nt * this.mid[2] + 2.0f * t * nt * this.end[2] + t * t * this.next.mid[2];
            } else if (t < 0.0f && this.prev != null) {
                float nt = 1.0f + t;
                pos[0] = nt * nt * this.mid[0] - 2.0f * t * nt * this.prev.end[0] + t * t * this.prev.mid[0];
                pos[1] = nt * nt * this.mid[1] - 2.0f * t * nt * this.prev.end[1] + t * t * this.prev.mid[1];
                pos[2] = nt * nt * this.mid[2] - 2.0f * t * nt * this.prev.end[2] + t * t * this.prev.mid[2];
            } else {
                float nt = 1.0f - 2.0f * t;
                pos[0] = nt * this.mid[0] + 2.0f * t * this.end[0];
                pos[1] = nt * this.mid[1] + 2.0f * t * this.end[1];
                pos[2] = nt * this.mid[2] + 2.0f * t * this.end[2];
            }
        }

        public void interpolateDerivative(float[] der, float t) {
            if (t > 0.0f && this.next != null) {
                der[0] = 2.0f * ((1.0f - t) * (this.end[0] - this.mid[0]) + t * (this.next.mid[0] - this.end[0]));
                der[1] = 2.0f * ((1.0f - t) * (this.end[1] - this.mid[1]) + t * (this.next.mid[1] - this.end[1]));
                der[2] = 2.0f * ((1.0f - t) * (this.end[2] - this.mid[2]) + t * (this.next.mid[2] - this.end[2]));
            } else if (t < 0.0f && this.prev != null) {
                der[0] = 2.0f * ((1.0f + t) * (this.mid[0] - this.prev.end[0]) - t * (this.prev.end[0] - this.prev.mid[0]));
                der[1] = 2.0f * ((1.0f + t) * (this.mid[1] - this.prev.end[1]) - t * (this.prev.end[1] - this.prev.mid[1]));
                der[2] = 2.0f * ((1.0f + t) * (this.mid[2] - this.prev.end[2]) - t * (this.prev.end[2] - this.prev.mid[2]));
            } else {
                der[0] = 2.0f * (this.end[0] - this.mid[0]);
                der[1] = 2.0f * (this.end[1] - this.mid[1]);
                der[2] = 2.0f * (this.end[2] - this.mid[2]);
            }
        }

        public float interpolateRadius(float t) {
            return t > 0.0f && this.next != null ? (1.0f - t) * this.rad + t * this.next.rad : (t < 0.0f && this.prev != null ? (1.0f + t) * this.rad - t * this.prev.rad : (t <= 0.0f && t > -1.0f ? this.rad : (t > 0.0f && t < 0.5f ? this.rad * MathHelper.func_76129_c((float)(1.0f - 4.0f * t * t)) : 0.0f)));
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox bounds) {
            int var24;
            float maxR = MapGenVeins.this.orRadiusMult.getMax();
            if (maxR < 0.0f) {
                maxR = 0.0f;
            }
            float maxR2 = maxR * maxR;
            float minR = MapGenVeins.this.orRadiusMult.getMin();
            if (minR < 0.0f) {
                minR = 0.0f;
            }
            float minR2 = minR * minR;
            float[] pos = new float[3];
            float[] bb = new float[6];
            boolean innerStep = true;
            this.context.init(0.0f, true);
            do {
                boolean intersects;
                var24 = (int)this.context.radius / 4 + 1;
                if (!(this.context.radius > 0.0f)) continue;
                float step = 0.7f * (float)var24 / this.context.radius;
                int stepCount = (int)(maxR / step) + 1;
                boolean oneBlockThreshold = this.context.radius * maxR < 0.25f;
                this.mat.identity();
                this.mat.translate(this.context.pos[0], this.context.pos[1], this.context.pos[2]);
                this.mat.rotateZInto(this.context.der[0], this.context.der[1], this.context.der[2]);
                this.mat.scale(this.context.radius, this.context.radius, var24);
                bb[0] = -maxR;
                bb[1] = -maxR;
                bb[2] = -1.0f;
                bb[3] = maxR;
                bb[4] = maxR;
                bb[5] = 1.0f;
                this.mat.transformBB(bb);
                boolean bl = intersects = bb[3] >= (float)bounds.field_78897_a && bb[0] <= (float)bounds.field_78893_d && bb[5] >= (float)bounds.field_78896_c && bb[2] <= (float)bounds.field_78892_f && bb[4] >= (float)bounds.field_78895_b && bb[1] <= (float)bounds.field_78894_e;
                if (!intersects) continue;
                for (int x = -stepCount; x < stepCount; ++x) {
                    for (int y = -stepCount; y < stepCount; ++y) {
                        float baseX;
                        pos[0] = (float)x * step;
                        pos[1] = (float)y * step;
                        pos[2] = 0.0f;
                        float r2 = pos[0] * pos[0] + pos[1] * pos[1];
                        if (!(r2 <= maxR2) || r2 > minR2 && r2 > (baseX = MapGenVeins.this.orRadiusMult.getValue(random)) * baseX || oneBlockThreshold && !(this.context.radius * maxR * 4.0f >= random.nextFloat())) continue;
                        this.mat.transformVector(pos);
                        int var25 = MathHelper.func_76141_d((float)pos[0]) - var24 / 2;
                        int baseY = MathHelper.func_76141_d((float)pos[1]) - var24 / 2;
                        int baseZ = MathHelper.func_76141_d((float)pos[2]) - var24 / 2;
                        for (int blockX = var25; blockX < var24 + var25; ++blockX) {
                            for (int blockY = baseY; blockY < var24 + baseY; ++blockY) {
                                for (int blockZ = baseZ; blockZ < var24 + baseZ; ++blockZ) {
                                    if (MapGenVeins.this.orDensity.getIntValue(random) < 1) continue;
                                    this.attemptPlaceBlock(world, random, blockX, blockY, blockZ, bounds);
                                }
                            }
                        }
                    }
                }
            } while (this.context.advance(0.7f * (float)var24));
            super.func_74875_a(world, random, bounds);
            return true;
        }

        @Override
        public void buildWireframe(IGeometryBuilder gb) {
            super.buildWireframe(gb);
            if (MapGenVeins.this.wfHasWireframe) {
                gb.setPositionTransform(null);
                this.context.pos[0] = 2.0f * this.mid[0] - this.end[0];
                this.context.pos[1] = 2.0f * this.mid[1] - this.end[1];
                this.context.pos[2] = 2.0f * this.mid[2] - this.end[2];
                gb.setVertexMode(IGeometryBuilder.PrimitiveType.LINE, new int[0]);
                gb.addVertex(this.context.pos);
                gb.addVertex(this.end);
                int segments = 10;
                gb.setVertexMode(IGeometryBuilder.PrimitiveType.QUAD, segments + 1, segments + 2, 1);
                this.context.init(0.05f, true);
                do {
                    this.mat.identity();
                    this.mat.translate(this.context.pos[0], this.context.pos[1], this.context.pos[2]);
                    this.mat.rotateZInto(this.context.der[0], this.context.der[1], this.context.der[2]);
                    this.mat.scale(this.context.radius, this.context.radius, 0.0f);
                    gb.setPositionTransform(this.mat);
                    float[][] pts = WireframeShapes.getCirclePoints(segments, null);
                    for (int s = 0; s < segments; ++s) {
                        gb.addVertex(pts[s], pts[s], null, null);
                    }
                    gb.addVertexRef(segments);
                } while (this.context.advance(2.0f));
            }
        }

        class interpolationContext {
            public float[] pos = new float[3];
            public float[] der = new float[3];
            public float derLen;
            public float radius;
            public float err;
            public float t = 10.0f;
            public float dt = 0.05f;
            public boolean calcDer;

            public void init(float stepSize, boolean calculateDirection) {
                float f = this.t = BezierTubeComponent.this.prev != null && BezierTubeComponent.this.prev.next != BezierTubeComponent.this ? -1.0f : -0.5f;
                if (stepSize > 0.0f) {
                    this.dt = stepSize;
                }
                BezierTubeComponent.this.interpolatePosition(this.pos, this.t);
                this.radius = BezierTubeComponent.this.interpolateRadius(this.t);
                this.calcDer = calculateDirection;
                if (this.calcDer) {
                    BezierTubeComponent.this.interpolateDerivative(this.der, this.t);
                    this.derLen = MathHelper.func_76129_c((float)(this.der[0] * this.der[0] + this.der[1] * this.der[1] + this.der[2] * this.der[2]));
                    this.der[0] = this.der[0] / this.derLen;
                    this.der[1] = this.der[1] / this.derLen;
                    this.der[2] = this.der[2] / this.derLen;
                } else {
                    this.derLen = 0.0f;
                    this.der[2] = 0.0f;
                    this.der[1] = 0.0f;
                    this.der[0] = 0.0f;
                }
                this.err = 0.0f;
            }

            public boolean advance(float tolerance) {
                float pX = this.pos[0];
                float pY = this.pos[1];
                float pZ = this.pos[2];
                float dX = this.der[0];
                float dY = this.der[1];
                float dZ = this.der[2];
                float r = this.radius;
                do {
                    float maxErr;
                    float d2;
                    float nt = this.t + this.dt;
                    BezierTubeComponent.this.interpolatePosition(this.pos, nt);
                    float deltaX = pX - this.pos[0];
                    float deltaY = pY - this.pos[1];
                    float deltaZ = pZ - this.pos[2];
                    this.err = d2 = deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ;
                    this.radius = BezierTubeComponent.this.interpolateRadius(nt);
                    float avg2R = r + this.radius;
                    if (this.calcDer) {
                        BezierTubeComponent.this.interpolateDerivative(this.der, nt);
                        this.derLen = MathHelper.func_76129_c((float)(this.der[0] * this.der[0] + this.der[1] * this.der[1] + this.der[2] * this.der[2]));
                        this.der[0] = this.der[0] / this.derLen;
                        this.der[1] = this.der[1] / this.derLen;
                        this.der[2] = this.der[2] / this.derLen;
                        deltaX = -dZ * this.der[1] + dY * this.der[2];
                        deltaY = dZ * this.der[0] - dX * this.der[2];
                        deltaZ = -dY * this.der[0] + dX * this.der[1];
                        maxErr = deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ;
                        this.err += avg2R * avg2R * maxErr;
                    }
                    if (this.err > (maxErr = tolerance * tolerance)) {
                        this.dt = (float)((double)this.dt * 0.6);
                        continue;
                    }
                    if (this.err >= maxErr / 5.0f) {
                        this.t += this.dt;
                        return this.t < 0.5f;
                    }
                    this.dt = (float)((double)this.dt * 1.8);
                } while (this.dt >= Math.ulp(this.t) * 2.0f);
                throw new RuntimeException("CustomOreGen: Detected a possible infinite loop during bezier interpolation.  Please report this error.");
            }
        }
    }
}

