/*
 * Decompiled with CFR 0.152.
 */
package assets.creeperspecies;

import assets.creeperspecies.EntityAngelCreeper;
import assets.creeperspecies.EntityMysteryCreeper;
import assets.creeperspecies.EntityNetherStarCreeper;
import assets.creeperspecies.EntityPorkifiedCreeper;
import assets.creeperspecies.ItemCreeperSpawner;
import assets.creeperspecies.ItemMysteryStone;
import assets.creeperspecies.ModelAngelCreeper;
import assets.creeperspecies.RenderAngel;
import assets.creeperspecies.RenderCreeperSpecies;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

@Mod(modid="creeperspecies", name="Creeper Species", version="1.7.2")
public class CreeperSpecies {
    public static Item mysteryStone;
    public static Item egg;
    public static Map<String, Class<? extends EntityLiving>> names;

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        ArrayList<BiomeGenBase> biomes = new ArrayList<BiomeGenBase>();
        for (BiomeGenBase biome : BiomeGenBase.func_150565_n()) {
            if (biome == null) continue;
            biomes.add(biome);
        }
        BiomeGenBase[] spawn = new BiomeGenBase[22];
        spawn = biomes.toArray(spawn);
        Iterator<Map.Entry<String, Class<? extends EntityLiving>>> itr = names.entrySet().iterator();
        int id = 0;
        while (itr.hasNext()) {
            Map.Entry<String, Class<? extends EntityLiving>> ent = itr.next();
            EntityRegistry.registerModEntity(ent.getValue(), (String)ent.getKey(), (int)id, (Object)this, (int)80, (int)1, (boolean)true);
            ItemCreeperSpawner.names.put(id, ent.getKey());
            ++id;
        }
        for (Class<? extends EntityLiving> clazz : names.values()) {
            EntityRegistry.addSpawn(clazz, (int)15, (int)-5, (int)1, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])spawn);
        }
        if (event.getSide().isClient()) {
            CreeperSpecies.addRenderers();
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Mod.EventHandler
    public void preload(FMLPreInitializationEvent event) {
        mysteryStone = new ItemMysteryStone().func_77655_b("MysteryStone").func_111206_d("creeperspecies:MysteryStone");
        egg = new ItemCreeperSpawner().func_77655_b("monsterPlacer").func_111206_d("spawn_egg");
        GameRegistry.registerItem((Item)mysteryStone, (String)"MysteryStone");
        GameRegistry.registerItem((Item)egg, (String)"monsterPlacer");
    }

    @SideOnly(value=Side.CLIENT)
    private static void addRenderers() {
        RenderingRegistry.registerEntityRenderingHandler(EntityAngelCreeper.class, (Render)new RenderAngel(new ModelAngelCreeper(), 0.5f));
        RenderingRegistry.registerEntityRenderingHandler(EntityMysteryCreeper.class, (Render)new RenderCreeperSpecies("mystery"));
        RenderingRegistry.registerEntityRenderingHandler(EntityPorkifiedCreeper.class, (Render)new RenderCreeperSpecies("porkified"));
        RenderingRegistry.registerEntityRenderingHandler(EntityNetherStarCreeper.class, (Render)new RenderCreeperSpecies("netherstargeneral"));
    }

    @SubscribeEvent
    public void onPlayerHurt(LivingHurtEvent event) {
        if (event.source.func_94541_c() && event.entity instanceof EntityPlayer && ((EntityPlayer)event.entity).field_71071_by.func_146026_a(mysteryStone)) {
            event.ammount = 0.0f;
        }
    }

    static {
        names = new HashMap<String, Class<? extends EntityLiving>>();
        names.put("NetherStarCreeper", EntityNetherStarCreeper.class);
        names.put("PorkifiedCreeper", EntityPorkifiedCreeper.class);
        names.put("AngelCreeper", EntityAngelCreeper.class);
        names.put("MysteryCreeper", EntityMysteryCreeper.class);
    }
}

