/*
 * Decompiled with CFR 0.152.
 */
package com.crackedzombie.common;

import com.crackedzombie.common.CommonProxyCrackedZombie;
import com.crackedzombie.common.EntityCrackedZombie;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterators;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.registry.EntityRegistry;
import java.util.Iterator;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.DungeonHooks;
import net.minecraftforge.common.config.Configuration;

@Mod(modid="crackedzombiemod", name="Cracked Zombie Mod", version="1.7.2")
public class CrackedZombie {
    public static final String version = "1.7.2";
    public static final String modid = "crackedzombiemod";
    public static final String name = "Cracked Zombie Mod";
    public static final String zombieName = "CrackedZombie";
    @Mod.Instance(value="crackedzombiemod")
    public static CrackedZombie instance;
    private int zombieSpawnProb;
    private boolean zombieSpawns;
    private boolean spawnCreepers;
    private boolean spawnSkeletons;
    private boolean spawnEnderman;
    private boolean spawnSpiders;
    private boolean spawnSlime;
    private boolean spawnWitches;
    private boolean randomSkins;
    private boolean doorBusting;
    @SidedProxy(clientSide="com.crackedzombie.client.ClientProxyCrackedZombie", serverSide="com.crackedzombie.common.CommonProxyCrackedZombie")
    public static CommonProxyCrackedZombie proxy;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        String generalComments = "Cracked Zombie Mod Config\nMichael Sheppard (crackedEgg)\n For Minecraft Version 1.7.2\n";
        String spawnProbComment = "zombieSpawnProb adjust to probability of zombies spawning\nThe higher the number the more likely zombies will spawn.";
        String zombieComment = "zombieSpawns allows/disallows default zombies spawns, default is false,\nno default minecraft zombies will spawn. Only the CrackedZombies will spawn.\nIf set to true, fewer CrackedZombies will spawn.";
        String creeperComment = "creeperSpawns, set to false to disable creeper spawning, set to true\nif you want to spawn creepers";
        String skeletonComment = "skeletonSpawns, set to false to disable skeleton spawning, set to true\nif you want to spawn skeletons";
        String endermanComment = "endermanSpawns, set to false to disable enderman spawning, set to true\nif you want to spawn enderman";
        String spiderComment = "spiderSpawns, set to false to disable spider spawning, set to true\nif you want to spawn spiders";
        String slimeComment = "slimeSpawns, set to false to disable slime spawning, set to true\nif you want to spawn slimes";
        String witchComment = "witchSpawns, set to false to disable witch spawning, set to true\nif you want to spawn witches";
        String doorBustingComment = "doorBusting, set to true to have zombies try to break down doors,\notherwise set to false. It's quieter.";
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        this.zombieSpawnProb = config.get("general", "zombieSpawnProb", 15, spawnProbComment).getInt();
        this.zombieSpawns = config.get("general", "zombieSpawns", false, zombieComment).getBoolean(false);
        this.spawnCreepers = config.get("general", "spawnCreepers", false, creeperComment).getBoolean(false);
        this.spawnSkeletons = config.get("general", "spawnSkeletons", false, skeletonComment).getBoolean(false);
        this.spawnEnderman = config.get("general", "spawnEnderman", false, endermanComment).getBoolean(false);
        this.spawnSpiders = config.get("general", "spawnSpiders", true, spiderComment).getBoolean(true);
        this.spawnSlime = config.get("general", "spawnSlime", false, slimeComment).getBoolean(false);
        this.spawnWitches = config.get("general", "spawnWitches", true, witchComment).getBoolean(true);
        this.doorBusting = config.get("general", "doorBusting", false, doorBustingComment).getBoolean(false);
        config.addCustomCategoryComment("general", generalComments);
        config.save();
        int id = EntityRegistry.findGlobalUniqueEntityId();
        EntityRegistry.registerGlobalEntityID(EntityCrackedZombie.class, (String)zombieName, (int)id, (int)44975, (int)7969861);
        EntityRegistry.registerModEntity(EntityCrackedZombie.class, (String)zombieName, (int)id, (Object)this, (int)80, (int)3, (boolean)true);
        proxy.registerRenderers();
    }

    @Mod.EventHandler
    public void Init(FMLInitializationEvent evt) {
        DungeonHooks.addDungeonMob((String)zombieName, (int)200);
        ChestGenHooks.addItem((String)"dungeonChest", (WeightedRandomChestContent)new WeightedRandomChestContent(new ItemStack(Items.field_151040_l), 1, 1, 4));
    }

    @Mod.EventHandler
    public void PostInit(FMLPostInitializationEvent event) {
        BiomeDictionary.registerAllBiomesAndGenerateEvents();
        proxy.print("*** Scanning for available biomes");
        BiomeGenBase[] allBiomes = (BiomeGenBase[])Iterators.toArray((Iterator)Iterators.filter((Iterator)Iterators.forArray((Object[])BiomeGenBase.func_150565_n()), (Predicate)Predicates.notNull()), BiomeGenBase.class);
        this.printBiomeList(allBiomes);
        EntityRegistry.addSpawn(EntityCrackedZombie.class, (int)this.zombieSpawnProb, (int)2, (int)10, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])allBiomes);
        if (!this.zombieSpawns) {
            proxy.print("*** Disabling default zombie spawns for all biomes");
            EntityRegistry.removeSpawn(EntityZombie.class, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])allBiomes);
            DungeonHooks.removeDungeonMob((String)"Zombie");
        } else {
            proxy.print("NOT disabling default zombie spawns, there will be fewer crackedZombies!");
        }
        if (!this.spawnCreepers) {
            EntityRegistry.removeSpawn(EntityCreeper.class, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])allBiomes);
            proxy.print("*** Removing creeper spawns");
        }
        if (!this.spawnSkeletons) {
            EntityRegistry.removeSpawn(EntitySkeleton.class, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])allBiomes);
            DungeonHooks.removeDungeonMob((String)"Skeleton");
            proxy.print("*** Removing skeleton spawns and dungeon spawners");
        }
        if (!this.spawnEnderman) {
            EntityRegistry.removeSpawn(EntityEnderman.class, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])allBiomes);
            proxy.print("*** Removing enderman spawns");
        }
        if (!this.spawnSpiders) {
            EntityRegistry.removeSpawn(EntitySpider.class, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])allBiomes);
            DungeonHooks.removeDungeonMob((String)"Spider");
            proxy.print("*** Removing spider spawns and dungeon spawners");
        }
        if (!this.spawnSlime) {
            EntityRegistry.removeSpawn(EntitySlime.class, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])allBiomes);
            proxy.print("*** Removing slime spawns");
        }
        if (!this.spawnWitches) {
            EntityRegistry.removeSpawn(EntityWitch.class, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])allBiomes);
            proxy.print("*** Removing witch spawns");
        }
    }

    public void printBiomeList(BiomeGenBase[] biomes) {
        for (BiomeGenBase bgb : biomes) {
            proxy.print("  >>> Including biome " + bgb.field_76791_y + " for spawning");
        }
    }

    public boolean getRandomSkins() {
        return this.randomSkins;
    }

    public boolean getDoorBusting() {
        return this.doorBusting;
    }
}

