/*
 * Decompiled with CFR 0.152.
 */
package com.kihira.corruption.common.network;

import com.kihira.corruption.Corruption;
import com.kihira.corruption.common.CorruptionDataHelper;
import com.kihira.corruption.common.corruption.CorruptionRegistry;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class PacketEventHandler {
    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onClientPacket(FMLNetworkEvent.ClientCustomPacketEvent e) {
        ByteBuf payload = e.packet.payload();
        int packetID = payload.readInt();
        if (packetID == Packet.CORRUPTION.getID()) {
            EntityPlayer player = Minecraft.func_71410_x().field_71441_e.func_72924_a(ByteBufUtils.readUTF8String((ByteBuf)payload));
            if (player != null) {
                int oldCorr;
                int newCorr = payload.readInt();
                if (newCorr < (oldCorr = CorruptionDataHelper.getCorruptionForPlayer(player))) {
                    Corruption.proxy.uncorruptPlayerSkinPartially((AbstractClientPlayer)player, oldCorr, newCorr);
                }
                if (newCorr == 0) {
                    Corruption.proxy.uncorruptPlayerSkin(player.func_70005_c_());
                } else {
                    Corruption.proxy.corruptPlayerSkin((AbstractClientPlayer)player, oldCorr, newCorr);
                }
                CorruptionDataHelper.setCorruptionForPlayer(player, newCorr);
            }
        } else if (packetID == Packet.CORRUPTIONEFFECT.getID()) {
            String playerName = ByteBufUtils.readUTF8String((ByteBuf)payload);
            String corrName = ByteBufUtils.readUTF8String((ByteBuf)payload);
            boolean shouldAdd = payload.readBoolean();
            boolean allEffects = payload.readBoolean();
            if (shouldAdd) {
                if (allEffects) {
                    for (String name : CorruptionRegistry.corruptionHashMap.keySet()) {
                        CorruptionRegistry.addCorruptionEffect(playerName, name);
                    }
                } else {
                    CorruptionRegistry.addCorruptionEffect(playerName, corrName);
                }
            } else if (allEffects) {
                for (String name : CorruptionRegistry.corruptionHashMap.keySet()) {
                    CorruptionRegistry.removeCorruptionEffect(playerName, name);
                }
            } else {
                CorruptionRegistry.removeCorruptionEffect(playerName, corrName);
            }
        } else if (packetID == Packet.DIARYENTRIES.getID()) {
            NBTTagCompound nbtTagCompound = ByteBufUtils.readTag((ByteBuf)payload);
            CorruptionDataHelper.setPageData(nbtTagCompound.func_150295_c("PageData", 8), (EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        }
    }

    public static FMLProxyPacket getCorruptionUpdatePacket(String playerName, int newCorruption) {
        ByteBuf byteBuf = Unpooled.buffer();
        byteBuf.writeInt(Packet.CORRUPTION.getID());
        ByteBufUtils.writeUTF8String((ByteBuf)byteBuf, (String)playerName);
        byteBuf.writeInt(newCorruption);
        return new FMLProxyPacket(byteBuf, "corruption");
    }

    public static FMLProxyPacket getCorruptionEffectPacket(String playerName, String corrEffect, boolean shouldAdd, boolean allEffects) {
        ByteBuf byteBuf = Unpooled.buffer();
        byteBuf.writeInt(Packet.CORRUPTIONEFFECT.getID());
        ByteBufUtils.writeUTF8String((ByteBuf)byteBuf, (String)playerName);
        ByteBufUtils.writeUTF8String((ByteBuf)byteBuf, (String)corrEffect);
        byteBuf.writeBoolean(shouldAdd);
        byteBuf.writeBoolean(allEffects);
        return new FMLProxyPacket(byteBuf, "corruption");
    }

    public static FMLProxyPacket getDiaryDataPacket(EntityPlayer entityPlayer) {
        ByteBuf byteBuf = Unpooled.buffer();
        NBTTagCompound tagCompound = new NBTTagCompound();
        tagCompound.func_74782_a("PageData", (NBTBase)CorruptionDataHelper.getDiaryDataForPlayer(entityPlayer).func_150295_c("PageData", 8));
        byteBuf.writeInt(Packet.DIARYENTRIES.getID());
        ByteBufUtils.writeTag((ByteBuf)byteBuf, (NBTTagCompound)tagCompound);
        return new FMLProxyPacket(byteBuf, "corruption");
    }

    private static enum Packet {
        CORRUPTION(0),
        CORRUPTIONEFFECT(1),
        DIARYENTRIES(2);

        private final int id;

        private Packet(int id) {
            this.id = id;
        }

        public int getID() {
            return this.id;
        }
    }
}

