/*
 * Decompiled with CFR 0.152.
 */
package com.kihira.corruption.common.corruption;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.kihira.corruption.Corruption;
import com.kihira.corruption.common.corruption.AbstractCorruption;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;

public class CorruptionRegistry {
    public static final List<String> randomCorruptionList = new ArrayList<String>();
    public static final HashMap<String, AbstractCorruption> corruptionHashMap = new HashMap();
    public static final Multimap<String, String> currentCorruptionClient = Multimaps.synchronizedMultimap((Multimap)HashMultimap.create());
    private static final Random rand = new Random();

    public static void registerRandomCorruptionEffect(String corrName) {
        if (randomCorruptionList.contains(corrName)) {
            throw new IllegalArgumentException("The corruption effect " + corrName + " has been registered!");
        }
        randomCorruptionList.add(corrName);
    }

    @SideOnly(value=Side.CLIENT)
    public static void addCorruptionEffect(String playerName, String corrName) {
        if (corrName != null) {
            currentCorruptionClient.put((Object)playerName, (Object)corrName);
            Corruption.logger.info("Applying " + corrName + " from " + playerName);
            corruptionHashMap.get(corrName).init(playerName, FMLCommonHandler.instance().getEffectiveSide());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void removeCorruptionEffect(String playerName, String corrName) {
        currentCorruptionClient.remove((Object)playerName, (Object)corrName);
        Corruption.logger.info("Removing " + corrName + " from " + playerName);
        corruptionHashMap.get(corrName).finish(playerName, FMLCommonHandler.instance().getEffectiveSide());
    }

    public static String getRandomCorruptionEffect(EntityPlayer entityPlayer) {
        String corrName = randomCorruptionList.size() == 0 ? null : (randomCorruptionList.size() == 1 ? randomCorruptionList.get(0) : randomCorruptionList.get(rand.nextInt(randomCorruptionList.size())));
        return corrName;
    }
}

