/*
 * Decompiled with CFR 0.152.
 */
package com.kihira.corruption.client.gui;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.kihira.corruption.Corruption;
import com.kihira.corruption.client.diary.PageData;
import com.kihira.corruption.client.gui.button.GuiButtonPage;
import com.kihira.corruption.client.gui.button.GuiButtonTab;
import com.kihira.corruption.common.CorruptionDataHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiDiary
extends GuiScreen {
    private final EntityPlayer player;
    private final ItemStack theDiary;
    private final int diaryWidth = 192;
    private final int diaryHeight = 192;
    private GuiButtonTab buttonContents;
    private GuiButtonPage buttonNextPage;
    private GuiButtonPage buttonPreviousPage;
    private List<GuiButtonTab> buttonPageTabs = new ArrayList<GuiButtonTab>();
    private HashMap<String, PageData> pageData = new HashMap();
    private BiMap<Integer, String> buttonPageMapping = HashBiMap.create();
    private PageData currentPageData;
    private int currPage;
    public static final ResourceLocation bookGuiTextures = new ResourceLocation("corruption", "book.png");

    public GuiDiary(EntityPlayer player, ItemStack theDiary) {
        this.player = player;
        this.theDiary = theDiary;
        if (theDiary == null || theDiary.func_77973_b() != Corruption.itemDiary) {
            Minecraft.func_71410_x().func_147108_a(null);
        }
    }

    public void func_73866_w_() {
        this.field_146292_n.clear();
        this.loadDiaryData();
        this.buttonContents = new GuiButtonTab(50, this.field_146294_l / 2 + 69, 14, "Contents");
        this.field_146292_n.add(this.buttonContents);
        this.buttonNextPage = new GuiButtonPage(51, this.field_146294_l / 2 + 25, 154, true);
        this.field_146292_n.add(this.buttonNextPage);
        this.buttonPreviousPage = new GuiButtonPage(52, this.field_146294_l / 2 - 58, 154, false);
        this.field_146292_n.add(this.buttonPreviousPage);
        int yOffset = 15;
        int id = 0;
        for (Map.Entry<String, PageData> page : this.pageData.entrySet()) {
            if (page.getKey().equals("contents") || page.getValue() == null) continue;
            this.buttonPageMapping.put((Object)id, (Object)page.getKey());
            this.buttonPageTabs.add(id, new GuiButtonTab(id, this.field_146294_l / 2 + 69, 14 + yOffset, page.getValue().getTabName()));
            this.field_146292_n.add(this.buttonPageTabs.get(id));
            ++id;
            yOffset += 15;
        }
        this.updateButtons();
    }

    private void updateButtons() {
        this.buttonNextPage.field_146125_m = this.currPage < this.currentPageData.getTotalPages() - 1;
        this.buttonPreviousPage.field_146125_m = this.currPage > 0;
    }

    private void loadDiaryData() {
        if (this.theDiary.func_77942_o() && this.theDiary.func_77978_p().func_74767_n("CheatBook")) {
            this.pageData = new HashMap<String, PageData>(PageData.pageMap);
        } else {
            NBTTagCompound tagCompound = CorruptionDataHelper.getDiaryDataForPlayer(this.player);
            if (tagCompound.func_74764_b("PageData")) {
                NBTTagList pageData = tagCompound.func_150295_c("PageData", 8);
                if (pageData != null && pageData.func_74745_c() > 0) {
                    for (int i = 0; i < pageData.func_74745_c(); ++i) {
                        String pageName = pageData.func_150307_f(i);
                        this.pageData.put(pageName, PageData.pageMap.get(pageName));
                    }
                }
            } else {
                this.pageData.put("contents", PageData.pageMap.get("contents"));
            }
        }
        if (this.currentPageData == null) {
            this.loadPageData("contents");
        }
    }

    private void loadPageData(String pageName) {
        this.currentPageData = this.pageData.get(pageName);
        this.currPage = 0;
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146124_l) {
            if (button.field_146127_k == 50) {
                this.loadPageData("contents");
            } else if (button.field_146127_k == 51) {
                if (this.currPage < this.currentPageData.getTotalPages() - 1) {
                    ++this.currPage;
                }
            } else if (button.field_146127_k == 52) {
                if (this.currPage > 0) {
                    --this.currPage;
                }
            } else if (button.field_146127_k < this.pageData.size()) {
                this.loadPageData((String)this.buttonPageMapping.get((Object)button.field_146127_k));
            }
        }
        this.updateButtons();
    }

    public void func_73863_a(int par1, int par2, float par3) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(bookGuiTextures);
        ((Object)((Object)this)).getClass();
        int k = (this.field_146294_l - 192) / 2;
        ((Object)((Object)this)).getClass();
        ((Object)((Object)this)).getClass();
        this.func_73729_b(k, 2, 0, 0, 192, 192);
        if (this.currentPageData != null) {
            String title = I18n.func_135052_a((String)this.currentPageData.getTitle(this.currPage), (Object[])new Object[0]);
            int i1 = this.field_146289_q.func_78256_a(title);
            this.field_146289_q.func_78276_b(EnumChatFormatting.BOLD + title, k + 36 + (104 - i1) / 2, 28, 0);
            title = I18n.func_135052_a((String)this.currentPageData.getSubTitle(), (Object[])new Object[0]);
            i1 = this.field_146289_q.func_78256_a(title);
            GL11.glPushMatrix();
            GL11.glTranslatef((float)((float)this.field_146294_l * 0.25f), (float)20.0f, (float)0.0f);
            GL11.glScalef((float)0.5f, (float)0.5f, (float)0.0f);
            this.field_146289_q.func_78276_b(EnumChatFormatting.ITALIC + title, k + 36 + (114 - i1) / 2, 40, 0);
            GL11.glPopMatrix();
            String s = I18n.func_135052_a((String)"book.pageIndicator", (Object[])new Object[]{this.currPage + 1, this.currentPageData.getTotalPages()});
            String s1 = "";
            if (this.currPage >= 0 && this.currPage < this.currentPageData.getTotalPages()) {
                s1 = this.currentPageData.getPage(this.currPage);
            }
            int l = this.field_146289_q.func_78256_a(s);
            ((Object)((Object)this)).getClass();
            this.field_146289_q.func_78276_b(s, k - l + 192 - 44, 16, 0);
            this.field_146289_q.func_78279_b(I18n.func_135052_a((String)s1, (Object[])new Object[0]), k + 36, 48, 116, 0);
        }
        super.func_73863_a(par1, par2, par3);
    }

    public boolean func_73868_f() {
        return false;
    }
}

